/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.business.rulefetch.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.customsource.CustomSourceFactory;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.ictm.business.rulefetch.AccessRuleAmountTask;
import kd.taxc.ictm.business.rulefetch.RuleEngineService;
import kd.taxc.ictm.business.rulefetch.impl.DefaultRuleAccessConfigServiceImpl;
import kd.taxc.ictm.common.dto.RuleAccessDetailDto;
import kd.taxc.ictm.common.util.DateUtils;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractRuleEnginServiceImpl
implements RuleEngineService {
    private static Log log = LogFactory.getLog(AbstractRuleEnginServiceImpl.class);

    @Override
    public RuleFetchMainDto businessHandler(RuleEngineParamDto ruleEngineParamDto, DefaultRuleAccessConfigServiceImpl ruleAccessConfigService) {
        List<DynamicObject> accessConfigs = ruleAccessConfigService.queryMatchAccessConfig(ruleEngineParamDto);
        List<RuleAccessDetailDto> ruleAccessDetails = accessConfigs.stream().flatMap(p -> ruleAccessConfigService.getRuleAccessDetails(ruleEngineParamDto, (DynamicObject)p).stream()).collect(Collectors.toList());
        AccessRuleAmountTask task = new AccessRuleAmountTask(this, ruleEngineParamDto, ruleAccessDetails);
        List submitReturnFuture = ThreadPoolsService.getInstance().submitReturnFuture((Task)task);
        ArrayList<RuleAccessDetailDto> ruleAccessDetailList = new ArrayList<RuleAccessDetailDto>(ruleAccessDetails.size());
        try {
            for (Future future : submitReturnFuture) {
                Object object = future.get();
                if (!(object instanceof List) || !ObjectUtils.isNotEmpty(object)) continue;
                ruleAccessDetailList.addAll((List)object);
            }
        }
        catch (Exception e) {
            log.error("{}\u83b7\u53d6\u53d6\u6570\u7ed3\u679c\u5f02\u5e38:{}", (Object)this.getClass().getName(), (Object)e.getMessage());
        }
        return this.handleBuildRuleFetchMainDto(ruleEngineParamDto, ruleAccessDetailList, ruleAccessConfigService);
    }

    public List<RuleAccessDetailDto> setRuleAccessDetailBizData(RuleEngineParamDto ruleEngineParamDto, List<RuleAccessDetailDto> ruleAccessDetails) {
        Date endDate;
        Date startDate;
        if (ruleEngineParamDto.getExtendParams().containsKey("skssqq") && ruleEngineParamDto.getExtendParams().containsKey("skssqz")) {
            startDate = (Date)ruleEngineParamDto.getExtendParams().get("skssqq");
            endDate = (Date)ruleEngineParamDto.getExtendParams().get("skssqz");
        } else {
            startDate = ruleEngineParamDto.getSkssqq();
            endDate = ruleEngineParamDto.getSkssqz();
        }
        String startDateStr = DateUtils.format(startDate, "yyyy-MM-dd");
        String endDateStr = DateUtils.format(endDate, "yyyy-MM-dd");
        for (RuleAccessDetailDto ruleAccessDetail : ruleAccessDetails) {
            ruleAccessDetail.setStartDate(startDate);
            ruleAccessDetail.setEndDate(endDate);
            Map<Long, String> selectFields = this.getDatasourceSelectFields(ruleAccessDetail);
            if (selectFields.isEmpty()) {
                ruleAccessDetail.setBizDataList(new ArrayList<Map<String, Object>>(0));
                continue;
            }
            DataSet dataSet = CustomSourceFactory.getInstance().queryBizDataRetDoc(ruleEngineParamDto.getTaxOrgId().longValue(), startDateStr, endDateStr, ruleAccessDetail.getDataSource().longValue(), selectFields.keySet().stream().collect(Collectors.toList()), ruleAccessDetail.getConditionJson(), ruleAccessDetail.getAdvancedConfJson());
            List<Map<String, Object>> bizDataList = this.HandleDataSetToList(dataSet, selectFields);
            ruleAccessDetail.setBizDataList(bizDataList);
        }
        return ruleAccessDetails;
    }

    protected Map<Long, String> getDatasourceSelectFields(RuleAccessDetailDto ruleAccessDetail) {
        HashMap<Long, String> selectFields = new HashMap<Long, String>(1);
        selectFields.put(ruleAccessDetail.getAmountField(), ruleAccessDetail.getAmountFieldNum());
        return selectFields;
    }

    protected List<Map<String, Object>> HandleDataSetToList(DataSet dataSet, Map<Long, String> fields) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (dataSet == null || dataSet.isEmpty()) {
            return result;
        }
        try (DataSet data = dataSet.copy();){
            for (Row row : data) {
                HashMap<String, Object> mapData = new HashMap<String, Object>(fields.size());
                for (Map.Entry<Long, String> entry : fields.entrySet()) {
                    mapData.put(entry.getValue(), row.get("k_" + entry.getKey()));
                }
                result.add(mapData);
            }
        }
        return result;
    }

    protected abstract RuleFetchMainDto handleBuildRuleFetchMainDto(RuleEngineParamDto var1, List<RuleAccessDetailDto> var2, DefaultRuleAccessConfigServiceImpl var3);
}

