/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.business.rulefetch.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.ictm.business.rulefetch.RuleAccessConfigService;
import kd.taxc.ictm.common.dto.RuleAccessDetailDto;
import org.apache.commons.lang3.ObjectUtils;

public class DefaultRuleAccessConfigServiceImpl
implements RuleAccessConfigService {
    protected String entryEntitySign = "entryentity";
    protected String accessConfigEntityName;
    protected String sharingPlanEntityName;
    protected String vatRateSign = "vatrate";
    protected String bizNameSign = "bizname";
    protected String amountFieldSign = "amountfield";
    protected String dataDirectionSign = "datadirection";
    protected String absoluteSign = "absolute";
    protected String filterConditionSign = "filtercondition";
    protected String datatypeSign = "datatype";
    protected String fTableSign = "table";
    protected String advancedConfSign = "advancedconf";
    protected String conditionJsonSign = "conditionjson";
    protected String advancedConfJsonSign = "advancedconfjson";
    protected String accessConfigProjectId = "accessproject.id";
    protected String sharingPlanOrg = "orgentity.org";
    protected String accessConfigOrg = "org";
    protected String accessConfigRuleType = "ruletype";
    protected String ruleTypeSelfValue = "private";
    protected String ruleTypeSharingValue = "public";
    protected String sharingPlanSelectFields;
    protected String accessConfigSelectFields;
    protected String ruleEntity = "ruleentity";
    protected String rule = "rule";

    public DefaultRuleAccessConfigServiceImpl(String accessConfigEntityName, String sharingPlanEntityName) {
        this.accessConfigEntityName = accessConfigEntityName;
        this.sharingPlanEntityName = sharingPlanEntityName;
        this.accessConfigSelectFields = MetadataUtil.getAllSubFieldString((String)this.accessConfigEntityName);
        this.sharingPlanSelectFields = MetadataUtil.getAllSubFieldString((String)this.sharingPlanEntityName);
    }

    @Override
    public List<DynamicObject> queryMatchAccessConfig(RuleEngineParamDto param) {
        List<DynamicObject> privateAccessConfigList = this.queryPrivateAccessConfig(param.getTaxOrgId(), param.getAccessWhereFilter());
        List<DynamicObject> publicAccessConfigList = this.querySharingPlanAccessConfig(param.getTaxOrgId(), param.getSharingPlanWhereFilter());
        publicAccessConfigList = this.handlePublicAccessConfig(privateAccessConfigList, publicAccessConfigList, param);
        privateAccessConfigList.addAll(publicAccessConfigList);
        return privateAccessConfigList;
    }

    protected List<DynamicObject> queryPrivateAccessConfig(Long orgId, QFilter accessWhereFilter) {
        QFilter filter = new QFilter(this.accessConfigOrg, "=", (Object)orgId).and(this.accessConfigRuleType, "=", (Object)this.ruleTypeSelfValue);
        if (ObjectUtils.isNotEmpty((Object)accessWhereFilter)) {
            filter.and(accessWhereFilter);
        }
        List<QFilter> enableQList = this.buildEnableQFilter(this.accessConfigEntityName);
        enableQList.stream().forEach(o -> filter.and(o));
        List<DynamicObject> result = this.queryAccessConfig(filter);
        return result;
    }

    protected List<DynamicObject> querySharingPlanAccessConfig(Long orgId, QFilter sharingPlanWhereFilter) {
        QFilter orgQ = new QFilter(this.sharingPlanOrg, "=", (Object)orgId);
        if (ObjectUtils.isNotEmpty((Object)sharingPlanWhereFilter)) {
            orgQ.and(sharingPlanWhereFilter);
        }
        List<QFilter> enableQList = this.buildEnableQFilter(this.sharingPlanEntityName);
        enableQList.stream().forEach(o -> orgQ.and(o));
        DynamicObjectCollection sharingPlanList = QueryServiceHelper.query((String)this.sharingPlanEntityName, (String)(this.ruleEntity + "." + this.rule), (QFilter[])new QFilter[]{orgQ});
        if (ObjectUtils.isEmpty((Object)sharingPlanList)) {
            return new ArrayList<DynamicObject>(0);
        }
        List ruleIds = sharingPlanList.stream().map(p -> p.getLong(this.ruleEntity + "." + this.rule)).collect(Collectors.toList());
        DynamicObject[] accessConfigList = BusinessDataServiceHelper.load((String)this.accessConfigEntityName, (String)this.accessConfigSelectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", ruleIds)});
        return Arrays.stream(accessConfigList).collect(Collectors.toList());
    }

    protected List<QFilter> buildEnableQFilter(String entityNumber) {
        IDataEntityProperty billStatusProperty;
        IDataEntityProperty statusProperty;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        IDataEntityProperty enableProperty = mainEntityType.findProperty("enable");
        if (ObjectUtils.isNotEmpty((Object)enableProperty) && StringUtil.isNotBlank((CharSequence)enableProperty.getAlias())) {
            filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        }
        if (ObjectUtils.isNotEmpty((Object)(statusProperty = mainEntityType.findProperty("status"))) && StringUtil.isNotBlank((CharSequence)statusProperty.getAlias())) {
            filters.add(new QFilter("status", "=", (Object)"C"));
        }
        if (ObjectUtils.isNotEmpty((Object)(billStatusProperty = mainEntityType.findProperty("billstatus"))) && StringUtil.isNotBlank((CharSequence)billStatusProperty.getAlias())) {
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
        }
        return filters;
    }

    protected List<DynamicObject> queryAccessConfig(QFilter accessWhereFilter) {
        DynamicObject[] accessConfigList = BusinessDataServiceHelper.load((String)this.accessConfigEntityName, (String)this.accessConfigSelectFields, (QFilter[])new QFilter[]{accessWhereFilter});
        return Arrays.stream(accessConfigList).collect(Collectors.toList());
    }

    protected List<DynamicObject> handlePublicAccessConfig(List<DynamicObject> privateAccessConfigList, List<DynamicObject> publicAccessConfigList, RuleEngineParamDto param) {
        List projectIds = privateAccessConfigList.stream().map(p -> p.getLong(this.accessConfigProjectId)).collect(Collectors.toList());
        return publicAccessConfigList.stream().filter(p -> projectIds.stream().noneMatch(t -> t.longValue() == p.getLong(this.accessConfigProjectId))).collect(Collectors.toList());
    }

    @Override
    public List<RuleAccessDetailDto> getRuleAccessDetails(RuleEngineParamDto param, DynamicObject accessConfig) {
        IDataEntityProperty vatRateProperty = MetadataServiceHelper.getDataEntityType((String)this.accessConfigEntityName).findProperty(this.vatRateSign);
        IDataEntityProperty baseDataTypeProperty = MetadataServiceHelper.getDataEntityType((String)this.accessConfigEntityName).findProperty("basedatatype");
        IDataEntityProperty bizNameDataTypeProperty = MetadataServiceHelper.getDataEntityType((String)this.accessConfigEntityName).findProperty(this.bizNameSign);
        Boolean isContainBizName = this.entryEntityIsContainBizName();
        Boolean isContainBaseDatatype = false;
        if (null != baseDataTypeProperty) {
            isContainBaseDatatype = true;
        }
        ArrayList<RuleAccessDetailDto> list = new ArrayList<RuleAccessDetailDto>(8);
        DynamicObjectCollection collection = accessConfig.getDynamicObjectCollection(this.entryEntitySign);
        for (DynamicObject row : collection) {
            String amountFieldNum;
            String amountFieldEntity;
            String baseDataType = "tctb_datasource_entry";
            if (isContainBaseDatatype.booleanValue()) {
                if (StringUtil.equalsIgnoreCase((CharSequence)row.getString("basedatatype"), (CharSequence)"tctb_datasource_entry")) {
                    DynamicObject amountObject = BusinessDataServiceHelper.loadSingleFromCache((Object)row.getDynamicObject(this.amountFieldSign).get("id"), (String)"tctb_datasource_entry", (String)"fieldsubname,fieldname");
                    amountFieldEntity = amountObject.getString("fieldsubname");
                    amountFieldNum = amountObject.getString("fieldname");
                } else {
                    amountFieldEntity = row.getString("basedatatype");
                    amountFieldNum = row.getDynamicObject(this.amountFieldSign).getString("id");
                    baseDataType = row.getString("basedatatype");
                }
            } else {
                if (ObjectUtils.isEmpty((Object)row.getDynamicObject(this.amountFieldSign))) continue;
                amountFieldEntity = row.getDynamicObject(this.amountFieldSign).getString("fieldsubname");
                amountFieldNum = row.getDynamicObject(this.amountFieldSign).getString("fieldname");
            }
            Long amountFieldId = row.getDynamicObject(this.amountFieldSign).getLong("id");
            String dataDirection = row.getString(this.dataDirectionSign);
            String absolute = row.getString(this.absoluteSign);
            String filterCondition = row.getString(this.filterConditionSign);
            String dataType = row.getString(this.datatypeSign);
            Long dataSourceId = row.getDynamicObject(this.fTableSign).getLong("id");
            String advancedConf = row.getString(this.advancedConfSign);
            String conditionJson = row.getString(this.conditionJsonSign);
            String advancedConfJson = row.getString(this.advancedConfJsonSign);
            BigDecimal vatRate = null != vatRateProperty ? row.getBigDecimal(this.vatRateSign) : null;
            String bizName = "";
            if (bizNameDataTypeProperty != null && isContainBizName.booleanValue()) {
                bizName = row.getString(this.bizNameSign);
            }
            RuleAccessDetailDto detailDto = new RuleAccessDetailDto(accessConfig, row.getLong("id"), bizName, dataSourceId, amountFieldId, dataType, dataDirection, absolute, filterCondition, advancedConf, conditionJson, advancedConfJson, amountFieldEntity, amountFieldNum, vatRate, baseDataType, row.getDynamicObject(this.fTableSign).getString("entityname"));
            list.add(detailDto);
        }
        return list;
    }

    protected Boolean entryEntityIsContainBizName() {
        return true;
    }
}

