/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.business.rulefetch.impl;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.ictm.business.rulefetch.RuleEngineDetailDataHandler;
import kd.taxc.ictm.business.rulefetch.impl.AbstractRuleEnginServiceImpl;
import kd.taxc.ictm.business.rulefetch.impl.DefaultRuleAccessConfigServiceImpl;
import kd.taxc.ictm.common.dto.IctmRuleFetchCardDto;
import kd.taxc.ictm.common.dto.IctmRuleFetchCellSummaryDto;
import kd.taxc.ictm.common.dto.IctmRuleFetchDetailDto;
import kd.taxc.ictm.common.dto.IctmRuleFetchMainDto;
import kd.taxc.ictm.common.dto.RuleAccessDetailDto;
import kd.taxc.ictm.common.enums.EntryNameEnum;

public class DetailRuleEngineServiceImpl
extends AbstractRuleEnginServiceImpl {
    RuleEngineDetailDataHandler ruleEngineDetailDataHandler;

    public DetailRuleEngineServiceImpl(RuleEngineDetailDataHandler ruleEngineDetailDataHandler) {
        this.ruleEngineDetailDataHandler = ruleEngineDetailDataHandler;
    }

    @Override
    protected IctmRuleFetchMainDto handleBuildRuleFetchMainDto(RuleEngineParamDto ruleEngineParamDto, List<RuleAccessDetailDto> ruleAccessDetails, DefaultRuleAccessConfigServiceImpl ruleAccessConfigService) {
        this.ruleEngineDetailDataHandler.handleDetailData(ruleAccessDetails);
        String reportItemIdKey = this.ruleEngineDetailDataHandler.getReportItemIdKey();
        IctmRuleFetchMainDto ictmRuleFetchMainDto = new IctmRuleFetchMainDto(ruleEngineParamDto.getTaxOrgId(), ruleEngineParamDto.getSkssqq(), ruleEngineParamDto.getSkssqz(), ruleEngineParamDto.getTemplateId(), ruleEngineParamDto.getDraftPurpose());
        for (RuleAccessDetailDto ruleAccessDetail : ruleAccessDetails) {
            for (Map<String, Object> bizData : ruleAccessDetail.getBizDataList()) {
                BigDecimal originAmount = (BigDecimal)bizData.get(ruleAccessDetail.getAmountFieldNum());
                BigDecimal fetchAmount = this.convertFetchAmount(originAmount, ruleAccessDetail);
                String ruleId = ruleAccessDetail.getAccessConfig().getString("id");
                if (!bizData.containsKey(reportItemIdKey)) continue;
                IctmRuleFetchCellSummaryDto ictmCellSummaryDto = new IctmRuleFetchCellSummaryDto(ruleAccessConfigService.accessConfigEntityName, ruleId, ruleAccessDetail.getAccessConfig().getString(ruleAccessConfigService.accessConfigProjectId), bizData.get(reportItemIdKey).toString(), fetchAmount, originAmount);
                ictmRuleFetchMainDto.getIctmRuleFetchCellSummaryList().add(ictmCellSummaryDto);
                ictmRuleFetchMainDto.getRuleFetchCellSummaryList().add(ictmCellSummaryDto);
                String ruleName = ruleAccessDetail.getAccessConfig().getString("name");
                IctmRuleFetchCardDto ictmCardDto = new IctmRuleFetchCardDto(ruleAccessDetail.getAccessConfig().getLong("id"), ruleName, ruleId, ruleName, ruleEngineParamDto.getTaxOrgId(), fetchAmount);
                ictmCellSummaryDto.getIctmRuleFetchCardList().add(ictmCardDto);
                ictmCellSummaryDto.getRuleFetchCardList().add(ictmCardDto);
                IctmRuleFetchDetailDto ictmRuleFetchDetailDto = new IctmRuleFetchDetailDto(ruleAccessDetail.getAccessDetailId(), ruleAccessDetail.getStartDate(), ruleAccessDetail.getEndDate(), ruleAccessDetail.getBizName(), ruleAccessDetail.getDataSource(), ruleAccessDetail.getAmountField(), ruleAccessDetail.getFetchType(), ruleAccessDetail.getFetchDirection(), fetchAmount, originAmount, ruleAccessDetail.getAbsolute(), ruleAccessDetail.getFilterCondition());
                ictmRuleFetchDetailDto.setConditionJson(ruleAccessDetail.getConditionJson());
                ictmRuleFetchDetailDto.setAdvancedconfjson(ruleAccessDetail.getAdvancedConfJson());
                ictmCardDto.getIctmRuleFetchDetailList().add(ictmRuleFetchDetailDto);
                ictmCardDto.getRuleFetchDetailList().add(ictmRuleFetchDetailDto);
            }
        }
        return ictmRuleFetchMainDto;
    }

    @Override
    protected Map<Long, String> getDatasourceSelectFields(RuleAccessDetailDto ruleAccessDetail) {
        EntryNameEnum entryNameEnum = EntryNameEnum.getEnumByEntryName(ruleAccessDetail.getEntityName());
        if (entryNameEnum == null) {
            return new HashMap<Long, String>(0);
        }
        HashMap<Long, String> result = new HashMap<Long, String>(entryNameEnum.getSelectFields().size() + 1);
        result.putAll(entryNameEnum.getSelectFields());
        result.put(ruleAccessDetail.getAmountField(), ruleAccessDetail.getAmountFieldNum());
        return result;
    }
}

