/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.business.rulefetch.impl;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCardDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCellSummaryDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchDetailDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.ictm.business.relatedparty.RelatedPartyBusiness;
import kd.taxc.ictm.business.rulefetch.impl.AbstractRuleEnginServiceImpl;
import kd.taxc.ictm.business.rulefetch.impl.DefaultRuleAccessConfigServiceImpl;
import kd.taxc.ictm.common.dto.RuleAccessDetailDto;
import kd.taxc.ictm.common.enums.ExternalPaymentSituationEnum;
import org.apache.commons.lang3.ObjectUtils;

public class IctmExternalPaymentSituationRuleEnginServiceImpl
extends AbstractRuleEnginServiceImpl {
    @Override
    protected RuleFetchMainDto handleBuildRuleFetchMainDto(RuleEngineParamDto ruleEngineParamDto, List<RuleAccessDetailDto> ruleAccessDetails, DefaultRuleAccessConfigServiceImpl ruleAccessConfigService) {
        RuleFetchMainDto ruleFetchMainDto = new RuleFetchMainDto(ruleEngineParamDto.getTaxOrgId(), ruleEngineParamDto.getSkssqq(), ruleEngineParamDto.getSkssqz(), ruleEngineParamDto.getTemplateId(), ruleEngineParamDto.getDraftPurpose());
        DynamicObject[] allRelatedParties = RelatedPartyBusiness.getRelatedParties(new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        Map<Long, List<RuleAccessDetailDto>> accessConfigIdAndAccessDetailMap = ruleAccessDetails.stream().collect(Collectors.groupingBy(p -> p.getAccessConfig().getLong("id")));
        for (Map.Entry<Long, List<RuleAccessDetailDto>> entry : accessConfigIdAndAccessDetailMap.entrySet()) {
            String ruleId = "";
            String ruleName = "";
            String projectId = "";
            DynamicObject accessConfig = entry.getValue().get(0).getAccessConfig();
            if (ObjectUtils.isNotEmpty((Object)accessConfig)) {
                ruleId = accessConfig.getString("id");
                ruleName = accessConfig.getString("name");
                projectId = accessConfig.getString(ruleAccessConfigService.accessConfigProjectId);
            }
            AtomicReference<BigDecimal> originalPaymentOverseasAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            AtomicReference<BigDecimal> originalPaymentOverseasRelatedPartyAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            AtomicReference<BigDecimal> fetchPaymentOverseasAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            AtomicReference<BigDecimal> fetchPaymentOverseasRelatedPartyAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            RuleFetchCardDto paymentOverseasCard = new RuleFetchCardDto(ruleName, ruleId, ruleName, ruleEngineParamDto.getTaxOrgId(), fetchPaymentOverseasAmount.get());
            RuleFetchCardDto paymentOverseasRelatedCard = new RuleFetchCardDto(ruleName, ruleId, ruleName, ruleEngineParamDto.getTaxOrgId(), fetchPaymentOverseasAmount.get());
            entry.getValue().forEach(ruleAccessDetail -> {
                BigDecimal detailPaymentOverseasOriginalAmount = BigDecimal.ZERO;
                BigDecimal detailPaymentOverseasRelatedPartyOriginalAmount = BigDecimal.ZERO;
                for (Map<String, Object> bizDataMap : ruleAccessDetail.getBizDataList()) {
                    BigDecimal amount = (BigDecimal)bizDataMap.get(ruleAccessDetail.getAmountFieldNum());
                    detailPaymentOverseasOriginalAmount = detailPaymentOverseasOriginalAmount.add(amount);
                    Long customer = (Long)bizDataMap.get("customer");
                    Long supplier = (Long)bizDataMap.get("supplier");
                    if ((supplier == 0L || !Arrays.stream(allRelatedParties).anyMatch(p -> p.getLong("supplier.id") == supplier.longValue())) && (customer == 0L || !Arrays.stream(allRelatedParties).anyMatch(p -> p.getLong("customer.id") == customer.longValue()))) continue;
                    detailPaymentOverseasRelatedPartyOriginalAmount = detailPaymentOverseasRelatedPartyOriginalAmount.add(amount);
                }
                originalPaymentOverseasAmount.set(((BigDecimal)originalPaymentOverseasAmount.get()).add(detailPaymentOverseasOriginalAmount));
                originalPaymentOverseasRelatedPartyAmount.set(((BigDecimal)originalPaymentOverseasRelatedPartyAmount.get()).add(detailPaymentOverseasRelatedPartyOriginalAmount));
                BigDecimal detailPaymentOverseasFetchAmount = this.convertFetchAmount(detailPaymentOverseasOriginalAmount, (RuleAccessDetailDto)ruleAccessDetail);
                BigDecimal detailPaymentOverseasRelatedPartyFetchAmount = this.convertFetchAmount(detailPaymentOverseasRelatedPartyOriginalAmount, (RuleAccessDetailDto)ruleAccessDetail);
                fetchPaymentOverseasAmount.set(((BigDecimal)fetchPaymentOverseasAmount.get()).add(detailPaymentOverseasFetchAmount));
                fetchPaymentOverseasRelatedPartyAmount.set(((BigDecimal)fetchPaymentOverseasRelatedPartyAmount.get()).add(detailPaymentOverseasRelatedPartyFetchAmount));
                paymentOverseasCard.getRuleFetchDetailList().add(new RuleFetchDetailDto(ruleAccessDetail.getStartDate(), ruleAccessDetail.getEndDate(), ruleAccessDetail.getBizName(), ruleAccessDetail.getDataSource(), ruleAccessDetail.getAmountField(), ruleAccessDetail.getFetchType(), ruleAccessDetail.getFetchDirection(), detailPaymentOverseasFetchAmount, detailPaymentOverseasOriginalAmount, ruleAccessDetail.getAbsolute(), ruleAccessDetail.getFilterCondition()));
                paymentOverseasCard.setAmount((BigDecimal)fetchPaymentOverseasAmount.get());
                paymentOverseasRelatedCard.getRuleFetchDetailList().add(new RuleFetchDetailDto(ruleAccessDetail.getStartDate(), ruleAccessDetail.getEndDate(), ruleAccessDetail.getBizName(), ruleAccessDetail.getDataSource(), ruleAccessDetail.getAmountField(), ruleAccessDetail.getFetchType(), ruleAccessDetail.getFetchDirection(), detailPaymentOverseasRelatedPartyFetchAmount, detailPaymentOverseasRelatedPartyOriginalAmount, ruleAccessDetail.getAbsolute(), ruleAccessDetail.getFilterCondition()));
                paymentOverseasRelatedCard.setAmount((BigDecimal)fetchPaymentOverseasRelatedPartyAmount.get());
            });
            RuleFetchCellSummaryDto paymentOverseasCellSummaryDto = new RuleFetchCellSummaryDto(ruleAccessConfigService.accessConfigEntityName, ruleId, projectId, "", fetchPaymentOverseasAmount.get(), originalPaymentOverseasAmount.get());
            paymentOverseasCellSummaryDto.getRuleFetchCardList().add(paymentOverseasCard);
            paymentOverseasCellSummaryDto.setReportItem(ExternalPaymentSituationEnum.getPaymentToOverseasRowColDimension(Long.parseLong(projectId)));
            ruleFetchMainDto.getRuleFetchCellSummaryList().add(paymentOverseasCellSummaryDto);
            RuleFetchCellSummaryDto paymentOverseasRelatedPartyCellSummaryDto = new RuleFetchCellSummaryDto(ruleAccessConfigService.accessConfigEntityName, ruleId, projectId, "", fetchPaymentOverseasRelatedPartyAmount.get(), originalPaymentOverseasRelatedPartyAmount.get());
            paymentOverseasRelatedPartyCellSummaryDto.getRuleFetchCardList().add(paymentOverseasRelatedCard);
            paymentOverseasRelatedPartyCellSummaryDto.setReportItem(ExternalPaymentSituationEnum.getPaymentToOverseasRelatedPartyRowColDimension(Long.parseLong(projectId)));
            ruleFetchMainDto.getRuleFetchCellSummaryList().add(paymentOverseasRelatedPartyCellSummaryDto);
        }
        return ruleFetchMainDto;
    }

    @Override
    protected Map<Long, String> getDatasourceSelectFields(RuleAccessDetailDto ruleAccessDetail) {
        HashMap<Long, String> selectFields = new HashMap<Long, String>(6);
        selectFields.put(1873390202278765671L, "customer");
        selectFields.put(1873390202278765672L, "supplier");
        selectFields.put(ruleAccessDetail.getAmountField(), ruleAccessDetail.getAmountFieldNum());
        return selectFields;
    }
}

