/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.business.rulefetch.impl;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCardDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCellSummaryDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchDetailDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.ictm.business.rulefetch.impl.AbstractRuleEnginServiceImpl;
import kd.taxc.ictm.business.rulefetch.impl.DefaultRuleAccessConfigServiceImpl;
import kd.taxc.ictm.common.dto.RuleAccessDetailDto;
import org.apache.commons.lang3.ObjectUtils;

public class TotalRuleEnginServiceImpl
extends AbstractRuleEnginServiceImpl {
    public static final String REPORT_ITEM_ACCESS_PROJECT_MAP_KEY = "reportItemAccessProjectMap";

    @Override
    protected RuleFetchMainDto handleBuildRuleFetchMainDto(RuleEngineParamDto ruleEngineParamDto, List<RuleAccessDetailDto> ruleAccessDetails, DefaultRuleAccessConfigServiceImpl ruleAccessConfigService) {
        RuleFetchMainDto ruleFetchMainDto = new RuleFetchMainDto(ruleEngineParamDto.getTaxOrgId(), ruleEngineParamDto.getSkssqq(), ruleEngineParamDto.getSkssqz(), ruleEngineParamDto.getTemplateId(), ruleEngineParamDto.getDraftPurpose());
        Set<String> accessProjectIdList = ruleAccessDetails.stream().map(p -> p.getAccessConfig().getString(ruleAccessConfigService.accessConfigProjectId)).collect(Collectors.toSet());
        Map<String, String> reportItemAccessProjectMap = this.getReportItemAccessProjectMap(ruleEngineParamDto, accessProjectIdList);
        Map<Long, List<RuleAccessDetailDto>> accessConfigIdAndAccessDetailMap = ruleAccessDetails.stream().collect(Collectors.groupingBy(p -> p.getAccessConfig().getLong("id")));
        for (Map.Entry<Long, List<RuleAccessDetailDto>> entry : accessConfigIdAndAccessDetailMap.entrySet()) {
            String ruleId = "";
            String ruleName = "";
            String projectId = "";
            DynamicObject accessConfig = entry.getValue().get(0).getAccessConfig();
            if (ObjectUtils.isNotEmpty((Object)accessConfig)) {
                ruleId = accessConfig.getString("id");
                ruleName = accessConfig.getString("name");
                projectId = accessConfig.getString(ruleAccessConfigService.accessConfigProjectId);
            }
            AtomicReference<BigDecimal> originalAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            AtomicReference<BigDecimal> fetchAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            RuleFetchCardDto cardDto = new RuleFetchCardDto(ruleName, ruleId, ruleName, ruleEngineParamDto.getTaxOrgId(), fetchAmount.get());
            entry.getValue().forEach(ruleAccessDetail -> {
                BigDecimal detailOriginalAmount = BigDecimal.ZERO;
                List amounts = ruleAccessDetail.getBizDataList().stream().map(p -> (BigDecimal)p.get(ruleAccessDetail.getAmountFieldNum())).filter(p -> p != null).collect(Collectors.toList());
                for (BigDecimal amount : amounts) {
                    detailOriginalAmount = detailOriginalAmount.add(amount);
                }
                originalAmount.set(((BigDecimal)originalAmount.get()).add(detailOriginalAmount));
                this.handleRuleAccessDetailDto((RuleAccessDetailDto)ruleAccessDetail);
                BigDecimal detailFetchAmount = this.convertFetchAmount(detailOriginalAmount, (RuleAccessDetailDto)ruleAccessDetail);
                fetchAmount.set(((BigDecimal)fetchAmount.get()).add(detailFetchAmount));
                RuleFetchDetailDto ruleFetchDetailDto = new RuleFetchDetailDto(ruleAccessDetail.getStartDate(), ruleAccessDetail.getEndDate(), ruleAccessDetail.getBizName(), ruleAccessDetail.getDataSource(), ruleAccessDetail.getAmountField(), ruleAccessDetail.getFetchType(), ruleAccessDetail.getFetchDirection(), detailFetchAmount, detailOriginalAmount, ruleAccessDetail.getAbsolute(), ruleAccessDetail.getFilterCondition());
                ruleFetchDetailDto.setConditionJson(ruleAccessDetail.getConditionJson());
                ruleFetchDetailDto.setAdvancedconfjson(ruleAccessDetail.getAdvancedConfJson());
                cardDto.getRuleFetchDetailList().add(ruleFetchDetailDto);
                cardDto.setAmount((BigDecimal)fetchAmount.get());
            });
            RuleFetchCellSummaryDto cellSummaryDto = new RuleFetchCellSummaryDto(ruleAccessConfigService.accessConfigEntityName, ruleId, projectId, "", fetchAmount.get(), originalAmount.get());
            cellSummaryDto.getRuleFetchCardList().add(cardDto);
            cellSummaryDto.setReportItem(reportItemAccessProjectMap.get(projectId));
            ruleFetchMainDto.getRuleFetchCellSummaryList().add(cellSummaryDto);
        }
        return ruleFetchMainDto;
    }

    protected void handleRuleAccessDetailDto(RuleAccessDetailDto ruleAccessDetail) {
    }

    protected Map<String, String> getReportItemAccessProjectMap(RuleEngineParamDto ruleEngineParamDto, Set<String> accessProjectIdList) {
        if (ruleEngineParamDto.getExtendParams().containsKey(REPORT_ITEM_ACCESS_PROJECT_MAP_KEY)) {
            return (Map)ruleEngineParamDto.getExtendParams().get(REPORT_ITEM_ACCESS_PROJECT_MAP_KEY);
        }
        HashMap<String, String> projectIdReportItemMap = new HashMap<String, String>(16);
        if (ObjectUtils.isNotEmpty(accessProjectIdList)) {
            QFilter templateIdQ = new QFilter("template", "=", (Object)ruleEngineParamDto.getTemplateId());
            DynamicObjectCollection col = QueryServiceHelper.query((String)"tpo_template_rule_fetch", (String)"reportitem.number,formula", (QFilter[])new QFilter[]{templateIdQ});
            Map<String, String> formulaReportItemMap = col.stream().filter(row -> StringUtil.isNotBlank((CharSequence)row.getString("reportitem.number"))).collect(Collectors.toMap(a -> a.getString("formula"), b -> b.getString("reportitem.number"), (m, n) -> n));
            List formulaList = col.stream().map(o -> o.getLong("formula")).collect(Collectors.toList());
            QFilter idQ = new QFilter("id", "in", formulaList);
            QFilter dataTypeQ = new QFilter("datatype", "=", (Object)"number");
            QFilter formulaQ = new QFilter("formula", "like", (Object)"{P[%");
            QFilter nameQ = new QFilter("name", "in", accessProjectIdList);
            DynamicObjectCollection ruleFetchCol = QueryServiceHelper.query((String)"tpo_rule_fetch", (String)"id,name", (QFilter[])new QFilter[]{idQ, formulaQ, dataTypeQ, nameQ});
            ruleFetchCol.stream().forEach(row -> {
                String cfr_ignored_0 = (String)projectIdReportItemMap.put(row.getString("name"), (String)formulaReportItemMap.get(row.getString("id")));
            });
        }
        return projectIdReportItemMap;
    }
}

