/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.business.taxmain;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;

public class IctmTaxMainCommonBusiness {
    public static DynamicObject getChinaTaxMainByOrgId(Long orgId) {
        TaxResult taxMainResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId);
        if (taxMainResult.isSuccess()) {
            return (DynamicObject)taxMainResult.getData();
        }
        return null;
    }

    public static DynamicObject getRegisterAreaTaxMainByOrgId(Long orgId) {
        List<DynamicObject> taxMains = IctmTaxMainCommonBusiness.getAllTaxMainByOrgId(Stream.of(orgId).collect(Collectors.toList()));
        if (taxMains == null || taxMains.size() == 0) {
            return null;
        }
        return taxMains.stream().filter(p -> p.getBoolean("registerplace")).findFirst().orElse(null);
    }

    public static List<DynamicObject> getAllTaxMainByOrgId(List<Long> orgIds) {
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgIdsAndIsTaxpayer(orgIds, null);
        if (taxResult.isSuccess()) {
            return (List)taxResult.getData();
        }
        return null;
    }
}

