/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.business.taxorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.perm.PermDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.ictm.business.taxmain.IctmTaxMainCommonBusiness;
import kd.taxc.ictm.common.dto.ControlCompanyDetailDto;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class IctmTaxOrgCommonBusiness {
    public static Map<String, Long> getTaxOrgNumberIdMap(List<String> numbers) {
        TaxResult taxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgNum(numbers);
        if (!taxResult.isSuccess()) {
            return new HashMap<String, Long>(0);
        }
        HashMap<String, Long> result = new HashMap<String, Long>(((List)taxResult.getData()).size());
        for (DynamicObject orgObject : (List)taxResult.getData()) {
            result.put(orgObject.getString("org.number"), orgObject.getLong("id"));
        }
        return result;
    }

    public static List<Long> getTaxOrgNumberIdList(List<String> numbers) {
        ArrayList<Long> resultList = new ArrayList<Long>(12);
        TaxResult taxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByNumber(numbers);
        if (!taxResult.isSuccess() || ObjectUtils.isEmpty((Object)taxResult.getData())) {
            return resultList;
        }
        return Arrays.stream((Object[])taxResult.getData()).map(o -> o.getLong("id")).collect(Collectors.toList());
    }

    public static List<Long> getTaxcMainOrgIdByOrgIdAndIsTaxpayerWithPerm(Collection<Long> orgIdCollection) {
        List orgIds = orgIdCollection.stream().collect(Collectors.toList());
        TaxResult result = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByOrgIdAndIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId(), orgIds);
        if (result.isSuccess()) {
            return (List)result.getData();
        }
        return new ArrayList<Long>(0);
    }

    public static List<Long> getTaxcMainOrgIdByIsTaxpayerWithPerm() {
        TaxResult result = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId());
        if (result.isSuccess()) {
            return (List)result.getData();
        }
        return new ArrayList<Long>(0);
    }

    public static List<Long> getTaxcOrgIdsByIsTaxpayerWithPerm() {
        TaxResult result = TaxcCombineDataServiceHelper.queryTaxcOrgIdsByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId());
        if (result.isSuccess()) {
            return (List)result.getData();
        }
        return new ArrayList<Long>(0);
    }

    public static List<Long> getTaxcOrgIdsWithPerm(IFormView view) {
        DynamicObjectCollection taxOrgs;
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)view);
        QFilter entryEntityFilter = new QFilter("entryentity.entry_taxationsys", "=", (Object)1L);
        if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm() && EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult.getHasPermOrgs())) {
            QFilter authFilter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            taxOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id,org.name as name,entryentity.entry_taxationsys as taxationsys", (QFilter[])new QFilter[]{authFilter, entryEntityFilter});
        } else {
            taxOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id,org.name as name,entryentity.entry_taxationsys as taxationsys", (QFilter[])new QFilter[]{entryEntityFilter});
        }
        return taxOrgs.stream().map(m -> m.getLong("id")).distinct().collect(Collectors.toList());
    }

    public static DynamicObject queryTaxcOrgByOrgId(Long orgId, Long taxationSysId) {
        TaxResult taxResult;
        if (taxationSysId == null) {
            taxationSysId = TaxationsysMappingEnum.CHN.getId();
        }
        if ((taxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgIdsAndTaxationsysId(Stream.of(orgId).collect(Collectors.toList()), (Long)taxationSysId)).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)taxResult.getData()))) {
            return (DynamicObject)((List)taxResult.getData()).get(0);
        }
        return null;
    }

    public static Boolean isHoldingCompany(Long orgId, Date skssqz) {
        Long holdingCompanyOrgId = IctmTaxOrgCommonBusiness.getHoldingCompanyOrgId(skssqz);
        return holdingCompanyOrgId.longValue() == orgId.longValue();
    }

    public static Long getHoldingCompanyOrgId(Date skssqz) {
        String value = (String)SystemParamUtil.getAppParameter((String)"ictm", (String)"controllingcompanydetail");
        if (StringUtils.isEmpty((CharSequence)value)) {
            return 0L;
        }
        List controlCompanyDetails = SerializationUtils.fromJsonStringToList((String)value, ControlCompanyDetailDto.class);
        Optional<ControlCompanyDetailDto> holdingCompanyOptional = controlCompanyDetails.stream().filter(p -> p.getStartdate().compareTo(skssqz) <= 0).sorted((a, b) -> b.getStartdate().compareTo(a.getStartdate())).findFirst();
        if (holdingCompanyOptional.isPresent()) {
            return Long.parseLong(holdingCompanyOptional.get().getCompanyorg());
        }
        return 0L;
    }

    public static Long getAccountOrgBaseCurrencyByTaxOrg(Long taxOrgId, Date skssqq, Date skssqz) {
        Long accountOrgId = IctmTaxOrgCommonBusiness.getAccountOrg(taxOrgId, skssqq, skssqz);
        if (accountOrgId == null) {
            return -1L;
        }
        return IctmTaxOrgCommonBusiness.getAccountOrgBaseCurrency(accountOrgId);
    }

    public static Long getAccountOrg(Long taxOrgId, Date skssqq, Date skssqz) {
        List orgTakeRelationIds = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(taxOrgId), (Date)skssqq, (Date)skssqz);
        if (orgTakeRelationIds.isEmpty()) {
            return null;
        }
        if ((orgTakeRelationIds = orgTakeRelationIds.stream().distinct().collect(Collectors.toList())).size() == 1 && (Long)orgTakeRelationIds.get(0) != 0L) {
            return (Long)orgTakeRelationIds.get(0);
        }
        if (orgTakeRelationIds.size() == 2 && orgTakeRelationIds.contains(taxOrgId)) {
            return orgTakeRelationIds.stream().filter(p -> p.longValue() != taxOrgId.longValue()).findFirst().get();
        }
        if (orgTakeRelationIds.size() > 2 && orgTakeRelationIds.contains(taxOrgId)) {
            return taxOrgId;
        }
        return (Long)orgTakeRelationIds.get(0);
    }

    public static Long getAccountOrgBaseCurrency(Long accountOrgId) {
        Map baseAccountingInfo = BaseDataServiceHelper.getBaseAccountingInfo((Long)accountOrgId);
        if (ObjectUtils.isNotEmpty((Object)baseAccountingInfo)) {
            return (Long)baseAccountingInfo.get("baseCurrencyID");
        }
        return -1L;
    }

    public static List<Long> getOrgIdListByIsTaxpayerWithPermAndZcdWithSsxq() {
        TaxResult taxResultList = PermDataServiceHelper.getUserHasPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"40");
        List orgsList = (List)taxResultList.getData();
        List<DynamicObject> taxMains = IctmTaxMainCommonBusiness.getAllTaxMainByOrgId(orgsList);
        ArrayList<DynamicObject> newtaxMains = new ArrayList<DynamicObject>(16);
        newtaxMains.addAll(taxMains);
        List<Long> taxjurisdictionList = taxMains.stream().filter(p -> p.getBoolean("taxjurisdiction")).map(s -> s.getLong("orgid.id")).collect(Collectors.toList());
        List registerplaceList = newtaxMains.stream().filter(p -> p.getBoolean("registerplace")).map(s -> s.getLong("orgid.id")).collect(Collectors.toList());
        taxjurisdictionList.retainAll(registerplaceList);
        return taxjurisdictionList;
    }

    public static List<DynamicObject> filterIsRegistedAddress(List<Long> orgIds) {
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(12);
        TaxResult registedAddress = TaxcMainDataServiceHelper.filterIsRegistedAddress(orgIds);
        if (ObjectUtils.isNotEmpty((Object)registedAddress) && registedAddress.isSuccess() && ObjectUtils.isNotEmpty((Object)registedAddress.getData())) {
            resultList.addAll((Collection)registedAddress.getData());
        }
        return resultList;
    }

    public static List<DynamicObject> queryTaxcOrgByOrgIdsAndTaxationsysId(List<Long> orgIds, Long taxationsysId) {
        TaxResult result = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgIdsAndTaxationsysId(orgIds, (Long)taxationsysId, (boolean)true);
        if (ObjectUtils.isNotEmpty((Object)result) && result.isSuccess() && ObjectUtils.isNotEmpty((Object)result.getData())) {
            return (List)result.getData();
        }
        return new ArrayList<DynamicObject>();
    }

    public static Map<String, Map<String, String>> queryTaxcOrgUnifiedsocialcodeByOrgIds(List<Long> orgIds, Long taxationsysId) {
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>(12);
        List<DynamicObject> dynamicObjectList = IctmTaxOrgCommonBusiness.queryTaxcOrgByOrgIdsAndTaxationsysId(orgIds, taxationsysId);
        if (ObjectUtils.isNotEmpty(dynamicObjectList)) {
            for (DynamicObject dynamicObject : dynamicObjectList) {
                String orgId = dynamicObject.getString("id");
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                if (!ObjectUtils.isNotEmpty((Object)entryentity)) continue;
                for (DynamicObject dyn : entryentity) {
                    String entry_taxationsysId = dyn.getString("entry_taxationsys.id");
                    HashMap<String, String> orgMap = new HashMap<String, String>(12);
                    String entry_taxpayer = dyn.getString("entry_taxpayer");
                    String entry_unifiedsocialcode = dyn.getString("entry_unifiedsocialcode");
                    orgMap.put("entry_unifiedsocialcode", entry_unifiedsocialcode);
                    orgMap.put("entry_taxpayer", entry_taxpayer);
                    resultMap.put(orgId + "_" + entry_taxationsysId, orgMap);
                }
            }
        }
        return resultMap;
    }

    public static List<Long> queryOrgIdListByIsRegistedAddress(List<Long> orgIds) {
        ArrayList<Long> resultList = new ArrayList<Long>(12);
        List<DynamicObject> dynamicObjectList = IctmTaxOrgCommonBusiness.filterIsRegistedAddress(orgIds);
        if (ObjectUtils.isNotEmpty(dynamicObjectList)) {
            resultList.addAll(dynamicObjectList.stream().map(o -> o.getLong("orgid.id")).collect(Collectors.toList()));
        }
        return resultList;
    }

    public static List<DynamicObject> filterAllIsRegistedAddress() {
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(12);
        TaxResult registedAddress = TaxcMainDataServiceHelper.filterAllIsRegistedAddress();
        if (ObjectUtils.isNotEmpty((Object)registedAddress) && registedAddress.isSuccess() && ObjectUtils.isNotEmpty((Object)registedAddress.getData())) {
            resultList.addAll((Collection)registedAddress.getData());
        }
        return resultList;
    }

    public static List<Long> queryOrgIdListByIsRegistedAddress() {
        ArrayList<Long> resultList = new ArrayList<Long>(12);
        List<DynamicObject> dynamicObjectList = IctmTaxOrgCommonBusiness.filterAllIsRegistedAddress();
        if (ObjectUtils.isNotEmpty(dynamicObjectList)) {
            resultList.addAll(dynamicObjectList.stream().map(o -> o.getLong("orgid.id")).collect(Collectors.toList()));
        }
        return resultList;
    }
}

