/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.common.enums;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AccessConfigFetchRuleEnum {
    RULE_RPTM_RPTF_001("RPT", Stream.of("JYLX01", "JYLX02", "JYLX03", "JYLX04", "JYLX05", "JYLX06").collect(Collectors.toList()), false, "RULE-RPTM-RPTF-001"),
    RULE_RPTM_RPTF_002("RPT", Stream.of("JYLX07").collect(Collectors.toList()), false, "RULE-RPTM-RPTF-002"),
    RULE_RPTM_RPTF_003("NRPT", null, true, "RULE-RPTM-RPTF-003"),
    RULE_RPTM_RPTF_004("EP", null, true, "RULE-RPTM-RPTF-004"),
    RULE_RPTM_RPTF_005("IPS", null, true, "RULE-RPTM-RPTF-005"),
    RULE_RPTM_RPTF_006("CPS", null, true, "RULE-RPTM-RPTF-006"),
    RULE_RPTM_RPTF_007("EI", null, true, "RULE-RPTM-RPTF-007"),
    RULE_RPTM_CbCR_001("CbCR", Stream.of("CbCR1", "CbCR3", "CbCR5").collect(Collectors.toList()), false, "RULE-RPTM-CbCR-001"),
    RULE_RPTM_CbCR_002("CbCR", Stream.of("CbCR2").collect(Collectors.toList()), false, "RULE-RPTM-CbCR-002"),
    RULE_RPTM_CbCR_003("CbCR", Stream.of("CbCR4").collect(Collectors.toList()), false, "RULE-RPTM-CbCR-003"),
    RULE_RPTM_CbCR_004("CbCR", Stream.of("CbCR6").collect(Collectors.toList()), false, "RULE-RPTM-CbCR-004"),
    RULE_RPTM_CbCR_005("CbCR", Stream.of("CbCR7", "CbCR8").collect(Collectors.toList()), false, "RULE-RPTM-CbCR-005"),
    RULE_RPTM_CbCR_006("CbCR", Stream.of("CbCR9").collect(Collectors.toList()), false, "RULE-RPTM-CbCR-006");

    private String rulePurposeNumber;
    private List<String> projectNumber;
    private Boolean isContainsAllProject;
    private String fetchRuleNumber;

    private AccessConfigFetchRuleEnum(String rulePurposeNumber, List<String> projectNumber, Boolean isContainsAllProject, String fetchRuleNumber) {
        this.rulePurposeNumber = rulePurposeNumber;
        this.projectNumber = projectNumber;
        this.isContainsAllProject = isContainsAllProject;
        this.fetchRuleNumber = fetchRuleNumber;
    }

    public String getRulePurposeNumber() {
        return this.rulePurposeNumber;
    }

    public List<String> getProjectNumber() {
        return this.projectNumber;
    }

    public Boolean getContainsAllProject() {
        return this.isContainsAllProject;
    }

    public String getFetchRuleNumber() {
        return this.fetchRuleNumber;
    }

    public static String getFetchRuleNumber(String rulePurposeNumber, String projectNumber) {
        for (AccessConfigFetchRuleEnum value : AccessConfigFetchRuleEnum.values()) {
            if (!value.getRulePurposeNumber().equals(rulePurposeNumber)) continue;
            if (value.getContainsAllProject().booleanValue()) {
                return value.getFetchRuleNumber();
            }
            if (!value.getProjectNumber().contains(projectNumber)) continue;
            return value.getFetchRuleNumber();
        }
        return "";
    }

    public static Boolean isFetchRuleChanged(String rulePurposeNumber, String newProjectNumber, String oldProjectNumber) {
        for (AccessConfigFetchRuleEnum value : AccessConfigFetchRuleEnum.values()) {
            if (!value.getRulePurposeNumber().equals(rulePurposeNumber)) continue;
            if (value.getContainsAllProject().booleanValue()) {
                return false;
            }
            if ((!value.getProjectNumber().contains(newProjectNumber) || value.getProjectNumber().contains(oldProjectNumber)) && (!value.getProjectNumber().contains(oldProjectNumber) || value.getProjectNumber().contains(newProjectNumber))) continue;
            return true;
        }
        return false;
    }
}

