/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.common.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.taxc.ictm.common.dto.IctmRuleEnginParamDto;
import kd.taxc.ictm.common.enums.DynRowDataTypeEnum;

public enum DeclareRuleConfigEnum {
    YXZC_OWNERSHIP_CR("yxzcownershipcr_dynrow", "qtjymxb_jyje", DynRowDataTypeEnum.OTHER_TRANS_DETAIL.getDataTypeCode(), new IctmRuleEnginParamDto(1595581258304477184L, 1595648476010789892L, "0"), new IctmRuleEnginParamDto(1595648476010789888L, 1595685693781457920L, "0")),
    YXZC_OWNERSHIP_SR("yxzcownershipsr_dynrow", "qtjymxb_jyje", DynRowDataTypeEnum.OTHER_TRANS_DETAIL.getDataTypeCode(), new IctmRuleEnginParamDto(1595581258304477184L, 1595648476010789892L, "1"), new IctmRuleEnginParamDto(1595648476010789888L, 1595685693781457920L, "1")),
    WXZC_OWNERSHIP_CR("wxzcownershipcr_dynrow", "qtjymxb_jyje", DynRowDataTypeEnum.OTHER_TRANS_DETAIL.getDataTypeCode(), new IctmRuleEnginParamDto(1595581258304477184L, 1595648476010789893L, "0"), new IctmRuleEnginParamDto(1595648476010789888L, 1595685693781457921L, "0")),
    WXZC_OWNERSHIP_SR("wxzcownershipsr_dynrow", "qtjymxb_jyje", DynRowDataTypeEnum.OTHER_TRANS_DETAIL.getDataTypeCode(), new IctmRuleEnginParamDto(1595581258304477184L, 1595648476010789893L, "1"), new IctmRuleEnginParamDto(1595648476010789888L, 1595685693781457921L, "1")),
    YXZC_USE_CR("yxzcusecr_dynrow", "qtjymxb_jyje", DynRowDataTypeEnum.OTHER_TRANS_DETAIL.getDataTypeCode(), new IctmRuleEnginParamDto(1595581258304477184L, 1595648476010789894L, "0"), new IctmRuleEnginParamDto(1595648476010789888L, 1595685693781457922L, "0")),
    YXZC_USE_SR("yxzcusesr_dynrow", "qtjymxb_jyje", DynRowDataTypeEnum.OTHER_TRANS_DETAIL.getDataTypeCode(), new IctmRuleEnginParamDto(1595581258304477184L, 1595648476010789894L, "1"), new IctmRuleEnginParamDto(1595648476010789888L, 1595685693781457922L, "1")),
    WXZC_USE_CR("wxzcusecr_dynrow", "qtjymxb_jyje", DynRowDataTypeEnum.OTHER_TRANS_DETAIL.getDataTypeCode(), new IctmRuleEnginParamDto(1595581258304477184L, 1595648476010789895L, "0"), new IctmRuleEnginParamDto(1595648476010789888L, 1595685693781457923L, "0")),
    WXZC_USE_SR("wxzcusesr_dynrow", "qtjymxb_jyje", DynRowDataTypeEnum.OTHER_TRANS_DETAIL.getDataTypeCode(), new IctmRuleEnginParamDto(1595581258304477184L, 1595648476010789895L, "1"), new IctmRuleEnginParamDto(1595648476010789888L, 1595685693781457923L, "1")),
    JRZC_CR("jrzcjycr_dynrow", "qtjymxb_jyje", DynRowDataTypeEnum.OTHER_TRANS_DETAIL.getDataTypeCode(), new IctmRuleEnginParamDto(1595581258304477184L, 1595648476010789896L, "0"), new IctmRuleEnginParamDto(1595648476010789888L, 1595685693781457924L, "0")),
    JRZC_SR("jrzcjysr_dynrow", "qtjymxb_jyje", DynRowDataTypeEnum.OTHER_TRANS_DETAIL.getDataTypeCode(), new IctmRuleEnginParamDto(1595581258304477184L, 1595648476010789896L, "1"), new IctmRuleEnginParamDto(1595648476010789888L, 1595685693781457924L, "1")),
    LW_SR("lwjysr_dynrow", "qtjymxb_jyje", DynRowDataTypeEnum.OTHER_TRANS_DETAIL.getDataTypeCode(), new IctmRuleEnginParamDto(1595581258304477184L, 1595648476010789897L, "2"), new IctmRuleEnginParamDto(1595648476010789888L, 1595685693781457925L, "2")),
    LW_ZC("lwjyzc_dynrow", "qtjymxb_jyje", DynRowDataTypeEnum.OTHER_TRANS_DETAIL.getDataTypeCode(), new IctmRuleEnginParamDto(1595581258304477184L, 1595648476010789897L, "3"), new IctmRuleEnginParamDto(1595648476010789888L, 1595685693781457925L, "3")),
    GLZJRT_SR("glzjrtsr_dynrow", "glzjrt_jyjelx", DynRowDataTypeEnum.RELATED_FINANCING.getDataTypeCode(), new IctmRuleEnginParamDto(1595581258304477184L, 1595684761731487894L, "2")),
    GLZJRT_ZC("glzjrtzc_dynrow", "glzjrt_jyjelx", DynRowDataTypeEnum.RELATED_FINANCING.getDataTypeCode(), new IctmRuleEnginParamDto(1595581258304477184L, 1595684761731487894L, "3"));

    private String dynRowDimension;
    private String transAmountColDimension;
    private int dataType;
    private List<IctmRuleEnginParamDto> ruleEnginParams;

    private DeclareRuleConfigEnum(String dynRowDimension, String transAmountColDimension, int dataType, IctmRuleEnginParamDto ... ruleEnginParams) {
        this.dynRowDimension = dynRowDimension;
        this.transAmountColDimension = transAmountColDimension;
        this.dataType = dataType;
        this.ruleEnginParams = Arrays.stream(ruleEnginParams).collect(Collectors.toList());
    }

    public String getDynRowDimension() {
        return this.dynRowDimension;
    }

    public String getTransAmountColDimension() {
        return this.transAmountColDimension;
    }

    public int getDataType() {
        return this.dataType;
    }

    public List<IctmRuleEnginParamDto> getRuleEnginParams() {
        return this.ruleEnginParams;
    }

    public static DeclareRuleConfigEnum getEnumByRowColDimension(String rowDimension, String transAmountColDimension) {
        for (DeclareRuleConfigEnum value : DeclareRuleConfigEnum.values()) {
            if (!value.getDynRowDimension().equals(rowDimension) || !value.getTransAmountColDimension().equals(transAmountColDimension)) continue;
            return value;
        }
        return null;
    }
}

