/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.common.enums;

import kd.taxc.ictm.common.constant.MultiLangEnumBridge;

public enum ExternalPaymentSituationEnum {
    DIVIDEND(1595684761731487844L, new MultiLangEnumBridge("\u80a1\u606f\u3001\u7ea2\u5229", "ExternalPaymentSituationEnum_0", "taxc-ictm"), "dwzfkxqk_gxhl", "dwzfkxqk_xjwzckx", "dwzfkxqk_qzxjwglfzfkx"),
    LABOR_SERVICE_EXPENSES(1595684761731487845L, new MultiLangEnumBridge("\u52b3\u52a1\u8d39\u652f\u51fa", "ExternalPaymentSituationEnum_1", "taxc-ictm"), "dwzfkxqk_lwfzc", "dwzfkxqk_xjwzckx", "dwzfkxqk_qzxjwglfzfkx"),
    PROPERTY_TRANSFER_EXPENSES(1595684761731487846L, new MultiLangEnumBridge("\u8d22\u4ea7\u8f6c\u8ba9\u652f\u51fa", "ExternalPaymentSituationEnum_2", "taxc-ictm"), "dwzfkxqk_cczrzc", "dwzfkxqk_xjwzckx", "dwzfkxqk_qzxjwglfzfkx"),
    INTEREST(1595684761731487847L, new MultiLangEnumBridge("\u5229\u606f", "ExternalPaymentSituationEnum_3", "taxc-ictm"), "dwzfkxqk_lx", "dwzfkxqk_xjwzckx", "dwzfkxqk_qzxjwglfzfkx"),
    RENT(1595684761731487848L, new MultiLangEnumBridge("\u79df\u91d1", "ExternalPaymentSituationEnum_4", "taxc-ictm"), "dwzfkxqk_zj", "dwzfkxqk_xjwzckx", "dwzfkxqk_qzxjwglfzfkx"),
    ROYALTIES(1595684761731487849L, new MultiLangEnumBridge("\u7279\u8bb8\u6743\u4f7f\u7528\u8d39", "ExternalPaymentSituationEnum_5", "taxc-ictm"), "dwzfkxqk_txqsyf", "dwzfkxqk_xjwzckx", "dwzfkxqk_qzxjwglfzfkx"),
    DONATION_EXPENSES(1595684761731487850L, new MultiLangEnumBridge("\u6350\u8d60\u652f\u51fa", "ExternalPaymentSituationEnum_6", "taxc-ictm"), "dwzfkxqk_jzzc", "dwzfkxqk_xjwzckx", "dwzfkxqk_qzxjwglfzfkx"),
    OTHERS(1595684761731487851L, new MultiLangEnumBridge("\u5176\u4ed6", "ExternalPaymentSituationEnum_7", "taxc-ictm"), "dwzfkxqk_qt", "dwzfkxqk_xjwzckx", "dwzfkxqk_qzxjwglfzfkx");

    private Long accessProjectId;
    private MultiLangEnumBridge accessProjectName;
    private String rowDimension;
    private String paymentToOverseasColDimension;
    private String paymentToOverseasRelatedPartyColDimension;

    private ExternalPaymentSituationEnum(Long accessProjectId, MultiLangEnumBridge accessProjectName, String rowDimension, String paymentToOverseasColDimension, String paymentToOverseasRelatedPartyColDimension) {
        this.accessProjectId = accessProjectId;
        this.accessProjectName = accessProjectName;
        this.rowDimension = rowDimension;
        this.paymentToOverseasColDimension = paymentToOverseasColDimension;
        this.paymentToOverseasRelatedPartyColDimension = paymentToOverseasRelatedPartyColDimension;
    }

    public Long getAccessProjectId() {
        return this.accessProjectId;
    }

    public String getAccessProjectName() {
        return this.accessProjectName.loadKDString();
    }

    public String getRowDimension() {
        return this.rowDimension;
    }

    public String getPaymentToOverseasColDimension() {
        return this.paymentToOverseasColDimension;
    }

    public String getPaymentToOverseasRelatedPartyColDimension() {
        return this.paymentToOverseasRelatedPartyColDimension;
    }

    public static String getPaymentToOverseasRowColDimension(Long accessProjectId) {
        for (ExternalPaymentSituationEnum value : ExternalPaymentSituationEnum.values()) {
            if (value.getAccessProjectId().longValue() != accessProjectId.longValue()) continue;
            return value.getRowDimension() + "#" + value.getPaymentToOverseasColDimension();
        }
        return "";
    }

    public static String getPaymentToOverseasRelatedPartyRowColDimension(Long accessProjectId) {
        for (ExternalPaymentSituationEnum value : ExternalPaymentSituationEnum.values()) {
            if (value.getAccessProjectId().longValue() != accessProjectId.longValue()) continue;
            return value.getRowDimension() + "#" + value.getPaymentToOverseasRelatedPartyColDimension();
        }
        return "";
    }
}

