/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.common.enums;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.taxc.ictm.business.membersettle.MemberSettleBusiness;
import kd.taxc.ictm.business.taxorg.IctmTaxOrgCommonBusiness;
import kd.taxc.ictm.common.constant.MultiLangEnumBridge;
import kd.taxc.ictm.common.enums.business.fillformcatalog.EquityInvestmentHideOrShowServiceImpl;
import kd.taxc.ictm.common.enums.business.fillformcatalog.FillFormHideOrShowService;
import kd.taxc.ictm.common.enums.business.fillformcatalog.OnlyDynRowDataFillFormHideOrShowServiceImpl;
import kd.taxc.ictm.common.enums.business.fillformcatalog.TransRelatedFormHideOrShowServiceImpl;
import org.apache.commons.collections4.MapUtils;

public enum FillFormCatalogEnum {
    REPORT_ENTERPRISE_INFO_FILL("G000000", new MultiLangEnumBridge("\u62a5\u544a\u4f01\u4e1a\u4fe1\u606f\u8868", "FillFormCatalogEnum_0", "taxc-ictm"), "tbbdml_bgqyxxb#tbbdml_tbqk", (orgId, startDate, endDate, draftCells) -> true, null),
    RELATED_BUSINESS_TRANS_SUMMARY_FILL("G100000", new MultiLangEnumBridge("\u5173\u8054\u4e1a\u52a1\u5f80\u6765\u6c47\u603b\u8868", "FillFormCatalogEnum_1", "taxc-ictm"), "tbbdml_glywwlhzb#tbbdml_tbqk", (orgId, startDate, endDate, draftCells) -> true, null),
    RELATED_RELATIONSHIP_FILL("G101000", new MultiLangEnumBridge("\u5173\u8054\u5173\u7cfb\u8868", "FillFormCatalogEnum_2", "taxc-ictm"), "tbbdml_glxxb#tbbdml_tbqk", (orgId, startDate, endDate, draftCells) -> true, null),
    TANGIBLE_ASSETS_OWNERSHIP_TRANS_FILL("G102000", new MultiLangEnumBridge("\u6709\u5f62\u8d44\u4ea7\u6240\u6709\u6743\u4ea4\u6613\u8868", "FillFormCatalogEnum_3", "taxc-ictm"), "tbbdml_yxzcsyqjyb#tbbdml_tbqk", (orgId, startDate, endDate, draftCells) -> FillFormCatalogEnum.isDeclareFormFill(draftCells, "gljfgljy_yxzcsyqcr#gljfgljy_jyzje", "gljfgljy_yxzcsyqsr#gljfgljy_jyzje"), new TransRelatedFormHideOrShowServiceImpl()),
    INTANGIBLE_ASSETS_OWNERSHIP_TRANS_FILL("G103000", new MultiLangEnumBridge("\u6709\u5f62\u8d44\u4ea7\u6240\u6709\u6743\u4ea4\u6613\u8868", "FillFormCatalogEnum_3", "taxc-ictm"), "tbbdml_wxzcsyqjyb#tbbdml_tbqk", (orgId, startDate, endDate, draftCells) -> FillFormCatalogEnum.isDeclareFormFill(draftCells, "gljfgljy_wxzcsyqcr#gljfgljy_jyzje", "gljfgljy_wxzcsyqsr#gljfgljy_jyzje"), new TransRelatedFormHideOrShowServiceImpl()),
    TANGIBLE_ASSETS_USE_RIGHTS_TRANS_FILL("G104000", new MultiLangEnumBridge("\u6709\u5f62\u8d44\u4ea7\u4f7f\u7528\u6743\u4ea4\u6613\u8868", "FillFormCatalogEnum_4", "taxc-ictm"), "tbbdml_yxzcusejyb#tbbdml_tbqk", (orgId, startDate, endDate, draftCells) -> FillFormCatalogEnum.isDeclareFormFill(draftCells, "gljfgljy_yxzcusecr#gljfgljy_jyzje", "gljfgljy_yxzcusesr#gljfgljy_jyzje"), new TransRelatedFormHideOrShowServiceImpl()),
    INTANGIBLE_ASSETS_USE_RIGHTS_TRANS_FILL("G105000", new MultiLangEnumBridge("\u6709\u5f62\u8d44\u4ea7\u4f7f\u7528\u6743\u4ea4\u6613\u8868", "FillFormCatalogEnum_4", "taxc-ictm"), "tbbdml_wxzcusejyb#tbbdml_tbqk", (orgId, startDate, endDate, draftCells) -> FillFormCatalogEnum.isDeclareFormFill(draftCells, "gljfgljy_wxzcusecr#gljfgljy_jyzje", "gljfgljy_wxzcusesr#gljfgljy_jyzje"), new TransRelatedFormHideOrShowServiceImpl()),
    FINANCIAL_ASSETS_TRANS_FILL("G106000", new MultiLangEnumBridge("\u91d1\u878d\u8d44\u4ea7\u4ea4\u6613\u8868", "FillFormCatalogEnum_5", "taxc-ictm"), "tbbdml_jrzcjyb#tbbdml_tbqk", (orgId, startDate, endDate, draftCells) -> FillFormCatalogEnum.isDeclareFormFill(draftCells, "gljfgljy_jrzccr#gljfgljy_jyzje", "gljfgljy_jrzcsr#gljfgljy_jyzje"), new TransRelatedFormHideOrShowServiceImpl()),
    INCORPORATING_FUNDS_FILL("G107001", new MultiLangEnumBridge("\u878d\u5165\u8d44\u91d1\u8868", "FillFormCatalogEnum_6", "taxc-ictm"), "tbbdml_rrzjb#tbbdml_tbqk", (orgId, startDate, endDate, draftCells) -> FillFormCatalogEnum.isDeclareFormFill(draftCells, "gljfgljy_zjrtzc#gljfgljy_gljyhj"), new OnlyDynRowDataFillFormHideOrShowServiceImpl()),
    FINANCING_FUNDS_FILL("G107002", new MultiLangEnumBridge("\u878d\u51fa\u8d44\u91d1\u8868", "FillFormCatalogEnum_7", "taxc-ictm"), "tbbdml_rczjb#tbbdml_tbqk", (orgId, startDate, endDate, draftCells) -> FillFormCatalogEnum.isDeclareFormFill(draftCells, "gljfgljy_zjrtsr#gljfgljy_gljyhj"), new OnlyDynRowDataFillFormHideOrShowServiceImpl()),
    RELATED_LABOR_SERVICES_FILL("G108000", new MultiLangEnumBridge("\u5173\u8054\u52b3\u52a1\u8868", "FillFormCatalogEnum_8", "taxc-ictm"), "tbbdml_gllwb#tbbdml_tbqk", (orgId, startDate, endDate, draftCells) -> FillFormCatalogEnum.isDeclareFormFill(draftCells, "gljfgljy_tglwsr#gljfgljy_jyzje", "gljfgljy_jslwzc#gljfgljy_jyzje"), new TransRelatedFormHideOrShowServiceImpl()),
    EQUITY_INVESTMENT_FILL("G109000", new MultiLangEnumBridge("\u6743\u76ca\u6027\u6295\u8d44\u8868", "FillFormCatalogEnum_9", "taxc-ictm"), "tbbdml_qyxtzb#tbbdml_tbqk", (orgId, startDate, endDate, draftCells) -> true, new EquityInvestmentHideOrShowServiceImpl()),
    EXTERNAL_PAYMENT_SITUATION_FILL("G111000", new MultiLangEnumBridge("\u5bf9\u5916\u652f\u4ed8\u6b3e\u9879\u60c5\u51b5\u8868", "FillFormCatalogEnum_10", "taxc-ictm"), "tbbdml_dwzfkxqkb#tbbdml_tbqk", (orgId, startDate, endDate, draftCells) -> FillFormCatalogEnum.isDeclareFormFill(draftCells, "dwzfkxqk_hj#dwzfkxqk_xjwzckx"), null),
    OVERSEAS_RELATED_PARTY_INFO_FILL("G112000", new MultiLangEnumBridge("\u5883\u5916\u5173\u8054\u65b9\u4fe1\u606f\u8868", "FillFormCatalogEnum_11", "taxc-ictm"), "tbbdml_jwglfxxb#tbbdml_tbqk", (orgId, startDate, endDate, draftCells) -> FillFormCatalogEnum.isDeclareFormFill(draftCells, "gljfgljy_yxzcsyqcr#gljfgljy_gljyhj", "gljfgljy_yxzcsyqsr#gljfgljy_gljyhj", "gljfgljy_wxzcsyqcr#gljfgljy_gljyhj", "gljfgljy_wxzcsyqsr#gljfgljy_gljyhj", "gljfgljy_yxzcusecr#gljfgljy_gljyhj", "gljfgljy_yxzcusesr#gljfgljy_gljyhj", "gljfgljy_wxzcusecr#gljfgljy_gljyhj", "gljfgljy_wxzcusesr#gljfgljy_gljyhj", "gljfgljy_jrzccr#gljfgljy_gljyhj", "gljfgljy_jrzcsr#gljfgljy_gljyhj", "gljfgljy_tglwsr#gljfgljy_gljyhj", "gljfgljy_jslwzc#gljfgljy_gljyhj"), null),
    YEAR_RELATED_TRANS_FINANCIAL_ANALYSIS_INDIVIDUAL_FILL("G113010", new MultiLangEnumBridge("\u5e74\u5ea6\u5173\u8054\u4ea4\u6613\u8d22\u52a1\u72b6\u51b5\u5206\u6790\u8868\uff08\u62a5\u544a\u4f01\u4e1a\u4e2a\u522b\u62a5\u8868\u4fe1\u606f\uff09", "FillFormCatalogEnum_12", "taxc-ictm"), "tbbdml_ndgljycwzkfxbgb#tbbdml_tbqk", (orgId, startDate, endDate, draftCells) -> true, new OnlyDynRowDataFillFormHideOrShowServiceImpl()),
    YEAR_RELATED_TRANS_FINANCIAL_ANALYSIS_MERGE_FILL("G113020", new MultiLangEnumBridge("\u5e74\u5ea6\u5173\u8054\u4ea4\u6613\u8d22\u52a1\u72b6\u51b5\u5206\u6790\u8868\uff08\u62a5\u544a\u4f01\u4e1a\u5408\u5e76\u62a5\u8868\u4fe1\u606f\uff09", "FillFormCatalogEnum_13", "taxc-ictm"), "tbbdml_ndgljycwzkfxbhb#tbbdml_tbqk", (orgId, startDate, endDate, draftCells) -> {
        if (draftCells == null || draftCells.size() == 0) {
            return false;
        }
        String colDimensionPrefix = "cwzkfxhb_";
        List<String> cellKeys = draftCells.keySet().stream().filter(p -> p.split("#")[1].startsWith(colDimensionPrefix)).collect(Collectors.toList());
        return FillFormCatalogEnum.isDeclareFormFill(draftCells, cellKeys.toArray(new String[cellKeys.size()]));
    }, null),
    COUNTRY_REPORT_FORM_FILL("G114010,G114011,G114020,G114021,G114030,G114031", new MultiLangEnumBridge("\u56fd\u522b\u62a5\u544a\uff0d\u6240\u5f97\u3001\u7a0e\u6536\u548c\u4e1a\u52a1\u6d3b\u52a8\u56fd\u522b\u5206\u5e03\u8868,\u56fd\u522b\u62a5\u544a\uff0d\u6240\u5f97\u3001\u7a0e\u6536\u548c\u4e1a\u52a1\u6d3b\u52a8\u56fd\u522b\u5206\u5e03\u8868\uff08\u82f1\u6587\uff09,\u56fd\u522b\u62a5\u544a\uff0d\u8de8\u56fd\u4f01\u4e1a\u96c6\u56e2\u6210\u5458\u5b9e\u4f53\u540d\u5355,\u56fd\u522b\u62a5\u544a\uff0d\u8de8\u56fd\u4f01\u4e1a\u96c6\u56e2\u6210\u5458\u5b9e\u4f53\u540d\u5355\uff08\u82f1\u6587\uff09,\u56fd\u522b\u62a5\u544a\uff0d\u9644\u52a0\u8bf4\u660e\u8868,\u56fd\u522b\u62a5\u544a\uff0d\u9644\u52a0\u8bf4\u660e\u8868\uff08\u82f1\u6587\uff09", "FillFormCatalogEnum_14", "taxc-ictm"), "tbbdml_gbbg#tbbdml_tbqk", (orgId, startDate, endDate, draftCells) -> {
        if (!IctmTaxOrgCommonBusiness.isHoldingCompany(orgId, endDate).booleanValue()) {
            return false;
        }
        if (MemberSettleBusiness.orgTaxPeriodExistsData(startDate, endDate).booleanValue()) {
            return true;
        }
        return false;
    }, null);

    private String number;
    private MultiLangEnumBridge name;
    private String cellKey;
    private FillFormCatalogFillState fillFormCatalogFillState;
    private FillFormHideOrShowService fillFormDefaultValueService;

    private FillFormCatalogEnum(String number, MultiLangEnumBridge name, String cellKey, FillFormCatalogFillState fillFormCatalogFillState, FillFormHideOrShowService fillFormDefaultValueService) {
        this.number = number;
        this.name = name;
        this.cellKey = cellKey;
        this.fillFormCatalogFillState = fillFormCatalogFillState;
        this.fillFormDefaultValueService = fillFormDefaultValueService;
    }

    public List<String> getNumber() {
        return Arrays.stream(this.number.split(",")).collect(Collectors.toList());
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public String getCellKey() {
        return this.cellKey;
    }

    public FillFormCatalogFillState getFillFormCatalogFillState() {
        return this.fillFormCatalogFillState;
    }

    public FillFormHideOrShowService getFillFormDefaultValueService() {
        return this.fillFormDefaultValueService;
    }

    public static FillFormCatalogEnum getFillFormCatalogEnumByCellKey(String cellKey) {
        for (FillFormCatalogEnum value : FillFormCatalogEnum.values()) {
            if (!value.getCellKey().equals(cellKey)) continue;
            return value;
        }
        return null;
    }

    private static Boolean isDeclareFormFill(Map<String, String> draftCells, String ... cellKeys) {
        if (MapUtils.isEmpty(draftCells)) {
            return false;
        }
        BigDecimal value = BigDecimal.ZERO;
        for (String cellKey : cellKeys) {
            value = value.add(new BigDecimal(draftCells.get(cellKey) == null ? "0" : draftCells.get(cellKey)));
        }
        return value.compareTo(BigDecimal.ZERO) != 0;
    }

    @FunctionalInterface
    public static interface FillFormCatalogFillState {
        public Boolean fillFormIsNeedFill(Long var1, Date var2, Date var3, Map<String, String> var4);
    }
}

