/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.common.enums.business.button;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.ictm.common.constant.MultiLangEnumBridge;
import kd.taxc.ictm.common.enums.ButtonEnum;
import kd.taxc.ictm.common.enums.EquityInvestmentSituationRowDimensionEnum;
import kd.taxc.ictm.common.enums.business.button.ButtonClickHandle;
import org.apache.commons.collections4.CollectionUtils;

public class EquityInvestmentSituationButtonClickHandleImpl
implements ButtonClickHandle {
    protected String abroadRelatedTransColDimension;
    protected String abroadNonRelatedTransColDimension;
    protected String domesticRelatedTransColDimension;
    protected String domesticNonRelatedTransColDimension;
    protected String totalColDimension;

    public EquityInvestmentSituationButtonClickHandleImpl(String abroadRelatedTransColDimension, String abroadNonRelatedTransColDimension, String domesticRelatedTransColDimension, String domesticNonRelatedTransColDimension, String totalColDimension) {
        this.abroadRelatedTransColDimension = abroadRelatedTransColDimension;
        this.abroadNonRelatedTransColDimension = abroadNonRelatedTransColDimension;
        this.domesticRelatedTransColDimension = domesticRelatedTransColDimension;
        this.domesticNonRelatedTransColDimension = domesticNonRelatedTransColDimension;
        this.totalColDimension = totalColDimension;
    }

    @Override
    public List<String> getRowDimensions(ButtonEnum buttonEnum, List<String> rowIndexes) {
        ArrayList<String> result = new ArrayList<String>(rowIndexes.size());
        for (String rowIndex : rowIndexes) {
            result.add(EquityInvestmentSituationRowDimensionEnum.getEnumValueByRowIndex(rowIndex).getRowDimension());
        }
        return result;
    }

    @Override
    public Map.Entry<Boolean, String> verifyButtonClick(ButtonEnum buttonEnum, List<String> handleDataRowDimensions, Map<String, String> dataMap) {
        HashMap<Boolean, String> result = new HashMap<Boolean, String>(1);
        if (CollectionUtils.isEmpty(handleDataRowDimensions)) {
            result.put(false, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"EquityInvestmentSituationButtonClickHandleImpl_0", (String)"taxc-ictm", (Object[])new Object[0]));
            return (Map.Entry)result.entrySet().stream().findFirst().get();
        }
        List<MultiLangEnumBridge> tipMessages = buttonEnum.getTipMessages();
        String dataRowDimensionSplit = buttonEnum.getDataRowDimension() + "#";
        BigDecimal sumValue = new BigDecimal(dataMap.get(dataRowDimensionSplit + this.abroadRelatedTransColDimension)).add(new BigDecimal(dataMap.get(dataRowDimensionSplit + this.abroadNonRelatedTransColDimension))).add(new BigDecimal(dataMap.get(dataRowDimensionSplit + this.domesticRelatedTransColDimension))).add(new BigDecimal(dataMap.get(dataRowDimensionSplit + this.domesticNonRelatedTransColDimension)));
        if (sumValue.compareTo(new BigDecimal(dataMap.get(dataRowDimensionSplit + this.totalColDimension))) != 0) {
            result.put(false, tipMessages.get(0).loadKDString());
            return (Map.Entry)result.entrySet().stream().findFirst().get();
        }
        if (new BigDecimal(dataMap.get(dataRowDimensionSplit + this.totalColDimension)).compareTo(BigDecimal.ZERO) == 0) {
            result.put(false, tipMessages.get(1).loadKDString());
            return (Map.Entry)result.entrySet().stream().findFirst().get();
        }
        String proportionRowDimensionSplit = buttonEnum.getProportionRowDimension() + "#";
        if (new BigDecimal(dataMap.get(proportionRowDimensionSplit + this.abroadRelatedTransColDimension)).compareTo(BigDecimal.ZERO) < 0 || new BigDecimal(dataMap.get(proportionRowDimensionSplit + this.abroadNonRelatedTransColDimension)).compareTo(BigDecimal.ZERO) < 0 || new BigDecimal(dataMap.get(proportionRowDimensionSplit + this.domesticRelatedTransColDimension)).compareTo(BigDecimal.ZERO) < 0 || new BigDecimal(dataMap.get(proportionRowDimensionSplit + this.domesticNonRelatedTransColDimension)).compareTo(BigDecimal.ZERO) < 0) {
            result.put(true, tipMessages.get(2).loadKDString());
            return (Map.Entry)result.entrySet().stream().findFirst().get();
        }
        return null;
    }

    @Override
    public Map<String, String> buttonClickChangeData(DeclareRequestModel requestModel, ButtonEnum buttonEnum, List<String> handleDataRowDimensions, Map<String, String> dataMap) {
        HashMap<String, String> result = new HashMap<String, String>(4 * handleDataRowDimensions.size());
        String dataRowDimension = buttonEnum.getDataRowDimension() + "#";
        for (String handleDataRowDimension : handleDataRowDimensions) {
            BigDecimal totalValue = new BigDecimal(dataMap.get(handleDataRowDimension + "#" + this.totalColDimension));
            BigDecimal buttonTotalValue = new BigDecimal(dataMap.get(dataRowDimension + this.totalColDimension));
            BigDecimal abroadRelatedTransValue = totalValue.multiply(new BigDecimal(dataMap.get(dataRowDimension + this.abroadRelatedTransColDimension)).divide(buttonTotalValue, 30, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
            BigDecimal abroadNonRelatedTransValue = totalValue.multiply(new BigDecimal(dataMap.get(dataRowDimension + this.abroadNonRelatedTransColDimension)).divide(buttonTotalValue, 30, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
            BigDecimal domesticRelatedTransValue = totalValue.multiply(new BigDecimal(dataMap.get(dataRowDimension + this.domesticRelatedTransColDimension)).divide(buttonTotalValue, 30, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
            BigDecimal domesticNonRelatedTransValue = totalValue.multiply(new BigDecimal(dataMap.get(dataRowDimension + this.domesticNonRelatedTransColDimension)).divide(buttonTotalValue, 30, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
            BigDecimal diffValue = totalValue.subtract(abroadRelatedTransValue).subtract(abroadNonRelatedTransValue).subtract(domesticRelatedTransValue).subtract(domesticNonRelatedTransValue);
            if (diffValue.compareTo(BigDecimal.ZERO) != 0) {
                if (abroadRelatedTransValue.compareTo(BigDecimal.ZERO) != 0) {
                    abroadRelatedTransValue = abroadRelatedTransValue.add(diffValue);
                } else if (abroadNonRelatedTransValue.compareTo(BigDecimal.ZERO) != 0) {
                    abroadNonRelatedTransValue = abroadNonRelatedTransValue.add(diffValue);
                } else if (domesticRelatedTransValue.compareTo(BigDecimal.ZERO) != 0) {
                    domesticRelatedTransValue = domesticRelatedTransValue.add(diffValue);
                }
            }
            result.put(handleDataRowDimension + "#" + this.abroadRelatedTransColDimension, abroadRelatedTransValue.toString());
            result.put(handleDataRowDimension + "#" + this.abroadNonRelatedTransColDimension, abroadNonRelatedTransValue.toString());
            result.put(handleDataRowDimension + "#" + this.domesticRelatedTransColDimension, domesticRelatedTransValue.toString());
            result.put(handleDataRowDimension + "#" + this.domesticNonRelatedTransColDimension, domesticNonRelatedTransValue.toString());
        }
        return result;
    }
}

