/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.common.enums.business.button;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.ictm.common.enums.ButtonEnum;
import kd.taxc.ictm.common.enums.business.button.ButtonClickHandle;
import kd.taxc.ictm.common.util.DateUtils;
import org.apache.commons.collections4.CollectionUtils;

public class RelatedFinancingButtonClickHandleImpl
implements ButtonClickHandle {
    private String agreeInterestRateColDimension = "glzjrt_ydll";
    private String transAmountColDimension = "glzjrt_jyjelx";
    private String loanAmountColDimension = "glzjrt_jdjebj";
    private String yearStartDateColDimension = "glzjrt_startdate";
    private String yearEndDateColDimension = "glzjrt_enddate";

    @Override
    public List<String> getRowDimensions(ButtonEnum buttonEnum, List<String> rowIndexes) {
        return rowIndexes.stream().map(p -> buttonEnum.getDataRowDimension() + "#" + p).collect(Collectors.toList());
    }

    @Override
    public Map.Entry<Boolean, String> verifyButtonClick(ButtonEnum buttonEnum, List<String> handleDataRowDimensions, Map<String, String> dataMap) {
        HashMap<Boolean, String> result = new HashMap<Boolean, String>(1);
        if (CollectionUtils.isEmpty(handleDataRowDimensions)) {
            result.put(false, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"RelatedFinancingButtonClickHandleImpl_0", (String)"taxc-ictm", (Object[])new Object[0]));
            return (Map.Entry)result.entrySet().stream().findFirst().get();
        }
        ArrayList<String> agreeInterestRateLessThanZeroRowIndexes = new ArrayList<String>(8);
        ArrayList<String> transAmountLessThanZeroRowIndexes = new ArrayList<String>(8);
        for (String handleDataRowDimension : handleDataRowDimensions) {
            if (new BigDecimal(dataMap.get(handleDataRowDimension + "#" + this.agreeInterestRateColDimension)).compareTo(BigDecimal.ZERO) <= 0) {
                agreeInterestRateLessThanZeroRowIndexes.add(handleDataRowDimension.split("#")[1]);
            }
            if (new BigDecimal(dataMap.get(handleDataRowDimension + "#" + this.transAmountColDimension)).compareTo(BigDecimal.ZERO) > 0) continue;
            transAmountLessThanZeroRowIndexes.add(handleDataRowDimension.split("#")[1]);
        }
        if (agreeInterestRateLessThanZeroRowIndexes.size() > 0) {
            result.put(false, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7ea6\u5b9a\u5229\u7387\u975e\u6b63\u6570\uff0c\u8bf7\u4fee\u6539", (String)"RelatedFinancingButtonClickHandleImpl_1", (String)"taxc-ictm", (Object[])new Object[0]), String.join((CharSequence)"\u3001", agreeInterestRateLessThanZeroRowIndexes)));
            return (Map.Entry)result.entrySet().stream().findFirst().get();
        }
        if (transAmountLessThanZeroRowIndexes.size() > 0) {
            result.put(false, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ea4\u6613\u91d1\u989d\uff08\u5229\u606f\uff09\u975e\u6b63\u6570\uff0c\u8bf7\u4fee\u6539", (String)"RelatedFinancingButtonClickHandleImpl_2", (String)"taxc-ictm", (Object[])new Object[0]), String.join((CharSequence)"\u3001", transAmountLessThanZeroRowIndexes)));
            return (Map.Entry)result.entrySet().stream().findFirst().get();
        }
        return null;
    }

    @Override
    public Map<String, String> buttonClickChangeData(DeclareRequestModel requestModel, ButtonEnum buttonEnum, List<String> handleDataRowDimensions, Map<String, String> dataMap) {
        HashMap<String, String> result = new HashMap<String, String>(handleDataRowDimensions.size() * 3);
        Date startDate = DateUtils.stringToDate(requestModel.getSkssqq());
        String yearStartDateStr = DateUtils.format(DateUtils.getFirstDateOfYear(startDate));
        String yearEndDateStr = DateUtils.format(DateUtils.getLastDateOfYear(startDate));
        for (String handleDataRowDimension : handleDataRowDimensions) {
            String rowDimension = handleDataRowDimension + "#";
            result.put(rowDimension + this.loanAmountColDimension, new BigDecimal(dataMap.get(rowDimension + this.transAmountColDimension)).divide(new BigDecimal(dataMap.get(rowDimension + this.agreeInterestRateColDimension)), 18, RoundingMode.HALF_UP).toString());
            result.put(rowDimension + this.yearStartDateColDimension, yearStartDateStr);
            result.put(rowDimension + this.yearEndDateColDimension, yearEndDateStr);
        }
        return result;
    }
}

