/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.common.enums.business.entryname;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.ictm.common.dto.OtherTransDetailDto;
import kd.taxc.ictm.common.dto.RuleAccessDetailDto;
import kd.taxc.ictm.common.enums.business.entryname.DynRowEntityConvert;

public class OtherTransDetailConvertImpl
implements DynRowEntityConvert<OtherTransDetailDto> {
    @Override
    public List<OtherTransDetailDto> convertData(RuleAccessDetailDto ruleAccessDetail, Map<String, Object> extendParamMap, String reportItemKey) {
        ArrayList<OtherTransDetailDto> result = new ArrayList<OtherTransDetailDto>(ruleAccessDetail.getBizDataList().size());
        List relatedParties = (List)extendParamMap.get("relatedParties");
        String rulePurposeNumber = ruleAccessDetail.getAccessConfig().getDynamicObject("rulepurpose").getString("number");
        if ("RPT".equals(rulePurposeNumber)) {
            relatedParties = relatedParties.stream().filter(p -> p.getLong("id") != NON_RELATED_PARTY_ID.longValue()).collect(Collectors.toList());
        } else if ("NRPT".equals(rulePurposeNumber)) {
            relatedParties = relatedParties.stream().filter(p -> p.getLong("id") == NON_RELATED_PARTY_ID.longValue()).collect(Collectors.toList());
        }
        DynamicObjectCollection transactionContent = ruleAccessDetail.getAccessConfig().getDynamicObjectCollection("transactioncontent");
        for (Map<String, Object> bizData : ruleAccessDetail.getBizDataList()) {
            Long relatedPartyId = (Long)bizData.get("relatedparty");
            DynamicObject relatedParty = relatedParties.stream().filter(p -> p.getLong("id") == relatedPartyId.longValue()).findFirst().orElse(null);
            if (relatedParty == null || !relatedParty.get("enable").equals("1")) continue;
            DynamicObject area = relatedParty.getDynamicObject("area");
            Long countryId = 0L;
            String countryName = "";
            if (area != null) {
                countryId = area.getLong("id");
                countryName = area.getString("projectname");
            }
            String reportItemId = UUID.randomUUID();
            OtherTransDetailDto otherTransDetailDto = new OtherTransDetailDto(ruleAccessDetail.getEntityName(), (Long)bizData.get("id"), relatedPartyId, relatedParty.getString("name"), countryId, countryName, ruleAccessDetail.getAccessConfig().getLong("itemname.id"), ruleAccessDetail.getAccessConfig().getString("bizname"), transactionContent.stream().map(p -> p.getLong("fbasedataid.id")).collect(Collectors.toList()), transactionContent.stream().map(p -> p.getString("fbasedataid.projectname")).collect(Collectors.toList()));
            bizData.put(reportItemKey, reportItemId);
            otherTransDetailDto.getReportItemId().add(reportItemId);
            result.add(otherTransDetailDto);
        }
        return result;
    }
}

