/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.common.enums.business.entryname;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.ictm.common.dto.RelatedFinancingDto;
import kd.taxc.ictm.common.dto.RuleAccessDetailDto;
import kd.taxc.ictm.common.enums.business.entryname.DynRowEntityConvert;

public class RelatedFinancingConvertImpl
implements DynRowEntityConvert<RelatedFinancingDto> {
    @Override
    public List<RelatedFinancingDto> convertData(RuleAccessDetailDto ruleAccessDetail, Map<String, Object> extendParamMap, String reportItemKey) {
        ArrayList<RelatedFinancingDto> result = new ArrayList<RelatedFinancingDto>(ruleAccessDetail.getBizDataList().size());
        List relatedParties = (List)extendParamMap.get("relatedParties");
        DynamicObjectCollection transactionContent = ruleAccessDetail.getAccessConfig().getDynamicObjectCollection("transactioncontent");
        for (Map<String, Object> bizData : ruleAccessDetail.getBizDataList()) {
            Long relatedPartyId = (Long)bizData.get("relatedparty");
            DynamicObject relatedParty = relatedParties.stream().filter(p -> p.getLong("id") == relatedPartyId.longValue()).findFirst().orElse(null);
            if (relatedParty == null || !relatedParty.get("enable").equals("1")) continue;
            DynamicObject area = relatedParty.getDynamicObject("area");
            String reportItemId = UUID.randomUUID();
            BigDecimal agreedInterestRate = (BigDecimal)bizData.get("agreedinterestrate");
            agreedInterestRate = agreedInterestRate == null ? BigDecimal.ZERO : agreedInterestRate.divide(new BigDecimal(100));
            RelatedFinancingDto relatedFinancing = new RelatedFinancingDto(ruleAccessDetail.getEntityName(), (Long)bizData.get("id"), relatedPartyId, relatedParty.getString("name"), area.getLong("id"), area.getString("projectname"), ruleAccessDetail.getAccessConfig().getLong("itemname.id"), ruleAccessDetail.getAccessConfig().getString("bizname"), transactionContent.stream().map(p -> p.getLong("fbasedataid.id")).collect(Collectors.toList()), transactionContent.stream().map(p -> p.getString("fbasedataid.projectname")).collect(Collectors.toList()), (BigDecimal)bizData.get("principalamount"), (Date)bizData.get("yearstartdate"), (Date)bizData.get("yearenddate"), agreedInterestRate);
            bizData.put(reportItemKey, reportItemId);
            relatedFinancing.getReportItemId().add(reportItemId);
            result.add(relatedFinancing);
        }
        return result;
    }
}

