/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.common.enums.business.entryname;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.ictm.common.dto.OtherTransDetailDto;
import kd.taxc.ictm.common.dto.RelatedFinancingDto;
import kd.taxc.ictm.common.dto.RuleAccessDetailDto;
import kd.taxc.ictm.common.enums.business.entryname.DynRowEntityConvert;

public class VoucherNewToRelatedFinancingConvertImpl
implements DynRowEntityConvert<RelatedFinancingDto> {
    @Override
    public List<RelatedFinancingDto> convertData(RuleAccessDetailDto ruleAccessDetail, Map<String, Object> extendParamMap, String reportItemKey) {
        ArrayList<RelatedFinancingDto> result = new ArrayList<RelatedFinancingDto>(ruleAccessDetail.getBizDataList().size());
        List relatedParties = (List)extendParamMap.get("relatedParties");
        String rulePurposeNumber = ruleAccessDetail.getAccessConfig().getDynamicObject("rulepurpose").getString("number");
        if ("RPT".equals(rulePurposeNumber)) {
            relatedParties = relatedParties.stream().filter(p -> p.getLong("id") != NON_RELATED_PARTY_ID.longValue()).collect(Collectors.toList());
        }
        List existsData = (List)extendParamMap.get("existsData");
        DynamicObject nonRelatedParty = relatedParties.stream().filter(p -> p.getLong("id") == NON_RELATED_PARTY_ID.longValue()).findFirst().orElse(null);
        DynamicObjectCollection transactionContent = ruleAccessDetail.getAccessConfig().getDynamicObjectCollection("transactioncontent");
        for (Map<String, Object> bizData : ruleAccessDetail.getBizDataList()) {
            Long supplier = (Long)bizData.get("supplier");
            Long customer = (Long)bizData.get("customer");
            DynamicObject relatedParty = relatedParties.stream().filter(p -> supplier != 0L && p.getLong("supplier.id") == supplier.longValue() || customer != 0L && p.getLong("customer.id") == customer.longValue()).findFirst().orElse(null);
            if ("NRPT".equals(rulePurposeNumber) && relatedParty != null && relatedParty.get("enable").equals("1")) continue;
            if (relatedParty == null || relatedParty.get("enable").equals("0")) {
                relatedParty = nonRelatedParty;
            }
            if (relatedParty == null) continue;
            long relatedPartyId = relatedParty.getLong("id");
            OtherTransDetailDto existData = null;
            if (existsData.stream().anyMatch(p -> p.getEntityName().equals(ruleAccessDetail.getEntityName()) && p.getRelatedPartyId() == relatedPartyId)) {
                existData = existsData.stream().filter(p -> p.getEntityName().equals(ruleAccessDetail.getEntityName()) && p.getRelatedPartyId() == relatedPartyId).findFirst().get();
            } else if (result.stream().anyMatch(p -> p.getRelatedPartyId() == relatedPartyId)) {
                existData = result.stream().filter(p -> p.getRelatedPartyId() == relatedPartyId).findFirst().get();
            }
            String reportItemId = UUID.randomUUID();
            bizData.put(reportItemKey, reportItemId);
            if (existData == null) {
                DynamicObject area = relatedParty.getDynamicObject("area");
                Long countryId = 0L;
                String countryName = "";
                if (area != null) {
                    countryId = area.getLong("id");
                    countryName = area.getString("projectname");
                }
                RelatedFinancingDto relatedFinancing = new RelatedFinancingDto(ruleAccessDetail.getEntityName(), DBUtils.getLongId((String)""), relatedPartyId, relatedParty.getString("name"), countryId, countryName, ruleAccessDetail.getAccessConfig().getLong("itemname.id"), ruleAccessDetail.getAccessConfig().getString("bizname"), transactionContent.stream().map(p -> p.getLong("fbasedataid.id")).collect(Collectors.toList()), transactionContent.stream().map(p -> p.getString("fbasedataid.projectname")).collect(Collectors.toList()), BigDecimal.ZERO, null, null, BigDecimal.ZERO);
                relatedFinancing.getReportItemId().add(reportItemId);
                result.add(relatedFinancing);
                continue;
            }
            existData.getReportItemId().add(reportItemId);
        }
        return result;
    }
}

