/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.common.enums.business.fillformcatalog;

import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.form.AbstractFormView;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.formplugin.taxdeclare.MultiDeclarePlugin;
import kd.taxc.ictm.business.declaredetailhis.DeclareDetailHisBusiness;
import kd.taxc.ictm.common.dto.IctmDeclareDynamicRowCalculateServiceResultDto;
import kd.taxc.ictm.common.enums.business.fillformcatalog.FillFormHideOrShowService;
import kd.taxc.ictm.common.util.DateUtils;
import org.apache.commons.collections4.MapUtils;

public abstract class AbstractFixCellFillFormHideOrShowServiceImpl
implements FillFormHideOrShowService {
    @Override
    public void hideForm(IctmDeclareDynamicRowCalculateServiceResultDto result, MultiDeclarePlugin plugin, Map<String, String> showData, String formNumber) {
        Map<String, String> cellDefaultValue = this.getCellDefaultValue(formNumber);
        if (MapUtils.isEmpty(cellDefaultValue)) {
            return;
        }
        result.getChangeCells().putAll(cellDefaultValue);
        HashMap originalCellValue = new HashMap(cellDefaultValue.size());
        cellDefaultValue.entrySet().forEach(p -> {
            String cfr_ignored_0 = (String)originalCellValue.put(p.getKey(), showData.get(p.getKey()));
        });
        HashMap<String, Map<String, String>> originalValueMap = new HashMap<String, Map<String, String>>(16);
        originalValueMap.put(formNumber, originalCellValue);
        this.putOriginalValueCache(originalValueMap, plugin);
    }

    @Override
    public void showForm(IctmDeclareDynamicRowCalculateServiceResultDto result, MultiDeclarePlugin plugin, DeclareRequestModel requestModel, String formNumber) {
        AbstractFormView parentView = (AbstractFormView)plugin.getView().getParentView();
        Map<String, String> cellHisValue = DeclareDetailHisBusiness.getDeclareDetailHis(requestModel.getOrgId(), DateUtils.stringToDate(requestModel.getSkssqq()), DateUtils.stringToDate(requestModel.getSkssqz()), formNumber, parentView.getPageCache());
        if (MapUtils.isEmpty(cellHisValue)) {
            return;
        }
        result.getChangeCells().putAll(cellHisValue);
    }

    protected String getRowColDimension(String rowDimension, String colDimension) {
        StringJoiner joiner = new StringJoiner("#");
        joiner.add(rowDimension).add(colDimension);
        return joiner.toString();
    }

    protected abstract Map<String, String> getCellDefaultValue(String var1);
}

