/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.common.enums.business.fillformcatalog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.form.AbstractFormView;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.formplugin.taxdeclare.MultiDeclarePlugin;
import kd.taxc.ictm.business.declaredetailhis.DeclareDetailHisBusiness;
import kd.taxc.ictm.common.dto.IctmDeclareDynamicRowCalculateServiceResultDto;
import kd.taxc.ictm.common.enums.DeclareReportDynRowEnum;
import kd.taxc.ictm.common.enums.business.fillformcatalog.FillFormHideOrShowService;
import kd.taxc.ictm.common.util.DateUtils;

public class OnlyDynRowDataFillFormHideOrShowServiceImpl
implements FillFormHideOrShowService {
    private static final Map<String, DeclareReportDynRowEnum> FORM_NUMBER_AND_DYN_ROW_DIMENSION_MAP = new HashMap<String, DeclareReportDynRowEnum>(2);

    public OnlyDynRowDataFillFormHideOrShowServiceImpl() {
        FORM_NUMBER_AND_DYN_ROW_DIMENSION_MAP.put("G107002", DeclareReportDynRowEnum.FINANCING_FUNDS_DYN_ROW);
        FORM_NUMBER_AND_DYN_ROW_DIMENSION_MAP.put("G107001", DeclareReportDynRowEnum.INCORPORATING_FUNDS_DYN_ROW);
    }

    @Override
    public void hideForm(IctmDeclareDynamicRowCalculateServiceResultDto result, MultiDeclarePlugin plugin, Map<String, String> showData, String formNumber) {
        if (!FORM_NUMBER_AND_DYN_ROW_DIMENSION_MAP.containsKey(formNumber)) {
            return;
        }
        DeclareReportDynRowEnum dynRowEnum = FORM_NUMBER_AND_DYN_ROW_DIMENSION_MAP.get(formNumber);
        String dynRowDimension = dynRowEnum.getDynRowDimension();
        Map<String, String> originalData = showData.entrySet().stream().filter(p -> ((String)p.getKey()).split("#").length == 3 && ((String)p.getKey()).split("#")[0].equals(dynRowDimension)).collect(Collectors.toMap(k -> (String)k.getKey(), v -> (String)v.getValue()));
        HashMap<String, Map<String, String>> formOriginalData = new HashMap<String, Map<String, String>>(1);
        formOriginalData.put(formNumber, originalData);
        this.putOriginalValueCache(formOriginalData, plugin);
        List delRowIndexes = originalData.keySet().stream().map(p -> Integer.parseInt(p.split("#")[1])).distinct().collect(Collectors.toList());
        result.getDynRowCellListForDel().put(dynRowDimension + "#1", delRowIndexes);
        for (Integer delRowIndex : delRowIndexes) {
            ArrayList delRow = new ArrayList(1);
            HashMap<String, String> delRowCell = new HashMap<String, String>(1);
            String cellKey = originalData.keySet().stream().filter(p -> p.split("#")[1].equals(delRowIndex.toString()) && p.endsWith(dynRowEnum.getRelatedPartyColDimension())).findFirst().get();
            delRowCell.put("cellKey", cellKey);
            delRow.add(delRowCell);
            result.getDelRowCells().add(delRow);
        }
    }

    @Override
    public void showForm(IctmDeclareDynamicRowCalculateServiceResultDto result, MultiDeclarePlugin plugin, DeclareRequestModel requestModel, String formNumber) {
        if (!FORM_NUMBER_AND_DYN_ROW_DIMENSION_MAP.containsKey(formNumber)) {
            return;
        }
        AbstractFormView parentView = (AbstractFormView)plugin.getView().getParentView();
        Map<String, String> cellHisValue = DeclareDetailHisBusiness.getDeclareDetailHis(requestModel.getOrgId(), DateUtils.stringToDate(requestModel.getSkssqq()), DateUtils.stringToDate(requestModel.getSkssqz()), formNumber, parentView.getPageCache());
        result.getCascadeChangeCellValue().putAll(cellHisValue);
        List rowIndexes = cellHisValue.keySet().stream().map(p -> Integer.parseInt(p.split("#")[1])).distinct().sorted().collect(Collectors.toList());
        String dynRowNo = FORM_NUMBER_AND_DYN_ROW_DIMENSION_MAP.get(formNumber).getDynRowDimension() + "#1";
        ArrayList<Map<String, String>> addRows = (ArrayList<Map<String, String>>)result.getDynRowForAdd().get(dynRowNo);
        if (addRows == null) {
            addRows = new ArrayList<Map<String, String>>(rowIndexes.size());
            result.getDynRowForAdd().put(dynRowNo, addRows);
        }
        for (Integer rowIndex : rowIndexes) {
            Map<String, String> addRow = cellHisValue.entrySet().stream().filter(p -> ((String)p.getKey()).split("#")[1].equals(rowIndex.toString())).collect(Collectors.toMap(k -> (String)k.getKey(), v -> (String)v.getValue()));
            addRows.add(addRow);
        }
    }
}

