/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.common.helper;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.ictm.common.util.PermissionUtils;
import kd.taxc.ictm.common.util.TreeUtils;

public class OrgServiceHelper {
    public static DynamicObjectCollection getOrgLists() {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        List list = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"getOrgLists", (Object[])new Object[0]);
        list.stream().forEach(map -> {
            DynamicObject row = BusinessDataServiceHelper.newDynamicObject((String)"tctb_org_entity");
            DataEntityPropertyCollection properties = row.getDynamicObjectType().getProperties();
            map.keySet().stream().forEach(key -> row.set(key, map.get(key)));
            dynamicObjectCollection.add((Object)row);
        });
        return dynamicObjectCollection;
    }

    public static DynamicObjectCollection queryOrgListByCondition(Map<String, List<Object>> condition) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        List list = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"queryOrgListByCondition", (Object[])new Object[]{condition});
        list.stream().forEach(map -> {
            DynamicObject row = BusinessDataServiceHelper.newDynamicObject((String)"tctb_org_entity");
            DataEntityPropertyCollection properties = row.getDynamicObjectType().getProperties();
            map.keySet().stream().forEach(key -> row.set(key, map.get(key)));
            dynamicObjectCollection.add((Object)row);
        });
        return dynamicObjectCollection;
    }

    public static Long getDefaultViewSchemaInfoId() {
        return (Long)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"getDefaultViewSchemaInfoId", (Object[])new Object[0]);
    }

    public static Long getLocalDefaultViewId() {
        return (Long)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"getLocalDefaultViewId", (Object[])new Object[0]);
    }

    public static DynamicObjectCollection queryEnableOrgs(String selectFields, QFilter filter) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        String filterJson = StringUtils.isNotBlank((Object)filter) ? SerializationUtils.toJsonString((Object)filter) : null;
        List list = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"queryEnableOrgs", (Object[])new Object[]{selectFields, filterJson});
        list.stream().forEach(map -> {
            DynamicObject row = BusinessDataServiceHelper.newDynamicObject((String)"bastax_taxorg");
            DataEntityPropertyCollection properties = row.getDynamicObjectType().getProperties();
            map.keySet().stream().forEach(key -> row.set(key, map.get(key)));
            collection.add((Object)row);
        });
        return collection;
    }

    public static List<Map<String, Object>> queryEnableOrgList(String selectFields, QFilter filter) {
        String filterJson = StringUtils.isNotBlank((Object)filter) ? SerializationUtils.toJsonString((Object)filter) : null;
        List list = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"queryEnableOrgs", (Object[])new Object[]{selectFields, filterJson});
        return list;
    }

    public static List<Long> listTaxOrgId(IFormView view, String perm, boolean istaxpayer) {
        HasPermOrgResult hasPermOrgs;
        DynamicObjectCollection hasPermCol;
        if (StringUtils.isEmpty((CharSequence)perm)) {
            perm = "47150e89000000ac";
        }
        if (null == (hasPermCol = TreeUtils.queryOrgListHasPermission(hasPermOrgs = PermissionUtils.getAllPermOrgs(view, perm), true))) {
            return null;
        }
        List<Long> hasPermOrgList = hasPermCol.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
        if (!istaxpayer) {
            return hasPermOrgList;
        }
        QFilter filter = new QFilter("istaxpayer", "=", (Object)"1");
        DynamicObjectCollection taxOrgCol = OrgServiceHelper.queryEnableOrgs("id", filter);
        if (null == taxOrgCol) {
            return null;
        }
        List taxOrgList = taxOrgCol.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
        List<Long> collect = taxOrgList.stream().filter(hasPermOrgList::contains).collect(Collectors.toList());
        return collect;
    }
}

