/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.common.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class BigDecimalUtil {
    public static BigDecimal setScale(Object dec) {
        return BigDecimalUtil.setScale(dec, 2);
    }

    public static BigDecimal setScale(Object dec, int scale) {
        BigDecimal bigDecimal = BigDecimalUtil.toBigDecimal(dec);
        if (bigDecimal == null) {
            return BigDecimal.ZERO;
        }
        return bigDecimal.setScale(scale, 4);
    }

    public static BigDecimal subtractObject(Object dec1, Object dec2) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        return BigDecimalUtil.toBigDecimal(dec1).subtract(BigDecimalUtil.toBigDecimal(dec2));
    }

    public static BigDecimal subtractObject(Object dec1, Object dec2, int scale) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        return BigDecimalUtil.toBigDecimal(dec1).subtract(BigDecimalUtil.toBigDecimal(dec2)).setScale(scale, 4);
    }

    public static BigDecimal divideObject(Object dec1, Object dec2, int scale) {
        return BigDecimalUtil.divideObject(dec1, dec2, scale, 4);
    }

    public static BigDecimal divideObject(Object dec1, Object dec2, int scale, int roundingMode) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        if (BigDecimalUtil.toBigDecimal(dec2).signum() == 0) {
            return null;
        }
        return BigDecimalUtil.toBigDecimal(dec1).divide(BigDecimalUtil.toBigDecimal(dec2), scale, roundingMode);
    }

    public static BigDecimal multiplyObject(Object dec1, Object dec2, int scale) {
        if (dec1 == null || dec2 == null) {
            return null;
        }
        BigDecimal obj = BigDecimalUtil.toBigDecimal(dec1).multiply(BigDecimalUtil.toBigDecimal(dec2));
        return obj.setScale(scale, 6);
    }

    public static BigDecimal multiplyObject(Object dec1, Object dec2, int scale, int RoundingMode2) {
        if (dec1 == null || dec2 == null) {
            return null;
        }
        BigDecimal obj = BigDecimalUtil.toBigDecimal(dec1).multiply(BigDecimalUtil.toBigDecimal(dec2));
        return obj.setScale(scale, RoundingMode2);
    }

    public static BigDecimal addObject(Object dec1, Object dec2) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        return BigDecimalUtil.toBigDecimal(dec1).add(BigDecimalUtil.toBigDecimal(dec2));
    }

    public static BigDecimal addObjects(Object ... objects) {
        BigDecimal total = BigDecimal.ZERO;
        for (Object object : objects) {
            total = BigDecimalUtil.toBigDecimal(object).add(total);
        }
        return total;
    }

    public static BigDecimal toBigDecimal(Object obj) {
        if (obj == null) {
            return BigDecimal.ZERO;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Integer) {
            return new BigDecimal(((Integer)obj).toString());
        }
        if (obj instanceof Long) {
            return new BigDecimal(((Long)obj).toString());
        }
        if (obj instanceof Double) {
            return BigDecimal.valueOf((Double)obj);
        }
        if (obj.toString() == null) {
            return BigDecimal.ZERO;
        }
        String str = obj.toString().trim();
        if (str.toLowerCase().contains("e")) {
            try {
                return new BigDecimal(str);
            }
            catch (NumberFormatException e) {
                return BigDecimal.ZERO;
            }
        }
        if (str.matches("^[+-]?\\d+[\\.\\d]?\\d*+$")) {
            return new BigDecimal(str);
        }
        return BigDecimal.ZERO;
    }

    public static final String thousandth(Object num) {
        return DecimalFormat.getNumberInstance().format(BigDecimalUtil.toBigDecimal(num));
    }

    public static String format(Object num, String pattern) {
        DecimalFormat format = new DecimalFormat(pattern, DecimalFormatSymbols.getInstance());
        return format.format(num);
    }
}

