/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.associatedledger;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.ictm.common.util.PermissionUtils;
import kd.taxc.ictm.formplugin.common.TaxOrgCommonEditPlugin;

public class AssociatedLedgerCommonEditPlugin
extends TaxOrgCommonEditPlugin {
    protected static final String FIELD_YEAR_SIGN = "year";
    protected static final String FIELD_TAX_ORG_SIGN = "taxorg";
    protected static final String BTN_SAVE_SIGN = "btnsave";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setTaxOrgValue();
        Date defaultYear = DateUtils.addYear((Date)DateUtils.getFirstDateOfYear((Date)new Date()), (int)-1);
        this.getModel().setValue(FIELD_YEAR_SIGN, (Object)defaultYear);
    }

    protected void setTaxOrgValue() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            this.getModel().setValue(FIELD_TAX_ORG_SIGN, (Object)org.getLong("id"));
        }
    }

    public void afterBindData(EventObject e) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (this.getView().getParentView() == null) {
            return;
        }
        boolean hasSpecificPerm = PermissionUtils.hasSpecificPerm(this.getView().getParentView(), "4715a0df000000ac");
        if (OperationStatus.VIEW.equals((Object)status) && !hasSpecificPerm) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_SAVE_SIGN});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("org".equals(e.getProperty().getName())) {
            this.setTaxOrgValue();
        }
    }
}

