/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.associatedledger.relatedfinancing;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.Save;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.ictm.common.util.DateUtils;
import kd.taxc.ictm.formplugin.associatedledger.AssociatedLedgerCommonEditPlugin;

public class RelatedFinancingEditPlugin
extends AssociatedLedgerCommonEditPlugin {
    private static final String FIELD_RELATED_PARTY_SIGN = "relatedparty";
    private static final String FIELD_INTEREST_AMOUNT_SIGN = "interestamount";
    private static final String FIELD_YEAR_START_DATE = "yearstartdate";
    private static final String FIELD_YEAR_END_DATE = "yearenddate";
    private static final String FIELD_TRANSACTION_DESC = "transactiondesc";
    private static final String CACHE_ENSURE_SAVE_KEY = "ensureSave";
    private static final String BTN_SAVE_OPERATE_CODE = "save";
    private static final String SAVE_CONFIRM_CALLBACK_ID = "ensureSave";
    private static final String SYSTEM_TYPE = "taxc_ictm_formplugin";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save && !Boolean.TRUE.toString().equals(this.getPageCache().get("ensureSave")) && !this.beforeSaveCheck()) {
            args.setCancel(true);
            return;
        }
    }

    private boolean beforeSaveCheck() {
        if (!ObjectUtils.isEmpty((Object)this.getModel().getValue(FIELD_YEAR_START_DATE)) || !ObjectUtils.isEmpty((Object)this.getModel().getValue(FIELD_YEAR_END_DATE))) {
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue(FIELD_YEAR_START_DATE)) && !ObjectUtils.isEmpty((Object)this.getModel().getValue(FIELD_YEAR_END_DATE))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e74\u5185\u5360\u7528\u8d77\u59cb\u65e5\u4e3a\u7a7a\u3002", (String)"RelatedFinancingEditPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            if (!ObjectUtils.isEmpty((Object)this.getModel().getValue(FIELD_YEAR_START_DATE)) && ObjectUtils.isEmpty((Object)this.getModel().getValue(FIELD_YEAR_END_DATE))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e74\u5185\u5360\u7528\u622a\u6b62\u65e5\u4e3a\u7a7a\u3002", (String)"RelatedFinancingEditPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            int year = DateUtils.getYear((Date)this.getModel().getValue("year"));
            Date yearStartDate = (Date)this.getModel().getValue(FIELD_YEAR_START_DATE);
            Date yearEndDate = (Date)this.getModel().getValue(FIELD_YEAR_END_DATE);
            if (DateUtils.getYear(yearStartDate) < year) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e74\u5185\u5360\u7528\u8d77\u59cb\u65e5\u4f4d\u4e8e\u5e74\u5ea6\u5f00\u59cb\u524d\u3002", (String)"RelatedFinancingEditPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            if (DateUtils.getYear(yearStartDate) > year) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e74\u5185\u5360\u7528\u8d77\u59cb\u65e5\u4f4d\u4e8e\u5e74\u5ea6\u7ed3\u675f\u540e\u3002", (String)"RelatedFinancingEditPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            if (DateUtils.getYear(yearEndDate) < year) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e74\u5185\u5360\u7528\u622a\u6b62\u65e5\u4f4d\u4e8e\u5e74\u5ea6\u5f00\u59cb\u524d\u3002", (String)"RelatedFinancingEditPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            if (DateUtils.getYear(yearEndDate) > year) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e74\u5185\u5360\u7528\u622a\u6b62\u65e5\u4f4d\u4e8e\u5e74\u5ea6\u7ed3\u675f\u540e\u3002", (String)"RelatedFinancingEditPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            if (yearEndDate.compareTo(yearStartDate) < 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e74\u5185\u5360\u7528\u622a\u6b62\u65e5\u4f4d\u4e8e\u5e74\u5185\u5360\u7528\u8d77\u59cb\u65e5\u524d\u3002", (String)"RelatedFinancingEditPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Object yearDate = this.getModel().getValue("year");
        DynamicObject relatedParty = (DynamicObject)this.getModel().getValue(FIELD_RELATED_PARTY_SIGN);
        Object interestAmount = this.getModel().getValue(FIELD_INTEREST_AMOUNT_SIGN);
        QFilter filter = new QFilter("org.id", "=", (Object)org.getLong("id")).and("year", "=", yearDate).and("relatedparty.id", "=", (Object)relatedParty.getLong("id")).and(FIELD_INTEREST_AMOUNT_SIGN, "=", interestAmount).and(FIELD_TRANSACTION_DESC, "=", (Object)this.getModel().getValue(FIELD_TRANSACTION_DESC).toString()).and("masterid", "!=", this.getModel().getValue("masterid"));
        if (QueryServiceHelper.exists((String)"ictm_related_financing", (QFilter[])new QFilter[]{filter})) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("ensureSave", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMap = new HashMap<Integer, String>(2);
            btnNameMap.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"RelatedFinancingEditPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            btnNameMap.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4\u4fdd\u5b58", (String)"RelatedFinancingEditPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String tipMsg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u4ea4\u6613\u7591\u4f3c\u91cd\u590d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4fdd\u5b58", (String)"RelatedFinancingEditPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            this.getView().showConfirm(tipMsg, "", options, ConfirmTypes.Save, confirmCallBackListener, btnNameMap);
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        if (eventArgs.getOperateKey().equals(BTN_SAVE_OPERATE_CODE) && eventArgs.getOperationResult().isSuccess()) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"RelatedFinancingEditPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if ("ensureSave".equals(event.getCallBackId()) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getPageCache().put("ensureSave", Boolean.TRUE.toString());
            this.getView().invokeOperation(BTN_SAVE_OPERATE_CODE);
        }
    }
}

