/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.basicsetting;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.ictm.business.declareruleconfig.DeclareRuleConfigBusiness;
import kd.taxc.ictm.business.sharingscheme.SharingSchemeBusiness;
import kd.taxc.ictm.business.taxorg.IctmTaxOrgCommonBusiness;
import org.apache.commons.lang3.StringUtils;

public class DeclareRuleConfigListPlugin
extends AbstractListPlugin {
    private static final String BASTAX_TAXORG = "bastax_taxorg";
    private static final String TBL_SHARE = "tblshare";
    private static final String TBL_PRIUSE = "tblpriuse";
    private static final String TBL_COPY = "tblcopy";
    private static final String TBL_ENABLE = "tblenable";
    private static final String ORG = "org";
    private static final String SPECIFIEDSHARING = "specifiedsharing";
    private static final String SPECIFIED_SHARING = "specified_sharing";
    private static final String RULEPURPOSE = "rulepurpose";
    private static final String ID = "id";
    private static final String RULE_TYPE = "ruletype";
    private static final String ACCESS_CONFIG_NAME = "itp_accessconfig";
    private static final String NEW_TYPE = "newtype";
    private static final String ONE = "1";
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String BIZ_NAME = "bizname";

    public void filterContainerInit(FilterContainerInitArgs args) {
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        this.addQfilter(args.getFieldName(), args.getQFilters());
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        this.addQfilter(args.getFieldName(), args.getQfilters());
    }

    private void addQfilter(String fieldName, List<QFilter> filters) {
        if (fieldName.startsWith(RULEPURPOSE)) {
            filters.add(new QFilter("bizdef.number", "=", (Object)"SBXPZ-01"));
            filters.add(new QFilter("parent", "=", (Object)0L));
        } else if (fieldName.startsWith(ORG)) {
            List<Long> orgIds = IctmTaxOrgCommonBusiness.getTaxcOrgIdsWithPerm(this.getView());
            filters.add(new QFilter(ID, "in", orgIds));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String newtype = this.getPageCache().get(NEW_TYPE);
        String oid = null;
        if (newtype != null) {
            if (TBL_SHARE.equalsIgnoreCase(newtype) || TBL_PRIUSE.equalsIgnoreCase(newtype)) {
                this.getPageCache().put(newtype, ONE);
                List orgid = this.getControlFilters().getFilter("org.id");
                oid = orgid != null && orgid.size() == 1 && !"".equalsIgnoreCase(orgid.get(0).toString()) ? String.valueOf(orgid.get(0)) : null;
            } else if (TBL_COPY.equalsIgnoreCase(newtype)) {
                oid = this.getPageCache().get(TBL_COPY);
            }
            if (oid != null) {
                DynamicObject[] load = BusinessDataServiceHelper.load((String)BASTAX_TAXORG, (String)ID, (QFilter[])new QFilter[]{new QFilter("istaxpayer", "=", (Object)ONE).and("status", "=", (Object)ONE).and(ID, "=", (Object)Long.valueOf(oid))});
                if (load == null || load.length == 0) {
                    oid = null;
                    e.getParameter().setCustomParam("setnull", (Object)true);
                } else {
                    HasPermOrgResult allPermOrgsByUserId = PermissionUtils.getAllPermOrgsByUserId((String)"itp", (String)ACCESS_CONFIG_NAME, (String)"47156aff000000ac", (Long)RequestContext.get().getCurrUserId());
                    if (!allPermOrgsByUserId.hasAllOrgPerm() && !allPermOrgsByUserId.getHasPermOrgs().contains(load[0].getLong(ID))) {
                        oid = null;
                        e.getParameter().setCustomParam("setnull", (Object)true);
                    }
                }
            }
            e.getParameter().setCustomParam("orgid", (Object)oid);
            this.getPageCache().put(NEW_TYPE, null);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)TBL_SHARE) || StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)TBL_PRIUSE) || StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)TBL_COPY)) {
            this.getPageCache().put(NEW_TYPE, itemKey);
            if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)TBL_COPY) && this.getSelectRowsDetail() != null && this.getSelectRowsDetail().length == 1) {
                this.getPageCache().put(TBL_COPY, String.valueOf(this.getSelectRowsDetail()[0].get("org.id")));
            }
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)SPECIFIEDSHARING) && !this.verifySpecifiedSharingSchemeData().booleanValue()) {
            evt.setCancel(true);
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)TBL_ENABLE) && !this.verifyEnableRule().booleanValue()) {
            evt.setCancel(true);
            return;
        }
    }

    private DynamicObject[] getSelectRowsDetail() {
        return DeclareRuleConfigBusiness.getDataByIds(this.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).toArray());
    }

    private Boolean verifySpecifiedSharingSchemeData() {
        if (this.getSelectedRows() == null || this.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DeclareRuleConfigListPlugin_0", (String)"taxc-ictm", (Object[])new Object[0]));
            return false;
        }
        DynamicObject[] selectedRules = this.getSelectRowsDetail();
        if (Arrays.stream(selectedRules).anyMatch(p -> "0".equals(p.getString("enable")))) {
            List numbers = Arrays.stream(selectedRules).filter(p -> "0".equals(p.getString("enable"))).map(p -> p.getString("number")).collect(Collectors.toList());
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4ec5\u53ef\u7528\u89c4\u5219\u53ef\u6307\u5b9a\u5171\u4eab\u65b9\u6848\uff0c\u5f53\u524d\u6570\u636e\u4e0d\u7b26\u5408\u6761\u4ef6\uff1a%1$s\u3002", (String)"DeclareRuleConfigListPlugin_1", (String)"taxc-ictm", (Object[])new Object[0]), String.join((CharSequence)"\u3001", numbers)));
            return false;
        }
        if (Arrays.stream(selectedRules).anyMatch(p -> "ZY".equals(p.getString(RULE_TYPE)))) {
            List numbers = Arrays.stream(selectedRules).filter(p -> "ZY".equals(p.getString(RULE_TYPE))).map(p -> p.getString("number")).collect(Collectors.toList());
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4ec5\u53ef\u5206\u914d\u89c4\u5219\u53ef\u6307\u5b9a\u5171\u4eab\u65b9\u6848\uff0c\u5f53\u524d\u6570\u636e\u4e0d\u7b26\u5408\u6761\u4ef6\uff1a%1$s\u3002", (String)"DeclareRuleConfigListPlugin_2", (String)"taxc-ictm", (Object[])new Object[0]), String.join((CharSequence)"\u3001", numbers)));
            return false;
        }
        Map<String, List<DynamicObject>> ruleConfigMap = Arrays.stream(selectedRules).collect(Collectors.groupingBy(p -> {
            StringJoiner joiner = new StringJoiner("#");
            joiner.add(p.getDynamicObject(RULEPURPOSE).getString(ID));
            joiner.add(p.getString(BIZ_NAME));
            if (p.getDynamicObject("itemname") != null) {
                joiner.add(p.getDynamicObject("itemname").getString(ID));
            }
            return joiner.toString();
        }));
        StringJoiner msg = new StringJoiner(SEPARATOR);
        ruleConfigMap.values().stream().filter(p -> p.size() > 1).forEach(p -> {
            String errorTipMsg = String.join((CharSequence)"\u3001", p.stream().map(t -> t.getString("number")).collect(Collectors.toList()));
            msg.add(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u89c4\u5219\u7528\u9014\u53ca\u4e1a\u52a1/\u9879\u76ee\u76f8\u540c\uff1a%1$s\u3002", (String)"DeclareRuleConfigListPlugin_3", (String)"taxc-ictm", (Object[])new Object[0]), errorTipMsg));
        });
        if (msg.length() > 0) {
            this.getView().showErrorNotification(msg.toString());
            return false;
        }
        long orgId = selectedRules[0].getLong("org.id");
        if (Arrays.stream(selectedRules).anyMatch(p -> orgId != p.getLong("org.id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u521b\u5efa\u7ec4\u7ec7\u4e0d\u540c\uff0c\u65e0\u6cd5\u6279\u91cf\u6307\u5b9a\u5171\u4eab\u65b9\u6848\u3002", (String)"DeclareRuleConfigListPlugin_4", (String)"taxc-ictm", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Boolean verifyEnableRule() {
        DynamicObject[] datas;
        DynamicObject[] selectRules = this.getSelectRowsDetail();
        List selfRules = Arrays.stream(selectRules).filter(p -> "ZY".equals(p.getString(RULE_TYPE))).collect(Collectors.toList());
        Map<String, List<DynamicObject>> uniqueKeyRuleMap = selfRules.stream().collect(Collectors.groupingBy(p -> {
            StringJoiner joiner = new StringJoiner("#");
            joiner.add(p.getString("org.id")).add(p.getString("rulepurpose.id")).add(p.getString(BIZ_NAME));
            if (p.getDynamicObject("itemname") != null) {
                joiner.add(p.getString("itemname.id"));
            }
            return joiner.toString();
        }));
        StringJoiner msg = new StringJoiner(SEPARATOR);
        for (Map.Entry<String, List<DynamicObject>> uniqueKeyRuleEntry : uniqueKeyRuleMap.entrySet()) {
            if (uniqueKeyRuleEntry.getValue().size() <= 1) continue;
            msg.add(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u521b\u5efa\u7ec4\u7ec7+\u89c4\u5219\u7528\u9014+\u4e1a\u52a1/\u9879\u76ee\u540d\u79f0\u7ec4\u5408\u503c\u91cd\u590d\uff1a%1$s\u3002", (String)"DeclareRuleConfigListPlugin_5", (String)"taxc-ictm", (Object[])new Object[0]), String.join((CharSequence)"\u3001", uniqueKeyRuleEntry.getValue().stream().map(p -> p.getString("number")).collect(Collectors.toList()))));
        }
        if (msg.length() > 0) {
            this.getView().showErrorNotification(msg.toString());
            return false;
        }
        QFilter filter1 = new QFilter(RULE_TYPE, "=", (Object)"ZY").and("enable", "=", (Object)ONE);
        QFilter filter = null;
        for (DynamicObject selfRule : selfRules) {
            if (filter == null) {
                filter = new QFilter("org.id", "=", (Object)selfRule.getLong("org.id")).and("rulepurpose.id", "=", (Object)selfRule.getLong("rulepurpose.id")).and("itemname.id", "=", (Object)selfRule.getLong("itemname.id")).and(BIZ_NAME, "=", (Object)selfRule.getString(BIZ_NAME));
                continue;
            }
            filter = filter.or(new QFilter("org.id", "=", (Object)selfRule.getLong("org.id")).and("rulepurpose.id", "=", (Object)selfRule.getLong("rulepurpose.id")).and("itemname.id", "=", (Object)selfRule.getLong("itemname.id"))).and(BIZ_NAME, "=", (Object)selfRule.getString(BIZ_NAME));
        }
        if (filter != null && (datas = DeclareRuleConfigBusiness.getDataByFilters(new QFilter[]{filter1, filter})).length > 0) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5c31\u4e0b\u5217\u6570\u636e\u540c\u4e00\u7ec4\u7ec7\u5df2\u542f\u7528\u76f8\u540c\u4e1a\u52a1/\u9879\u76ee\u7684\u81ea\u7528\u89c4\u5219\uff1a%1$s\u3002", (String)"DeclareRuleConfigListPlugin_6", (String)"taxc-ictm", (Object[])new Object[0]), String.join((CharSequence)"\u3001", Arrays.stream(datas).map(p -> p.getString("number")).collect(Collectors.toList()))));
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey = evt.getOperateKey();
        if (SPECIFIED_SHARING.equals(operateKey)) {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"ictm_sharing_scheme", (boolean)true);
            List ids = this.getSelectedRows().stream().map(row -> row.getPrimaryKeyValue()).collect(Collectors.toList());
            DynamicObject ruleConfig = DeclareRuleConfigBusiness.getDataById(ids.get(0));
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("createorg.id", "=", (Object)ruleConfig.getLong("org.id")));
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SPECIFIEDSHARING));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (StringUtils.equalsIgnoreCase((CharSequence)SPECIFIEDSHARING, (CharSequence)closedCallBackEvent.getActionId())) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (!(returnData instanceof ListSelectedRowCollection)) {
                return;
            }
            DynamicObject[] selectedRules = this.getSelectRowsDetail();
            ListSelectedRowCollection returnDataRows = (ListSelectedRowCollection)returnData;
            List selectedSchemeIds = returnDataRows.stream().map(o -> o.getPrimaryKeyValue()).collect(Collectors.toList());
            DynamicObject[] schemes = SharingSchemeBusiness.getData(new QFilter[]{new QFilter(ID, "in", selectedSchemeIds)});
            StringJoiner tipMessage = new StringJoiner(SEPARATOR);
            for (DynamicObject scheme2 : schemes) {
                DynamicObjectCollection ruleCollection = scheme2.getDynamicObjectCollection("ruleentity");
                DynamicObject[] dynamicObjectArray = selectedRules;
                int n = dynamicObjectArray.length;
                for (int i = 0; i < n; ++i) {
                    DynamicObject selectedRule = dynamicObjectArray[i];
                    DynamicObject rule = ruleCollection.stream().filter(p -> p.getLong("rule.rulepurpose.id") == selectedRule.getLong("rulepurpose.id") && p.getString("rule.bizname").equals(selectedRule.getString(BIZ_NAME)) && p.getLong("rule.itemname.id") == selectedRule.getLong("itemname.id")).findFirst().orElse(null);
                    if (rule != null) {
                        tipMessage.add(String.format(ResManager.loadKDString((String)"\u5171\u4eab\u89c4\u5219%1$s\uff0c\u9488\u5bf9%2$s:%3$s\u5df2\u5305\u542b\u89c4\u5219%4$s\uff0c\u4e0d\u53ef\u91cd\u590d\u52a0\u5165\u89c4\u5219%5$s\u3002", (String)"DeclareRuleConfigListPlugin_7", (String)"taxc-ictm", (Object[])new Object[0]), scheme2.getString("number"), selectedRule.getString("rulepurpose.projectname"), selectedRule.getString(BIZ_NAME), rule.getString("rule.number"), selectedRule.getString("number")));
                        continue;
                    }
                    DynamicObject dynamicObject = ruleCollection.addNew();
                    dynamicObject.set("rule", (Object)selectedRule.getLong(ID));
                }
            }
            if (tipMessage.length() > 0) {
                this.getView().showErrorNotification(tipMessage.toString());
                return;
            }
            Map<Long, List<DynamicObject>> orgIdSchemeMap = Arrays.stream(schemes).collect(Collectors.groupingBy(p -> p.getLong("orgentity.org.id")));
            for (Map.Entry<Long, List<DynamicObject>> orgIdSchemeEntry : orgIdSchemeMap.entrySet()) {
                if (orgIdSchemeEntry.getValue().size() <= 1) continue;
                tipMessage.add(String.format(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848%1$s\u7684\u5171\u4eab\u7ec4\u7ec7\u8303\u56f4\u5b58\u5728\u4ea4\u96c6\u3002", (String)"DeclareRuleConfigListPlugin_8", (String)"taxc-ictm", (Object[])new Object[0]), String.join((CharSequence)"\u3001", orgIdSchemeEntry.getValue().stream().map(p -> p.getString("number")).collect(Collectors.toList()))));
            }
            if (tipMessage.length() > 0) {
                this.getView().showErrorNotification(tipMessage.toString());
                return;
            }
            List orgIds = Arrays.stream(schemes).flatMap(scheme -> scheme.getDynamicObjectCollection("orgentity").stream().map(org -> org.getLong("org.id"))).collect(Collectors.toList());
            QFilter filter = new QFilter(ID, "not in", selectedSchemeIds).and("orgentity.org.id", "in", orgIds);
            DynamicObject[] nonSelectSchemes = SharingSchemeBusiness.getData(new QFilter[]{filter});
            for (DynamicObject selectedRule : selectedRules) {
                for (DynamicObject nonSelectScheme : nonSelectSchemes) {
                    List schemeRules = nonSelectScheme.getDynamicObjectCollection("ruleentity").stream().map(p -> p.getDynamicObject("rule")).collect(Collectors.toList());
                    DynamicObject rule = schemeRules.stream().filter(p -> p.getLong("rulepurpose.id") == selectedRule.getLong("rulepurpose.id") && p.getString(BIZ_NAME).equals(selectedRule.getString(BIZ_NAME)) && p.getLong("itemname.id") == selectedRule.getLong("itemname.id")).findFirst().orElse(null);
                    if (rule == null) continue;
                    List schemeOrgList = nonSelectScheme.getDynamicObjectCollection("orgentity").stream().map(p -> p.getDynamicObject(ORG)).collect(Collectors.toList());
                    for (DynamicObject schemeOrg : schemeOrgList) {
                        DynamicObject selectedScheme = Arrays.stream(schemes).filter(p -> p.getDynamicObjectCollection("orgentity").stream().anyMatch(t -> t.getLong("org.id") == schemeOrg.getLong(ID))).findFirst().orElse(null);
                        if (selectedScheme == null) continue;
                        tipMessage.add(String.format(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848%1$s\u7684\u5171\u4eab\u7ec4\u7ec7\u8303\u56f4\u5305\u542b%2$s\uff0c\u9488\u5bf9%3$s\uff1a%4$s %2$s\u5df2\u52a0\u5165\u53e6\u4e00\u5171\u4eab\u65b9\u6848%5$s\u5e76\u9002\u7528\u5176\u4e2d\u7684\u89c4\u5219%6$s\uff0c\u56e0\u6b64\u82e5\u5c06\u89c4\u5219%7$s\u52a0\u5165\u5171\u4eab\u65b9\u6848%1$s\u5c06\u5bfc\u81f4%2$s\u5c31%3$s\uff1a%4$s\u9002\u7528\u4e24\u4e2a\u5171\u4eab\u65b9\u6848\u4e0b\u91cd\u590d\u7684\u89c4\u5219\u3002", (String)"DeclareRuleConfigListPlugin_9", (String)"taxc-ictm", (Object[])new Object[0]), selectedScheme.getString("number"), schemeOrg.getString("number"), selectedRule.getString("rulepurpose.projectname"), selectedRule.getString(BIZ_NAME), nonSelectScheme.getString("number"), rule.getString("number"), selectedRule.getString("number")));
                    }
                }
            }
            if (tipMessage.length() > 0) {
                this.getView().showErrorNotification(tipMessage.toString());
                return;
            }
            SharingSchemeBusiness.batchSaveData(schemes);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6307\u5b9a\u5171\u4eab\u65b9\u6848\u6210\u529f\u3002", (String)"DeclareRuleConfigListPlugin_10", (String)"taxc-ictm", (Object[])new Object[0]));
        }
    }
}

