/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.basicsetting;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.ictm.business.taxorg.IctmTaxOrgCommonBusiness;
import kd.taxc.ictm.common.enums.AccessConfigFetchRuleEnum;
import org.apache.commons.lang3.StringUtils;

public class DeclareRuleConfigPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String BASTAX_TAXORG = "bastax_taxorg";
    private static final String TABLE = "table";
    private static final String ORG = "org";
    private static final String ITEMNAME = "itemname";
    private static final String RULEPURPOSE = "rulepurpose";
    private static final String TRANSACTIONTYPE = "transactiontype";
    private static final String TRANSACTIONCONTENT = "transactioncontent";
    private static final String TRANSACTIONDIRECTION = "transactiondirection";
    private static final String BIZ_NAME = "bizname";
    private static final String DATATYPE = "datatype";
    private static final String TBL_SHARE = "tblshare";
    private static final String TBL_PRIUSE = "tblpriuse";
    public static final String RULE_TYPE = "ruletype";
    private static final String ONE = "1";
    private static final String TWO = "2";
    private static final String THREE = "3";

    public void registerListener(EventObject e) {
        BasedataEdit org = (BasedataEdit)this.getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit itemname = (BasedataEdit)this.getControl(ITEMNAME);
        itemname.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit transactiontype = (BasedataEdit)this.getControl(TRANSACTIONTYPE);
        transactiontype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit transactioncontent = (BasedataEdit)this.getControl(TRANSACTIONCONTENT);
        transactioncontent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit table = (BasedataEdit)this.getControl(TABLE);
        table.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u53d6\u6570\u914d\u7f6e", (String)"DeclareRuleConfigPlugin_0", (String)"taxc-ictm", (Object[])new Object[0]));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (RULEPURPOSE.equals(name)) {
            this.getModel().setValue(ITEMNAME, null);
            this.getModel().setValue(TRANSACTIONTYPE, null);
            this.clearItem();
            this.clearEntryentity();
        } else if (TRANSACTIONTYPE.equals(name)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            this.clearItem();
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (this.isClearEntryEntity((DynamicObject)newValue, (DynamicObject)oldValue)) {
                this.clearEntryentity();
            }
            if (newValue != null) {
                this.setTransactionDirectionDataSource((DynamicObject)newValue);
            }
        } else if (ITEMNAME.equals(name)) {
            Object oldValue;
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (this.isClearEntryEntity((DynamicObject)newValue, (DynamicObject)(oldValue = e.getChangeSet()[0].getOldValue()))) {
                this.clearEntryentity();
            }
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue(ITEMNAME))) {
                return;
            }
            this.getModel().setValue(BIZ_NAME, (Object)((DynamicObject)this.getModel().getValue(ITEMNAME)).getString("projectname"));
        } else if (TABLE.equals(name)) {
            ArrayList<ComboItem> items;
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (((DynamicObject)this.getModel().getValue(RULEPURPOSE)).getString("number").equals("EI") || newValue != null && Stream.of("ictm_other_transdetail", "ictm_related_financing").anyMatch(p -> p.equals(newValue.getString("name")))) {
                items = new ArrayList<ComboItem>(1);
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u76f4\u63a5\u53d6\u6570", (String)"DeclareRuleConfigPlugin_1", (String)"taxc-ictm", (Object[])new Object[0])), "zjqs"));
                this.getModel().setValue(DATATYPE, (Object)"zjqs", rowIndex);
            } else {
                items = new ArrayList(2);
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u76f4\u63a5\u53d6\u6570", (String)"DeclareRuleConfigPlugin_1", (String)"taxc-ictm", (Object[])new Object[0])), "zjqs"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7a0e\u989d\u6362\u7b97\u4e0d\u542b\u7a0e\u4ef7", (String)"DeclareRuleConfigPlugin_2", (String)"taxc-ictm", (Object[])new Object[0])), "cysldsqs"));
            }
            ComboEdit comboEdit = (ComboEdit)this.getView().getFlexControl(DATATYPE, rowIndex);
            comboEdit.setComboItems(items);
        }
    }

    private void setTransactionDirectionDataSource(DynamicObject transactionType) {
        if (transactionType == null) {
            return;
        }
        long jylxTypeId = transactionType.getLong("id");
        ComboEdit comboEdit = (ComboEdit)this.getControl(TRANSACTIONDIRECTION);
        if (1595684761731487894L == jylxTypeId || 1595648476010789897L == jylxTypeId || 1595685693781457925L == jylxTypeId) {
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6536\u5165", (String)"DeclareRuleConfigPlugin_3", (String)"taxc-ictm", (Object[])new Object[0])));
            item.setValue(TWO);
            items.add(item);
            item = new ComboItem();
            item.setCaption(new LocaleString(ResManager.loadKDString((String)"\u652f\u51fa", (String)"DeclareRuleConfigPlugin_4", (String)"taxc-ictm", (Object[])new Object[0])));
            item.setValue(THREE);
            items.add(item);
            comboEdit.setComboItems(items);
        } else {
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(ResManager.loadKDString((String)"\u51fa\u8ba9", (String)"DeclareRuleConfigPlugin_5", (String)"taxc-ictm", (Object[])new Object[0])));
            item.setValue("0");
            items.add(item);
            item = new ComboItem();
            item.setCaption(new LocaleString(ResManager.loadKDString((String)"\u53d7\u8ba9", (String)"DeclareRuleConfigPlugin_6", (String)"taxc-ictm", (Object[])new Object[0])));
            item.setValue(ONE);
            items.add(item);
            comboEdit.setComboItems(items);
        }
    }

    private boolean isClearEntryEntity(DynamicObject newValue, DynamicObject oldValue) {
        if (newValue == null || oldValue == null) {
            return true;
        }
        DynamicObject rulePurposeObject = (DynamicObject)this.getModel().getValue(RULEPURPOSE);
        return AccessConfigFetchRuleEnum.isFetchRuleChanged(rulePurposeObject.getString("number"), newValue.getString("number"), oldValue.getString("number"));
    }

    private void clearEntryentity() {
        this.getModel().deleteEntryData("entryentity");
    }

    private void clearItem() {
        this.getModel().setValue(TRANSACTIONCONTENT, null);
        this.getModel().setValue(TRANSACTIONDIRECTION, null);
        this.getModel().setValue(BIZ_NAME, null);
    }

    public void afterBindData(EventObject e) {
        if (StringUtils.equalsIgnoreCase((CharSequence)this.getView().getParentView().getPageCache().get(TBL_SHARE), (CharSequence)ONE)) {
            this.getModel().setValue(RULE_TYPE, (Object)"GX");
            this.getView().getParentView().getPageCache().remove(TBL_SHARE);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.getView().getParentView().getPageCache().get(TBL_PRIUSE), (CharSequence)ONE)) {
            this.getModel().setValue(RULE_TYPE, (Object)"ZY");
            this.getView().getParentView().getPageCache().remove(TBL_PRIUSE);
        }
        this.getModel().setDataChanged(false);
        this.setTransactionDirectionDataSource((DynamicObject)this.getModel().getValue(TRANSACTIONTYPE));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)ORG)) {
            List<Long> orgIds = IctmTaxOrgCommonBusiness.getTaxcOrgIdsByIsTaxpayerWithPerm();
            QFilter idFilter = new QFilter("id", "in", orgIds);
            evt.getCustomQFilters().add(idFilter);
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)TABLE)) {
            String projectNumber;
            DynamicObject rulePurposeObject = (DynamicObject)this.getModel().getValue(RULEPURPOSE);
            if (rulePurposeObject == null) {
                evt.setCancel(true);
                return;
            }
            DynamicObject transTypeObject = (DynamicObject)this.getModel().getValue(TRANSACTIONTYPE);
            if (transTypeObject == null) {
                DynamicObject projectObject = (DynamicObject)this.getModel().getValue(ITEMNAME);
                if (projectObject == null) {
                    evt.setCancel(true);
                    return;
                }
                projectNumber = projectObject.getString("number");
            } else {
                projectNumber = transTypeObject.getString("number");
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tctb_datasource_peek_rule", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)AccessConfigFetchRuleEnum.getFetchRuleNumber(rulePurposeObject.getString("number"), projectNumber))});
            Long id = dynamicObject == null ? 0L : dynamicObject.getLong("id");
            QFilter peekrule = new QFilter("peekrule.fbasedataid", "=", (Object)id);
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(peekrule);
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)ITEMNAME) || StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)TRANSACTIONTYPE)) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(RULEPURPOSE);
            if (null == dynamicObject) return;
            QFilter parentFliter = new QFilter("parent", "=", (Object)dynamicObject.getLong("id"));
            formShowParameter.getListFilterParameter().getQFilters().add(parentFliter);
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)TRANSACTIONCONTENT)) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(TRANSACTIONTYPE);
            if (null == dynamicObject) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4ea4\u6613\u7c7b\u578b\u3002", (String)"DeclareRuleConfigPlugin_7", (String)"taxc-ictm", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            long parentId = dynamicObject.getLong("id");
            QFilter parentFliter = new QFilter("parent", "=", (Object)parentId);
            long zjrtId = 1595684761731487894L;
            if (zjrtId == parentId) {
                formShowParameter.setMultiSelect(false);
            }
            formShowParameter.getListFilterParameter().getQFilters().add(parentFliter);
            return;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)DATATYPE)) return;
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(TRANSACTIONTYPE);
        if (null == dynamicObject) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4ea4\u6613\u7c7b\u578b\u3002", (String)"DeclareRuleConfigPlugin_7", (String)"taxc-ictm", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        long parentId = dynamicObject.getLong("id");
        QFilter parentFliter = new QFilter("parent", "=", (Object)parentId);
        long zjrtId = 1595684761731487894L;
        if (zjrtId == parentId) {
            formShowParameter.setMultiSelect(false);
        }
        formShowParameter.getListFilterParameter().getQFilters().add(parentFliter);
    }

    public void afterCreateNewData(EventObject e) {
        ComboEdit comboEdit = (ComboEdit)this.getControl(TRANSACTIONDIRECTION);
        ArrayList items = new ArrayList();
        comboEdit.setComboItems(items);
        this.getModel().setValue(ORG, (Object)this.getDefaultOrg());
    }

    private long getDefaultOrg() {
        long defaultOrgId;
        List<Long> orgIds = IctmTaxOrgCommonBusiness.getTaxcOrgIdsByIsTaxpayerWithPerm();
        if (!orgIds.contains(defaultOrgId = RequestContext.get().getOrgId())) {
            defaultOrgId = orgIds.get(0);
        }
        return defaultOrgId;
    }
}

