/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.basicsetting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.EntryGridOperate;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.ictm.business.networkmutualexclusion.NetworkMutualExclusionBusiness;

public abstract class SharingSchemeBasePlugin
extends AbstractFormPlugin
implements SelectRowsEventListener,
BeforeF7SelectListener,
SearchEnterListener {
    protected static final String LABEL_ADD_SCHEME_SIGN = "labelcreate";
    protected static final String TOOLBAR_SIGN = "toolbarap";
    protected static final String BD_RULE_SIGN = "rule";
    protected static final String BD_ORG_SIGN = "org";
    protected static final String SEARCH_SIGN = "searchap";
    protected static final String DOCUMENT_SHARING_SCHEME_SIGN = "planentity";
    protected static final String CARD_FIELD_NUMBER_SIGN = "carnumber";
    protected static final String CARD_FIELD_NAME_SIGN = "carname";
    protected static final String DOCUMENT_SHARING_RULE_SIGN = "ruleentity";
    protected static final String DOCUMENT_SHARING_ORG_SIGN = "orgentity";
    protected static final String FIELD_RULE_ID_SIGN = "ruleentryid";
    protected static final String FIELD_ORG_ID_SIGN = "orgentryid";
    protected static final String CACHE_CURRENT_SEARCH_TEXT_KEY = "currentSearchText";
    protected static final String CACHE_CARD_INDEXES_KEY = "cardIndexes";
    protected static final String CACHE_DELETE_FLAG_KEY = "deleteFlag";
    protected static final String CACHE_DELETE_FLAG_TRUE_VALUE = "1";
    protected static final String CACHE_AFTER_DELETE_ROW_INDEX_KEY = "afterDeleteSelectedRowIndex";
    protected static final String CACHE_FOCUS_CARD_INDEX_KEY = "focusIndex";
    private static final String CACHE_OLD_SELECT_SCHEME_ROW_INDEX_KEY = "oldSelectSchemeRowIndex";
    private static final String CACHE_NEW_SELECT_SCHEME_ROW_INDEX_KEY = "newSelectSchemeRowIndex";
    private static final String CACHE_LOCK_ID_KEY = "lockId";
    protected static final String BTN_EXIT_SIGN = "bar_close";
    protected static final String BTN_REFRESH_SIGN = "refresh";
    protected static final String BTN_IMPORT_SIGN = "importdata";
    protected static final String BTN_EXPORT_SIGN = "exportdata";
    protected static final String BTN_ADD_SHARING_SCHEME_OPERATE_CODE = "schemeadd";
    protected static final String BTN_DELETE_SHARING_SCHEME_OPERATE_CODE = "schemedelete";
    protected static final String BTN_SAVE_OPERATE_CODE = "save";
    protected static final String ACTION_SCHEME_CARD_SWITCH = "schemeCardSwitch";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{LABEL_ADD_SCHEME_SIGN});
        Toolbar toolbar = (Toolbar)this.getControl(TOOLBAR_SIGN);
        toolbar.addItemClickListener((ItemClickListener)this);
        BasedataEdit ruleEdit = (BasedataEdit)this.getControl(BD_RULE_SIGN);
        ruleEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxOrgEdit = (BasedataEdit)this.getControl(BD_ORG_SIGN);
        taxOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Search search = (Search)this.getControl(SEARCH_SIGN);
        search.addClickListener((ClickListener)this);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void initialize() {
        CardEntry cardEntry = (CardEntry)this.getControl(DOCUMENT_SHARING_SCHEME_SIGN);
        cardEntry.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().deleteEntryData(DOCUMENT_SHARING_SCHEME_SIGN);
        this.beforeLoadPageData();
        DynamicObject[] sharingSchemes = this.getSharingSchemeData();
        if (sharingSchemes == null || sharingSchemes.length == 0) {
            return;
        }
        for (DynamicObject sharingScheme : sharingSchemes) {
            this.loadSharingSchemeData(sharingScheme);
            this.loadSharingRuleData(sharingScheme);
            this.loadSharingOrgData(sharingScheme);
        }
        this.getView().updateView(DOCUMENT_SHARING_RULE_SIGN);
        this.getView().updateView(DOCUMENT_SHARING_ORG_SIGN);
        this.afterLoadPageData();
    }

    protected void beforeLoadPageData() {
    }

    protected void afterLoadPageData() {
    }

    public void pageRelease(EventObject e) {
        NetworkMutualExclusionBusiness.releaseLock(this.getPageCache().get(CACHE_LOCK_ID_KEY), "ictm_sharing_scheme");
    }

    protected abstract DynamicObject[] getSharingSchemeData();

    protected void loadSharingSchemeData(DynamicObject sharingScheme) {
        int schemeRowIndex = this.getModel().createNewEntryRow(DOCUMENT_SHARING_SCHEME_SIGN);
        this.getModel().setValue("id", sharingScheme.get("id"), schemeRowIndex);
        this.getModel().setValue("number", sharingScheme.get("number"), schemeRowIndex);
        this.getModel().setValue(CARD_FIELD_NUMBER_SIGN, sharingScheme.get("number"), schemeRowIndex);
        this.getModel().setValue("name", sharingScheme.get("name"), schemeRowIndex);
        this.getModel().setValue(CARD_FIELD_NAME_SIGN, sharingScheme.get("name"), schemeRowIndex);
        this.getModel().setValue("creator", sharingScheme.get("creator"), schemeRowIndex);
        this.getModel().setValue("createtime", sharingScheme.get("createtime"), schemeRowIndex);
        this.getModel().setValue("modifier", (Object)RequestContext.get().getCurrUserId(), schemeRowIndex);
        this.getModel().setValue("modifytime", (Object)new Date(), schemeRowIndex);
        this.getModel().setEntryCurrentRowIndex(DOCUMENT_SHARING_SCHEME_SIGN, schemeRowIndex);
        this.setSharingSchemeOtherFieldValue(sharingScheme, schemeRowIndex);
    }

    protected abstract void setSharingSchemeOtherFieldValue(DynamicObject var1, int var2);

    protected void loadSharingRuleData(DynamicObject sharingScheme) {
        DynamicObjectCollection rules = sharingScheme.getDynamicObjectCollection(DOCUMENT_SHARING_RULE_SIGN);
        rules.forEach(rule -> {
            int ruleRowIndex = this.getModel().createNewEntryRow(DOCUMENT_SHARING_RULE_SIGN);
            this.getModel().setValue(BD_RULE_SIGN, rule.get(BD_RULE_SIGN), ruleRowIndex);
            this.getModel().setValue(FIELD_RULE_ID_SIGN, rule.get("id"), ruleRowIndex);
            this.setSharingRuleOtherFieldValue((DynamicObject)rule, ruleRowIndex);
        });
    }

    protected abstract void setSharingRuleOtherFieldValue(DynamicObject var1, int var2);

    protected void loadSharingOrgData(DynamicObject sharingScheme) {
        DynamicObjectCollection orgCollection = sharingScheme.getDynamicObjectCollection(DOCUMENT_SHARING_ORG_SIGN);
        orgCollection.forEach(org -> {
            int orgRowIndex = this.getModel().createNewEntryRow(DOCUMENT_SHARING_ORG_SIGN);
            this.getModel().setValue(BD_ORG_SIGN, org.get(BD_ORG_SIGN), orgRowIndex);
            this.getModel().setValue(FIELD_ORG_ID_SIGN, org.get("id"), orgRowIndex);
            this.setSharingOrgOtherFieldValue((DynamicObject)org, orgRowIndex);
        });
    }

    protected abstract void setSharingOrgOtherFieldValue(DynamicObject var1, int var2);

    public List<String> getSearchList(SearchEnterEvent evt) {
        return this.getSearchList(evt.getText());
    }

    protected List<String> getSearchList(String inputText) {
        DataSet dataSet = this.buildDataSet();
        String searchText = String.format("%s%s%s", "%", inputText, "%");
        List<QFilter> filters = Stream.of(new QFilter("name", "like", (Object)searchText), new QFilter("number", "like", (Object)searchText)).collect(Collectors.toList());
        this.addExtendDataSetLikeFilter(filters, searchText);
        ArrayList<String> result = new ArrayList<String>();
        for (QFilter filter : filters) {
            DataSet filterDataSet = dataSet.copy().filter(filter.toString());
            if (filterDataSet.isEmpty()) continue;
            filterDataSet.forEach(row -> result.add(row.getString(filter.getProperty())));
            filterDataSet.close();
        }
        dataSet.close();
        return result;
    }

    private DataSet buildDataSet() {
        List<String> fieldNames = Stream.of("index", "number", "name").collect(Collectors.toList());
        List<DataType> dataTypes = Stream.of(DataType.IntegerType, DataType.StringType, DataType.StringType).collect(Collectors.toList());
        Map<String, DataType> extendFieldNameAndDataType = this.getExtendFieldNameAndDataType();
        if (!extendFieldNameAndDataType.isEmpty()) {
            extendFieldNameAndDataType.forEach((fieldName, dataType) -> {
                fieldNames.add((String)fieldName);
                dataTypes.add((DataType)dataType);
            });
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fieldNames.toArray(new String[fieldNames.size()]), (DataType[])dataTypes.toArray(new DataType[dataTypes.size()]));
        ArrayList<Object[]> coll = new ArrayList<Object[]>(16);
        int entryRowCount = this.getModel().getEntryRowCount(DOCUMENT_SHARING_SCHEME_SIGN);
        for (int i = 0; i < entryRowCount; ++i) {
            Object[] value = new Object[fieldNames.size()];
            DynamicObject scheme = (DynamicObject)this.getModel().getEntryEntity(DOCUMENT_SHARING_SCHEME_SIGN).get(i);
            value[0] = i;
            value[1] = scheme.getString(CARD_FIELD_NUMBER_SIGN);
            value[2] = scheme.getString(CARD_FIELD_NAME_SIGN);
            this.setDataSetRowValue(value, scheme);
            coll.add(value);
        }
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        DataSet dataSet = Algo.create((String)"ictm_sharing_scheme").createDataSet(new Input[]{inputs});
        return dataSet;
    }

    protected Map<String, DataType> getExtendFieldNameAndDataType() {
        return new HashMap<String, DataType>(0);
    }

    protected abstract void setDataSetRowValue(Object[] var1, DynamicObject var2);

    protected abstract void addExtendDataSetLikeFilter(List<QFilter> var1, String var2);

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        if (!StringUtil.equalsIgnoreCase((CharSequence)this.getPageCache().get(CACHE_CURRENT_SEARCH_TEXT_KEY), (CharSequence)searchText)) {
            this.generateCardIndexes(searchText);
        }
        this.selectListRowAndPutCache();
    }

    private void generateCardIndexes(String searchText) {
        this.getPageCache().put(CACHE_CURRENT_SEARCH_TEXT_KEY, searchText);
        String likeSearchText = String.format("%s%s%s", "%", searchText, "%");
        QFilter filter = new QFilter("name", "like", (Object)likeSearchText).or(new QFilter("number", "like", (Object)likeSearchText));
        List<QFilter> filters = this.getExtendLikeSearchFilter(likeSearchText);
        if (CollectionUtils.isNotEmpty(filters)) {
            filters.forEach(f -> filter.or(f));
        }
        DataSet dataSet = this.buildDataSet().filter(filter.toString());
        ArrayList rowIndexes = new ArrayList();
        dataSet.forEach(row -> rowIndexes.add(row.getInteger("index")));
        dataSet.close();
        Collections.sort(rowIndexes);
        AtomicInteger index = new AtomicInteger();
        Map<String, Integer> cardIndexMap = rowIndexes.stream().collect(Collectors.toMap(k -> String.valueOf(index.getAndIncrement()), v -> v));
        this.getPageCache().put(CACHE_CARD_INDEXES_KEY, SerializationUtils.toJsonString(cardIndexMap));
        if (!cardIndexMap.isEmpty()) {
            this.getPageCache().put(CACHE_FOCUS_CARD_INDEX_KEY, "-1");
        }
    }

    protected abstract List<QFilter> getExtendLikeSearchFilter(String var1);

    private void selectListRowAndPutCache() {
        Map cardIndexMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_CARD_INDEXES_KEY), Map.class);
        if (cardIndexMap.isEmpty()) {
            return;
        }
        Integer focusCardIndex = Integer.valueOf(this.getPageCache().get(CACHE_FOCUS_CARD_INDEX_KEY));
        if (cardIndexMap.size() - 1 > focusCardIndex) {
            int nextFocusCardIndex = focusCardIndex + 1;
            this.selectListRow((Integer)cardIndexMap.get(String.valueOf(nextFocusCardIndex)));
            this.getPageCache().put(CACHE_FOCUS_CARD_INDEX_KEY, String.valueOf(nextFocusCardIndex));
        } else if (cardIndexMap.size() - 1 == focusCardIndex) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u641c\u7d22\u5230\u6700\u540e\u4e00\u884c\u3002", (String)"SharingSchemeBasePlugin_0", (String)"taxc-ictm", (Object[])new Object[0]));
        }
    }

    private void selectListRow(int rowIndex) {
        CardEntry planCardEntry = (CardEntry)this.getControl(DOCUMENT_SHARING_SCHEME_SIGN);
        int entryCount = this.getModel().getEntryRowCount(DOCUMENT_SHARING_SCHEME_SIGN);
        if (entryCount == 0 || rowIndex + 1 > entryCount) {
            return;
        }
        int nowRow = this.getCurSelectRowIndex();
        planCardEntry.selectCard(Integer.valueOf(rowIndex));
        planCardEntry.selectRowsChanged(Collections.singletonList(rowIndex), Collections.singletonList(nowRow));
    }

    protected int getCurSelectRowIndex() {
        int rowIndex = 0;
        EntryGrid planEntry = (EntryGrid)this.getControl(DOCUMENT_SHARING_SCHEME_SIGN);
        int[] ids = planEntry.getSelectRows();
        if (!ObjectUtils.isEmpty((Object)ids)) {
            rowIndex = ids[0];
        }
        return rowIndex;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("name".equals(e.getProperty().getName())) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            int rowIndex = this.getCurSelectRowIndex();
            if (rowIndex < 0) {
                return;
            }
            if (newValue instanceof LocaleDynamicObjectCollection) {
                this.getModel().setValue(CARD_FIELD_NAME_SIGN, (Object)this.getLangValue(newValue), rowIndex);
            } else {
                this.getModel().setValue(CARD_FIELD_NAME_SIGN, newValue, rowIndex);
            }
        }
    }

    private String getLangValue(Object object) {
        String value = null;
        String lang = RequestContext.get().getLang().toString();
        LocaleDynamicObjectCollection valueCol = (LocaleDynamicObjectCollection)object;
        for (DynamicObject langObj : valueCol) {
            String localeId = langObj.getString("localeid");
            String version = langObj.getString("name");
            if (lang == null || !lang.equals(localeId)) continue;
            value = version;
            break;
        }
        return value;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (StringUtil.equalsIgnoreCase((CharSequence)evt.getItemKey(), (CharSequence)BTN_EXIT_SIGN) && this.ensureModifiedDataNotSave(this.getCurSelectRowIndex())) {
            evt.setCancel(true);
            this.showConfirm(BTN_EXIT_SIGN, ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SharingSchemeBasePlugin_1", (String)"taxc-ictm", (Object[])new Object[0]), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"SharingSchemeBasePlugin_2", (String)"taxc-ictm", (Object[])new Object[0]), ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SharingSchemeBasePlugin_3", (String)"taxc-ictm", (Object[])new Object[0]));
        }
    }

    protected boolean ensureModifiedDataNotSave(int curSelectRowIndex) {
        DynamicObjectCollection schemeCollection = this.getModel().getEntryEntity(DOCUMENT_SHARING_SCHEME_SIGN);
        if (CollectionUtils.isEmpty((Collection)schemeCollection)) {
            return false;
        }
        DynamicObject scheme = (DynamicObject)schemeCollection.get(curSelectRowIndex);
        DynamicObject dbScheme = this.getSharingSchemeById((Long)this.getModel().getValue("id", curSelectRowIndex));
        if (dbScheme == null) {
            return true;
        }
        Boolean sharingSchemeIsChanged = !StringUtil.equalsIgnoreCase((CharSequence)scheme.getString(CARD_FIELD_NUMBER_SIGN), (CharSequence)dbScheme.getString("number")) || !StringUtil.equalsIgnoreCase((CharSequence)scheme.getString(CARD_FIELD_NAME_SIGN), (CharSequence)dbScheme.getString("name")) || this.sharingSchemeOtherFieldChanged(dbScheme);
        if (sharingSchemeIsChanged.booleanValue()) {
            return true;
        }
        List ruleIds = scheme.getDynamicObjectCollection(DOCUMENT_SHARING_RULE_SIGN).stream().map(rule -> rule.getString("rule.id")).collect(Collectors.toList());
        List dbRuleIds = dbScheme.getDynamicObjectCollection(DOCUMENT_SHARING_RULE_SIGN).stream().map(rule -> rule.getString("rule.id")).collect(Collectors.toList());
        if (ruleIds.size() != dbRuleIds.size() || !ruleIds.containsAll(dbRuleIds)) {
            return true;
        }
        List orgIds = scheme.getDynamicObjectCollection(DOCUMENT_SHARING_ORG_SIGN).stream().map(rule -> rule.getString("org.id")).collect(Collectors.toList());
        List dbOrgIds = dbScheme.getDynamicObjectCollection(DOCUMENT_SHARING_ORG_SIGN).stream().map(rule -> rule.getString("org.id")).collect(Collectors.toList());
        return orgIds.size() != dbOrgIds.size() || !orgIds.containsAll(dbOrgIds);
    }

    protected boolean sharingSchemeOtherFieldChanged(DynamicObject dbScheme) {
        return false;
    }

    private void showConfirm(String callbackId, String noBtnValue, String yesBtnValue, String msg) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(callbackId, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.No.getValue(), noBtnValue);
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), yesBtnValue);
        MessageBoxOptions options = MessageBoxOptions.YesNo;
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        List newRows = evt.getNewRows();
        if (CollectionUtils.isNotEmpty((Collection)newRows)) {
            DynamicObject curSelectScheme;
            Map cardIndexMap;
            Integer newRowIndex = (Integer)newRows.get(0);
            Integer oldRowIndex = (Integer)evt.getOldRows().get(0);
            if (this.ensureModifiedDataNotSave(oldRowIndex) && !newRowIndex.equals(oldRowIndex)) {
                this.showConfirm(ACTION_SCHEME_CARD_SWITCH, ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SharingSchemeBasePlugin_1", (String)"taxc-ictm", (Object[])new Object[0]), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"SharingSchemeBasePlugin_2", (String)"taxc-ictm", (Object[])new Object[0]), ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\\r\\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SharingSchemeBasePlugin_4", (String)"taxc-ictm", (Object[])new Object[0]));
                this.getPageCache().put(CACHE_OLD_SELECT_SCHEME_ROW_INDEX_KEY, String.valueOf(oldRowIndex));
                this.getPageCache().put(CACHE_NEW_SELECT_SCHEME_ROW_INDEX_KEY, String.valueOf(newRowIndex));
                return;
            }
            String cacheFocusRowIndex = this.getPageCache().get(CACHE_FOCUS_CARD_INDEX_KEY);
            if (cacheFocusRowIndex != null && !"-1".equals(cacheFocusRowIndex) && !newRowIndex.equals((cardIndexMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_CARD_INDEXES_KEY), Map.class)).get(cacheFocusRowIndex))) {
                this.getPageCache().put(CACHE_FOCUS_CARD_INDEX_KEY, "-1");
            }
            if ((curSelectScheme = this.getModel().getEntryRowEntity(DOCUMENT_SHARING_SCHEME_SIGN, newRowIndex.intValue())) == null) {
                this.getModel().setValue("name", (Object)"");
                this.getModel().setValue("number", (Object)"");
            } else {
                this.getModel().setValue("name", curSelectScheme.get(CARD_FIELD_NAME_SIGN));
                this.getModel().setValue("number", curSelectScheme.get(CARD_FIELD_NUMBER_SIGN));
            }
            this.setSelectSharingSchemeOtherFieldValue(curSelectScheme);
            this.getView().updateView("number");
            this.getView().updateView("name");
            NetworkMutualExclusionBusiness.releaseLock(this.getPageCache().get(CACHE_LOCK_ID_KEY), "ictm_sharing_scheme");
            this.getPageCache().remove(CACHE_LOCK_ID_KEY);
            if (!this.selectRowsChangeBeforeLockHandler(curSelectScheme)) {
                return;
            }
            if (curSelectScheme == null) {
                return;
            }
            if (curSelectScheme.getLong("id") == 0L) {
                this.unLockControl();
                return;
            }
            if (NetworkMutualExclusionBusiness.checkLock(curSelectScheme.getString("id"), "ictm_sharing_scheme", this.getView())) {
                this.lockControl();
            } else {
                NetworkMutualExclusionBusiness.requireLock(this.getView(), curSelectScheme.getString("id"), "ictm_sharing_scheme");
                this.getPageCache().put(CACHE_LOCK_ID_KEY, curSelectScheme.getString("id"));
                this.unLockControl();
            }
        }
    }

    protected void setSelectSharingSchemeOtherFieldValue(DynamicObject curSelectScheme) {
    }

    protected boolean selectRowsChangeBeforeLockHandler(DynamicObject curSelectScheme) {
        return true;
    }

    protected abstract void lockControl();

    protected abstract void unLockControl();

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtil.equalsIgnoreCase((CharSequence)callBackId, (CharSequence)BTN_EXIT_SIGN) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().close();
        } else if (StringUtil.equalsIgnoreCase((CharSequence)callBackId, (CharSequence)ACTION_SCHEME_CARD_SWITCH)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                int oldRowIndex = Integer.parseInt(this.getPageCache().get(CACHE_OLD_SELECT_SCHEME_ROW_INDEX_KEY));
                DynamicObject oldScheme = this.getModel().getEntryRowEntity(DOCUMENT_SHARING_SCHEME_SIGN, oldRowIndex);
                DynamicObject dbScheme = this.getSharingSchemeById(oldScheme.getLong("id"));
                if (dbScheme != null) {
                    oldScheme.set(CARD_FIELD_NAME_SIGN, dbScheme.get("name"));
                    oldScheme.set(CARD_FIELD_NUMBER_SIGN, dbScheme.get("number"));
                    this.switchSharingSchemeRestoreData(oldScheme, dbScheme);
                    this.getModel().setEntryCurrentRowIndex(DOCUMENT_SHARING_SCHEME_SIGN, oldRowIndex);
                    this.getModel().deleteEntryData(DOCUMENT_SHARING_RULE_SIGN);
                    dbScheme.getDynamicObjectCollection(DOCUMENT_SHARING_RULE_SIGN).forEach(rule -> {
                        int ruleRowIndex = this.getModel().createNewEntryRow(DOCUMENT_SHARING_RULE_SIGN);
                        this.getModel().setValue(BD_RULE_SIGN, rule.get(BD_RULE_SIGN), ruleRowIndex);
                        this.getModel().setValue(FIELD_RULE_ID_SIGN, rule.get("id"), ruleRowIndex);
                    });
                    this.getModel().deleteEntryData(DOCUMENT_SHARING_ORG_SIGN);
                    dbScheme.getDynamicObjectCollection(DOCUMENT_SHARING_ORG_SIGN).forEach(org -> {
                        int orgRowIndex = this.getModel().createNewEntryRow(DOCUMENT_SHARING_ORG_SIGN);
                        this.getModel().setValue(BD_ORG_SIGN, org.get(BD_ORG_SIGN), orgRowIndex);
                        this.getModel().setValue(FIELD_ORG_ID_SIGN, (Object)org.getLong("id"), orgRowIndex);
                    });
                    this.getView().updateView(DOCUMENT_SHARING_SCHEME_SIGN);
                } else {
                    this.getModel().deleteEntryRow(DOCUMENT_SHARING_SCHEME_SIGN, oldRowIndex);
                }
                this.selectListRow(Integer.parseInt(this.getPageCache().get(CACHE_NEW_SELECT_SCHEME_ROW_INDEX_KEY)));
            } else {
                this.selectListRow(Integer.parseInt(this.getPageCache().get(CACHE_OLD_SELECT_SCHEME_ROW_INDEX_KEY)));
            }
        }
    }

    protected abstract DynamicObject getSharingSchemeById(Long var1);

    protected abstract void switchSharingSchemeRestoreData(DynamicObject var1, DynamicObject var2);

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtil.equalsIgnoreCase((CharSequence)BTN_REFRESH_SIGN, (CharSequence)itemKey)) {
            this.getView().invokeOperation(BTN_REFRESH_SIGN);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)BTN_IMPORT_SIGN, (CharSequence)itemKey)) {
            this.showImportDataForm();
        } else if (StringUtil.equalsIgnoreCase((CharSequence)BTN_EXPORT_SIGN, (CharSequence)itemKey)) {
            this.showExportDataForm();
        }
    }

    protected abstract void showImportDataForm();

    protected abstract void showExportDataForm();

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (StringUtil.equalsIgnoreCase((CharSequence)beforeF7SelectEvent.getProperty().getName(), (CharSequence)BD_ORG_SIGN)) {
            this.sharingOrgBeforeF7Select(beforeF7SelectEvent);
            return;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)beforeF7SelectEvent.getProperty().getName(), (CharSequence)BD_RULE_SIGN)) {
            this.sharingRuleBeforeF7Select(beforeF7SelectEvent);
        }
    }

    protected void sharingOrgBeforeF7Select(BeforeF7SelectEvent event) {
        QFilter filter;
        DynamicObjectCollection schemes = this.getModel().getEntryEntity(DOCUMENT_SHARING_SCHEME_SIGN);
        List selectedOrgIds = schemes.stream().flatMap(scheme -> scheme.getDynamicObjectCollection(DOCUMENT_SHARING_ORG_SIGN).stream().filter(org -> !ObjectUtils.isEmpty((Object)org)).map(org -> org.getLong("org.id"))).collect(Collectors.toList());
        TaxResult curUserOrgIds = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId());
        if (curUserOrgIds == null || ((List)curUserOrgIds.getData()).isEmpty()) {
            filter = new QFilter("id", "=", (Object)0L);
        } else {
            ((List)curUserOrgIds.getData()).removeAll(selectedOrgIds);
            filter = new QFilter("id", "in", curUserOrgIds.getData());
        }
        event.getCustomQFilters().add(filter);
    }

    protected abstract void sharingRuleBeforeF7Select(BeforeF7SelectEvent var1);

    public void afterBindData(EventObject e) {
        String deleteFlag = this.getPageCache().get(CACHE_DELETE_FLAG_KEY);
        if (StringUtil.isEmpty((CharSequence)deleteFlag)) {
            this.selectListRow(0);
        } else if (CACHE_DELETE_FLAG_TRUE_VALUE.equals(deleteFlag)) {
            int defaultSelectRowIndex = Integer.parseInt(this.getPageCache().get(CACHE_AFTER_DELETE_ROW_INDEX_KEY));
            this.selectListRow(defaultSelectRowIndex);
            this.getPageCache().remove(CACHE_DELETE_FLAG_KEY);
        }
        this.setVisible();
    }

    protected void setVisible() {
        int row = this.getModel().getEntryRowCount(DOCUMENT_SHARING_SCHEME_SIGN);
        if (row > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexnodata"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexdata", DOCUMENT_SHARING_SCHEME_SIGN});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexnodata"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdata", DOCUMENT_SHARING_SCHEME_SIGN});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject curSelectData;
        Object source = args.getSource();
        Boolean isSave = source instanceof Donothing && BTN_SAVE_OPERATE_CODE.equals(((Donothing)source).getOperateKey());
        Boolean isDelete = source instanceof DeleteEntry && BTN_DELETE_SHARING_SCHEME_OPERATE_CODE.equals(((DeleteEntry)source).getOperateKey());
        if ((isSave.booleanValue() || isDelete.booleanValue()) && NetworkMutualExclusionBusiness.checkLock((curSelectData = this.getModel().getEntryRowEntity(DOCUMENT_SHARING_SCHEME_SIGN, this.getCurSelectRowIndex())).getString("id"), "ictm_sharing_scheme", this.getView())) {
            args.setCancel(true);
            return;
        }
        if (!(source instanceof EntryGridOperate)) {
            return;
        }
        String operateKey = ((EntryGridOperate)source).getOperateKey();
        if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)BTN_ADD_SHARING_SCHEME_OPERATE_CODE)) {
            if (this.ensureModifiedDataNotSave(this.getCurSelectRowIndex())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u65b0\u589e\u5171\u4eab\u65b9\u6848\u3002", (String)"SharingSchemeBasePlugin_5", (String)"taxc-ictm", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)BTN_DELETE_SHARING_SCHEME_OPERATE_CODE)) {
            int curSelectRowIndex = this.getCurSelectRowIndex();
            DynamicObject curSelectScheme = this.getModel().getEntryRowEntity(DOCUMENT_SHARING_SCHEME_SIGN, curSelectRowIndex);
            this.deleteSharingScheme(curSelectScheme.getLong("id"));
            this.getPageCache().put(CACHE_DELETE_FLAG_KEY, CACHE_DELETE_FLAG_TRUE_VALUE);
            int schemeRowCount = this.getModel().getEntryRowCount(DOCUMENT_SHARING_SCHEME_SIGN);
            int defaultSelectRowIndex = curSelectRowIndex;
            if (curSelectRowIndex + 1 >= schemeRowCount) {
                defaultSelectRowIndex = 0;
            }
            this.getPageCache().put(CACHE_AFTER_DELETE_ROW_INDEX_KEY, String.valueOf(defaultSelectRowIndex));
        }
    }

    protected abstract void deleteSharingScheme(long var1);

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        this.setVisible();
        int selectRow = this.getCurSelectRowIndex();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtil.equalsIgnoreCase((CharSequence)BTN_ADD_SHARING_SCHEME_OPERATE_CODE, (CharSequence)operateKey)) {
            this.selectListRow(selectRow);
            String number = this.getAddSharingSchemeNumber();
            this.getModel().setValue("number", (Object)number, selectRow);
            this.getModel().setValue(CARD_FIELD_NUMBER_SIGN, (Object)number, selectRow);
            this.getModel().setEntryCurrentRowIndex(DOCUMENT_SHARING_SCHEME_SIGN, selectRow);
            this.getModel().createNewEntryRow(DOCUMENT_SHARING_RULE_SIGN);
            this.getModel().createNewEntryRow(DOCUMENT_SHARING_ORG_SIGN);
            this.setAddSharingSchemeOtherDefaultValue();
            return;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)BTN_SAVE_OPERATE_CODE, (CharSequence)operateKey)) {
            OperationResult result = afterDoOperationEventArgs.getOperationResult();
            if (!result.isSuccess()) {
                return;
            }
            DynamicObject curSelectData = this.getModel().getEntryRowEntity(DOCUMENT_SHARING_SCHEME_SIGN, this.getCurSelectRowIndex());
            if (!this.checkSaveDataBeforeSave(curSelectData)) {
                return;
            }
            this.saveData(curSelectData);
            this.selectListRow(selectRow);
            return;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)BTN_DELETE_SHARING_SCHEME_OPERATE_CODE, (CharSequence)operateKey)) {
            this.getView().invokeOperation(BTN_REFRESH_SIGN);
        }
    }

    protected abstract String getAddSharingSchemeNumber();

    protected abstract void setAddSharingSchemeOtherDefaultValue();

    protected abstract boolean checkSaveDataBeforeSave(DynamicObject var1);

    protected void saveData(DynamicObject curSelectData) {
        DynamicObject saveSchemeObject;
        long schemeId = curSelectData.getLong("id");
        if (ObjectUtils.isEmpty((Object)schemeId) || schemeId == 0L) {
            saveSchemeObject = this.newSharingScheme();
            saveSchemeObject.set("creator", curSelectData.get("creator"));
            saveSchemeObject.set("createtime", curSelectData.get("createtime"));
        } else {
            saveSchemeObject = this.getSharingSchemeById(schemeId);
        }
        saveSchemeObject.set("number", curSelectData.get(CARD_FIELD_NUMBER_SIGN));
        saveSchemeObject.set("name", curSelectData.get(CARD_FIELD_NAME_SIGN));
        saveSchemeObject.set("modifier", curSelectData.get("modifier"));
        saveSchemeObject.set("modifytime", curSelectData.get("modifytime"));
        saveSchemeObject.set("status", (Object)"C");
        saveSchemeObject.set("enable", (Object)CACHE_DELETE_FLAG_TRUE_VALUE);
        this.setOtherFieldValue(saveSchemeObject, curSelectData);
        DynamicObjectCollection ruleCollection = curSelectData.getDynamicObjectCollection(DOCUMENT_SHARING_RULE_SIGN);
        DynamicObjectCollection saveRuleCollection = saveSchemeObject.getDynamicObjectCollection(DOCUMENT_SHARING_RULE_SIGN);
        saveRuleCollection.clear();
        AtomicInteger ruleSeq = new AtomicInteger();
        ruleCollection.forEach(rule -> {
            DynamicObject saveRule = saveRuleCollection.addNew();
            saveRule.set("seq", (Object)ruleSeq.get());
            saveRule.set("id", rule.get(FIELD_RULE_ID_SIGN));
            saveRule.set(BD_RULE_SIGN, rule.getDynamicObject(BD_RULE_SIGN).get("id"));
            ruleSeq.incrementAndGet();
        });
        DynamicObjectCollection orgCollection = curSelectData.getDynamicObjectCollection(DOCUMENT_SHARING_ORG_SIGN);
        DynamicObjectCollection saveOrgCollection = saveSchemeObject.getDynamicObjectCollection(DOCUMENT_SHARING_ORG_SIGN);
        saveOrgCollection.clear();
        AtomicInteger orgSeq = new AtomicInteger();
        orgCollection.forEach(org -> {
            DynamicObject saveOrg = saveOrgCollection.addNew();
            saveOrg.set("seq", (Object)orgSeq.get());
            saveOrg.set("id", org.get(FIELD_ORG_ID_SIGN));
            saveOrg.set(BD_ORG_SIGN, org.getDynamicObject(BD_ORG_SIGN).get("id"));
        });
        this.saveDataToDb(saveSchemeObject);
    }

    protected abstract DynamicObject newSharingScheme();

    protected void setOtherFieldValue(DynamicObject saveSchemeObject, DynamicObject curSelectData) {
    }

    protected abstract void saveDataToDb(DynamicObject var1);
}

