/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.basicsetting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.ictm.business.sharingscheme.SharingSchemeBusiness;
import kd.taxc.ictm.business.taxorg.IctmTaxOrgCommonBusiness;
import kd.taxc.ictm.formplugin.basicsetting.SharingSchemeBasePlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class SharingSchemePlugin
extends SharingSchemeBasePlugin {
    private static final String FIELD_CREATE_ORG_SIGN = "createorg";
    private static final String CARD_FIELD_CREATE_ORG_SIGN = "carcreateorg";
    private static final String CARD_FIELD_CREATE_ORG_ID_SIGN = "createorgid";
    private static final String CACHE_CREATE_ORG_CHANGE_BY_SWITCH_CARD_KEY = "notChangeCreateOrg";
    private List<Long> userPermissionOrgIds;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit createOrgEdit = (BasedataEdit)this.getControl(FIELD_CREATE_ORG_SIGN);
        createOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        if (StringUtil.equalsIgnoreCase((CharSequence)event.getProperty().getName(), (CharSequence)FIELD_CREATE_ORG_SIGN)) {
            List<Long> orgIds = IctmTaxOrgCommonBusiness.getTaxcOrgIdsByIsTaxpayerWithPerm();
            QFilter filter = orgIds.isEmpty() ? new QFilter("id", "=", (Object)0L) : new QFilter("id", "in", orgIds);
            event.getCustomQFilters().add(filter);
        }
    }

    @Override
    protected void beforeLoadPageData() {
        this.userPermissionOrgIds = IctmTaxOrgCommonBusiness.getTaxcOrgIdsByIsTaxpayerWithPerm();
    }

    @Override
    protected DynamicObject[] getSharingSchemeData() {
        QFilter filter = CollectionUtils.isEmpty(this.userPermissionOrgIds) ? new QFilter("createorg.id", "=", (Object)0L) : new QFilter("createorg.id", "in", this.userPermissionOrgIds).or("orgentity.org.id", "in", this.userPermissionOrgIds);
        return SharingSchemeBusiness.getData(new QFilter[]{filter});
    }

    @Override
    protected void setSharingSchemeOtherFieldValue(DynamicObject sharingScheme, int schemeRowIndex) {
        if (schemeRowIndex == 0) {
            this.getModel().setValue(FIELD_CREATE_ORG_SIGN, sharingScheme.getDynamicObject(FIELD_CREATE_ORG_SIGN).get("id"));
        }
        this.getModel().setValue(CARD_FIELD_CREATE_ORG_ID_SIGN, sharingScheme.getDynamicObject(FIELD_CREATE_ORG_SIGN).get("id"), schemeRowIndex);
        this.getModel().setValue(CARD_FIELD_CREATE_ORG_SIGN, sharingScheme.getDynamicObject(FIELD_CREATE_ORG_SIGN).get("name"), schemeRowIndex);
    }

    @Override
    protected void setSharingRuleOtherFieldValue(DynamicObject sharingRule, int ruleRowIndex) {
    }

    @Override
    protected void loadSharingOrgData(DynamicObject sharingScheme) {
        DynamicObjectCollection orgCollection = sharingScheme.getDynamicObjectCollection("orgentity");
        for (DynamicObject orgObject : orgCollection) {
            if (this.userPermissionOrgIds.stream().noneMatch(p -> p.longValue() == orgObject.getDynamicObject("org").getLong("id"))) continue;
            int orgRowIndex = this.getModel().createNewEntryRow("orgentity");
            this.getModel().setValue("org", orgObject.get("org"), orgRowIndex);
            this.getModel().setValue("orgentryid", orgObject.get("id"), orgRowIndex);
            this.setSharingOrgOtherFieldValue(orgObject, orgRowIndex);
        }
    }

    @Override
    protected void setSharingOrgOtherFieldValue(DynamicObject sharingOrg, int orgRowIndex) {
    }

    @Override
    protected Map<String, DataType> getExtendFieldNameAndDataType() {
        HashMap<String, DataType> result = new HashMap<String, DataType>(1);
        result.put(FIELD_CREATE_ORG_SIGN, (DataType)DataType.StringType);
        return result;
    }

    @Override
    protected void setDataSetRowValue(Object[] rowValue, DynamicObject sharingScheme) {
        rowValue[3] = sharingScheme.getString(CARD_FIELD_CREATE_ORG_SIGN);
    }

    @Override
    protected void addExtendDataSetLikeFilter(List<QFilter> filters, String searchText) {
        filters.add(new QFilter(FIELD_CREATE_ORG_SIGN, "=", (Object)searchText));
    }

    @Override
    protected List<QFilter> getExtendLikeSearchFilter(String likeSearchText) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
        filters.add(new QFilter(FIELD_CREATE_ORG_SIGN, "like", (Object)likeSearchText));
        return filters;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (FIELD_CREATE_ORG_SIGN.equals(e.getProperty().getName())) {
            if (StringUtils.isNotEmpty((String)this.getPageCache().get(CACHE_CREATE_ORG_CHANGE_BY_SWITCH_CARD_KEY))) {
                this.getPageCache().remove(CACHE_CREATE_ORG_CHANGE_BY_SWITCH_CARD_KEY);
                return;
            }
            int rowIndex = this.getCurSelectRowIndex();
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (ObjectUtils.isEmpty((Object)newValue)) {
                this.getModel().setValue(CARD_FIELD_CREATE_ORG_SIGN, (Object)"", rowIndex);
            } else {
                this.getModel().setValue(CARD_FIELD_CREATE_ORG_SIGN, (Object)((DynamicObject)newValue).getString("name"), rowIndex);
            }
            this.getModel().deleteEntryData("ruleentity");
            this.getModel().createNewEntryRow("ruleentity");
        }
    }

    @Override
    protected void setSelectSharingSchemeOtherFieldValue(DynamicObject curSelectScheme) {
        if (curSelectScheme == null) {
            this.getModel().setValue(FIELD_CREATE_ORG_SIGN, (Object)0L);
        } else if (curSelectScheme.getLong(CARD_FIELD_CREATE_ORG_ID_SIGN) != 0L) {
            if (this.getModel().getValue(FIELD_CREATE_ORG_SIGN) == null || ((DynamicObject)this.getModel().getValue(FIELD_CREATE_ORG_SIGN)).getLong("id") != curSelectScheme.getLong(CARD_FIELD_CREATE_ORG_ID_SIGN)) {
                this.getPageCache().put(CACHE_CREATE_ORG_CHANGE_BY_SWITCH_CARD_KEY, Boolean.TRUE.toString());
                this.getModel().setValue(FIELD_CREATE_ORG_SIGN, curSelectScheme.get(CARD_FIELD_CREATE_ORG_ID_SIGN));
            }
            this.getView().updateView(FIELD_CREATE_ORG_SIGN);
        }
    }

    @Override
    protected boolean selectRowsChangeBeforeLockHandler(DynamicObject curSelectScheme) {
        List<Long> orgIds = IctmTaxOrgCommonBusiness.getTaxcOrgIdsByIsTaxpayerWithPerm();
        if (this.getModel().getValue(FIELD_CREATE_ORG_SIGN) == null) {
            return true;
        }
        long curSelectSchemeCreateOrg = ((DynamicObject)this.getModel().getValue(FIELD_CREATE_ORG_SIGN)).getLong("id");
        if (orgIds.stream().noneMatch(orgId -> orgId.equals(curSelectSchemeCreateOrg))) {
            this.lockControl();
            return false;
        }
        return true;
    }

    @Override
    protected void lockControl() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"flexdata", "save1", "delete1"});
        CardEntry planCardEntry = (CardEntry)this.getControl("planentity");
        planCardEntry.setChildEnable(Boolean.FALSE.booleanValue(), this.getCurSelectRowIndex(), new String[]{"vectorap"});
    }

    @Override
    protected void unLockControl() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"flexdata", "save1", "delete1"});
        CardEntry planCardEntry = (CardEntry)this.getControl("planentity");
        planCardEntry.setChildEnable(Boolean.TRUE.booleanValue(), this.getCurSelectRowIndex(), new String[]{"vectorap"});
    }

    @Override
    protected DynamicObject getSharingSchemeById(Long id) {
        return SharingSchemeBusiness.getDataById(id);
    }

    @Override
    protected void switchSharingSchemeRestoreData(DynamicObject curSharingScheme, DynamicObject dbSharingScheme) {
        curSharingScheme.set(CARD_FIELD_CREATE_ORG_SIGN, (Object)dbSharingScheme.getDynamicObject(FIELD_CREATE_ORG_SIGN).getString("name"));
    }

    @Override
    protected void showImportDataForm() {
    }

    @Override
    protected void showExportDataForm() {
    }

    @Override
    protected void sharingOrgBeforeF7Select(BeforeF7SelectEvent event) {
        QFilter filter;
        int curSelectRowIndex = this.getCurSelectRowIndex();
        DynamicObject curSelectData = (DynamicObject)this.getModel().getEntryEntity("planentity").get(curSelectRowIndex);
        List curSelectDataOrgIds = curSelectData.getDynamicObjectCollection("orgentity").stream().filter(org -> ObjectUtils.isNotEmpty((Object)org)).map(org -> org.getLong("org.id")).collect(Collectors.toList());
        List<Long> orgIds = IctmTaxOrgCommonBusiness.getTaxcOrgIdsByIsTaxpayerWithPerm();
        if (orgIds.isEmpty()) {
            filter = new QFilter("id", "=", (Object)0L);
        } else {
            orgIds.removeAll(curSelectDataOrgIds);
            filter = new QFilter("id", "in", orgIds);
        }
        event.getCustomQFilters().add(filter);
    }

    @Override
    protected void sharingRuleBeforeF7Select(BeforeF7SelectEvent event) {
        int curSelectRowIndex = this.getCurSelectRowIndex();
        if (ObjectUtils.isEmpty((Object)this.getModel().getValue(FIELD_CREATE_ORG_SIGN, curSelectRowIndex))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"SharingSchemePlugin_0", (String)"taxc-ictm", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        DynamicObject curSelectData = (DynamicObject)this.getModel().getEntryEntity("planentity").get(curSelectRowIndex);
        List curSelectDataRuleIds = curSelectData.getDynamicObjectCollection("ruleentity").stream().filter(org -> ObjectUtils.isNotEmpty((Object)org)).map(org -> org.getLong("rule.id")).collect(Collectors.toList());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("ruletype", "=", (Object)"GX"));
        filters.add(new QFilter("id", "not in", curSelectDataRuleIds));
        filters.add(new QFilter("org.id", "=", (Object)((DynamicObject)this.getModel().getValue(FIELD_CREATE_ORG_SIGN, curSelectRowIndex)).getLong("id")));
        event.setCustomQFilters(filters);
    }

    @Override
    protected void deleteSharingScheme(long sharingSchemeId) {
        DynamicObject scheme = SharingSchemeBusiness.getDataById(sharingSchemeId);
        if (scheme == null) {
            return;
        }
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        codeRuleService.recycleNumber("ictm_sharing_scheme", scheme, null, scheme.getString("number"));
        SharingSchemeBusiness.deleteDataById(sharingSchemeId);
    }

    @Override
    protected String getAddSharingSchemeNumber() {
        DynamicObject dataInfo = BusinessDataServiceHelper.newDynamicObject((String)"ictm_sharing_scheme");
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String number = codeRuleService.readNumber("ictm_sharing_scheme", dataInfo, null);
        return number;
    }

    @Override
    protected void setAddSharingSchemeOtherDefaultValue() {
        long defaultSelectOrgId = RequestContext.get().getOrgId();
        List<Long> orgIds = IctmTaxOrgCommonBusiness.getTaxcOrgIdsByIsTaxpayerWithPerm();
        if (!orgIds.contains(defaultSelectOrgId)) {
            defaultSelectOrgId = orgIds.isEmpty() ? 0L : orgIds.get(0);
        }
        int curSelectRowIndex = this.getCurSelectRowIndex();
        this.getModel().setValue(FIELD_CREATE_ORG_SIGN, (Object)defaultSelectOrgId, curSelectRowIndex);
        this.getModel().setValue(CARD_FIELD_CREATE_ORG_SIGN, (Object)((DynamicObject)this.getModel().getValue(FIELD_CREATE_ORG_SIGN, curSelectRowIndex)).getString("name"), curSelectRowIndex);
    }

    @Override
    protected boolean checkSaveDataBeforeSave(DynamicObject curSelectData) {
        QFilter filter = new QFilter("name", "=", (Object)curSelectData.getString("carname"));
        long schemeId = curSelectData.getLong("id");
        if (schemeId != 0L) {
            filter.and("id", "!=", (Object)schemeId);
        }
        if (SharingSchemeBusiness.exists(new QFilter[]{filter}).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SharingSchemePlugin_1", (String)"taxc-ictm", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection ruleCollection = curSelectData.getDynamicObjectCollection("ruleentity");
        Map<String, List<DynamicObject>> ruleMap = ruleCollection.stream().map(rule -> rule.getDynamicObject("rule")).collect(Collectors.groupingBy(p -> this.compositeGroupingByKey((DynamicObject)p)));
        StringJoiner joiner = new StringJoiner("\uff1b");
        for (Map.Entry<String, List<DynamicObject>> ruleEntry2 : ruleMap.entrySet()) {
            if (ruleEntry2.getValue().size() <= 1) continue;
            DynamicObject data = ruleEntry2.getValue().get(0);
            joiner.add(String.format(ResManager.loadKDString((String)"\u9488\u5bf9%1$s\uff1a%2$s\uff0c\u5b58\u5728\u590d\u6570\u89c4\u5219%3$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SharingSchemePlugin_2", (String)"taxc-ictm", (Object[])new Object[0]), data.getDynamicObject("rulepurpose").getString("projectname"), data.getString("bizname"), String.join((CharSequence)",", ruleEntry2.getValue().stream().map(p -> p.getString("number")).collect(Collectors.toList()))));
        }
        if (StringUtils.isNotEmpty((String)joiner.toString())) {
            this.getView().showErrorNotification(joiner.toString());
            return false;
        }
        DynamicObjectCollection orgCollection = curSelectData.getDynamicObjectCollection("orgentity");
        List orgIds = orgCollection.stream().map(p -> p.getDynamicObject("org").getLong("id")).collect(Collectors.toList());
        QFilter orgFilter = new QFilter("orgentity.org.id", "in", orgIds);
        if (schemeId != 0L) {
            orgFilter.and("id", "!=", (Object)schemeId);
        }
        DynamicObject[] schemes = SharingSchemeBusiness.getData(new QFilter[]{orgFilter});
        for (DynamicObject rule2 : ruleCollection) {
            List schemeDataList = Arrays.stream(schemes).filter(scheme -> scheme.getDynamicObjectCollection("ruleentity").stream().anyMatch(ruleEntry -> ruleEntry.getDynamicObject("rule").getDynamicObject("rulepurpose").getString("id").equals(rule2.getDynamicObject("rule").getDynamicObject("rulepurpose").getString("id")) && ruleEntry.getDynamicObject("rule").getString("bizname").equals(rule2.getDynamicObject("rule").getString("bizname")) && ruleEntry.getDynamicObject("rule").getLong("itemname.id") == rule2.getDynamicObject("rule").getLong("itemname.id"))).collect(Collectors.toList());
            for (DynamicObject schemeData : schemeDataList) {
                List orgList = schemeData.getDynamicObjectCollection("orgentity").stream().filter(org -> orgIds.contains(org.getDynamicObject("org").getLong("id"))).collect(Collectors.toList());
                StringJoiner orgJoiner = new StringJoiner(",");
                for (DynamicObject org2 : orgList) {
                    DynamicObject orgObject = org2.getDynamicObject("org");
                    orgJoiner.add(orgObject.getString("number") + "\uff1a" + orgObject.getString("name"));
                }
                Optional<DynamicObject> ruleEntryOptional = schemeData.getDynamicObjectCollection("ruleentity").stream().filter(ruleEntry -> ruleEntry.getDynamicObject("rule").getDynamicObject("rulepurpose").getString("id").equals(rule2.getDynamicObject("rule").getDynamicObject("rulepurpose").getString("id")) && ruleEntry.getDynamicObject("rule").getString("bizname").equals(rule2.getDynamicObject("rule").getString("bizname")) && ruleEntry.getDynamicObject("rule").getLong("itemname.id") == rule2.getDynamicObject("rule").getLong("itemname.id")).findFirst();
                if (!ruleEntryOptional.isPresent()) continue;
                joiner.add(String.format(ResManager.loadKDString((String)"\u9488\u5bf9%1$s\uff1a%2$s\uff0c%3$s\u5df2\u52a0\u5165\u5171\u4eab\u65b9\u6848%4$s\uff1a%5$s\u5e76\u9002\u7528\u5176\u4e2d\u7684\u89c4\u5219%6$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SharingSchemePlugin_3", (String)"taxc-ictm", (Object[])new Object[0]), rule2.getDynamicObject("rule").getDynamicObject("rulepurpose").getString("projectname"), rule2.getDynamicObject("rule").getString("bizname"), orgJoiner, schemeData.getString("number"), schemeData.getString("name"), ruleEntryOptional.get().getDynamicObject("rule").getString("number")));
            }
        }
        if (StringUtils.isNotEmpty((String)joiner.toString())) {
            this.getView().showErrorNotification(joiner.toString());
            return false;
        }
        return true;
    }

    private String compositeGroupingByKey(DynamicObject ruleEntity) {
        StringJoiner joiner = new StringJoiner("#");
        joiner.add(ruleEntity.getString("bizname")).add(ruleEntity.getDynamicObject("rulepurpose").getString("id"));
        if (ObjectUtils.isNotEmpty((Object)ruleEntity.getDynamicObject("itemname"))) {
            joiner.add(ruleEntity.getDynamicObject("itemname").getString("id"));
        }
        return joiner.toString();
    }

    @Override
    protected void setOtherFieldValue(DynamicObject saveSchemeObject, DynamicObject curSelectData) {
        saveSchemeObject.set(FIELD_CREATE_ORG_SIGN, this.getModel().getValue(FIELD_CREATE_ORG_SIGN, this.getCurSelectRowIndex()));
    }

    @Override
    protected void saveDataToDb(DynamicObject saveSchemeObject) {
        OperationResult operationResult = SharingSchemeBusiness.saveData(saveSchemeObject);
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SharingSchemePlugin_4", (String)"taxc-ictm", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        } else {
            StringJoiner errorMsg = new StringJoiner(" ");
            operationResult.getAllErrorOrValidateInfo().forEach(operateInfo -> errorMsg.add(operateInfo.getMessage()));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%1$s\u3002", (String)"SharingSchemePlugin_5", (String)"taxc-ictm", (Object[])new Object[0]), errorMsg));
        }
    }

    @Override
    protected DynamicObject newSharingScheme() {
        return BusinessDataServiceHelper.newDynamicObject((String)"ictm_sharing_scheme");
    }
}

