/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.business;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.CRFormula;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PriceFormulaCalcHelper {
    private static Log logger = LogFactory.getLog(PriceFormulaCalcHelper.class);

    public static BigDecimal calcRelatedFormulaValue(DynamicObject relatedDos) {
        DynamicObject pricerule = (DynamicObject)relatedDos.get("pricerule");
        if (null == pricerule) {
            return null;
        }
        DynamicObject priceFormula = (DynamicObject)pricerule.get("pricejsmethod");
        Long priceFormulaId = priceFormula.getLong("id");
        DynamicObject priceFormulaObject = BusinessDataServiceHelper.loadSingle((Object)priceFormulaId, (String)"ictm_price_jsmethod");
        String formulajson = priceFormulaObject.getString("formulajson");
        String expression = PriceFormulaCalcHelper.getExpressionById(formulajson);
        List<String> fieldList = PriceFormulaCalcHelper.getFieldsByFormulaJson(formulajson);
        HashMap<String, BigDecimal> fieldValuesMap = new HashMap<String, BigDecimal>(fieldList.size());
        for (String field : fieldList) {
            String[] fields = field.split("\\.");
            if (fields.length == 1) {
                fieldValuesMap.put(field, relatedDos.getBigDecimal(field));
                continue;
            }
            if (fields.length == 2) {
                DynamicObjectCollection collection = relatedDos.getDynamicObjectCollection(fields[0]);
                if (collection != null && collection.size() > 0) {
                    fieldValuesMap.put(field, ((DynamicObject)collection.get(0)).getBigDecimal(fields[1]));
                    continue;
                }
                fieldValuesMap.put(field, BigDecimal.ZERO);
                continue;
            }
            fieldValuesMap.put(field, BigDecimal.ZERO);
        }
        if (ObjectUtils.isEmpty(fieldList)) {
            fieldList.add(PriceFormulaCalcHelper.class.getSimpleName());
        }
        return PriceFormulaCalcHelper.getAlgoResults(fieldList, fieldValuesMap, expression);
    }

    private static String getExpressionById(String formulajson) {
        if (null == formulajson) {
            return null;
        }
        CRFormula crFormula = (CRFormula)SerializationUtils.fromJsonString((String)formulajson, CRFormula.class);
        if (null == crFormula || StringUtils.isEmpty((CharSequence)crFormula.getExpression())) {
            logger.warn("formulajson: " + formulajson + "have not set formula.");
            return null;
        }
        return crFormula.getExpression();
    }

    private static List<String> getFieldsByFormulaJson(String formulajson) {
        String express = PriceFormulaCalcHelper.getExpressionById(formulajson);
        if (StringUtils.isEmpty((CharSequence)express)) {
            return new ArrayList<String>();
        }
        String[] fields = FormulaEngine.extractVariables((String)express);
        return new ArrayList<String>(Arrays.asList(fields));
    }

    private static BigDecimal getAlgoResults(List<String> fieldList, Map<String, BigDecimal> fieldValuesMap, String expression) {
        String[] fields = fieldList.toArray(new String[fieldList.size()]);
        DataType[] datatypes = new DataType[fields.length];
        IntStream.range(0, datatypes.length).forEach(i -> {
            datatypes[i] = DataType.BigDecimalType;
        });
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fields, (DataType[])datatypes);
        Object[] value = new Object[fields.length];
        IntStream.range(0, fields.length).forEach(i -> {
            value[i] = fieldValuesMap.get(fields[i]);
        });
        ArrayList<Object[]> coll = new ArrayList<Object[]>(1);
        coll.add(value);
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        DataSet dataSet = Algo.create((String)PriceFormulaCalcHelper.class.getSimpleName()).createDataSet(new Input[]{inputs});
        BigDecimal calcValue = null;
        DataSet data = dataSet.select(expression + " as total");
        for (Row row : data) {
            calcValue = row.getBigDecimal("total");
        }
        data.close();
        return calcValue;
    }
}

