/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.common;

import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TaxOrgCommonEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final String FIELD_ORG_SIGN = "org";

    public void afterCreateNewData(EventObject e) {
        this.setDefaultOrg();
    }

    public void setDefaultOrg() {
        long curUserOrgId = RequestContext.get().getOrgId();
        TaxResult orgIds = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId());
        if (orgIds != null && !ObjectUtils.isEmpty((Object)orgIds.getData())) {
            Long defaultOrgId = curUserOrgId;
            if (!((List)orgIds.getData()).contains(curUserOrgId)) {
                defaultOrgId = (Long)((List)orgIds.getData()).get(0);
            }
            this.getModel().setValue(FIELD_ORG_SIGN, (Object)defaultOrgId);
        }
    }

    private boolean checkFilterValueIsEmpty(ControlFilter filter) {
        if (ObjectUtils.isEmpty((Object)filter.getValue())) {
            return true;
        }
        return filter.getValue().size() == 1 && StringUtil.isEmpty((CharSequence)filter.getValue().get(0).toString());
    }

    public void registerListener(EventObject e) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(FIELD_ORG_SIGN);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)FIELD_ORG_SIGN)) {
            TaxResult curUserOrgIds = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId());
            QFilter qFilter = ObjectUtils.isEmpty((Object)curUserOrgIds) || ((List)curUserOrgIds.getData()).isEmpty() ? new QFilter("id", "=", (Object)-1L) : new QFilter("id", "in", curUserOrgIds.getData());
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getTreeFilterParameter().getQFilters().add(qFilter);
            formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }
}

