/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.common;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;

public class TaxOrgCommonListPlugin
extends AbstractListPlugin {
    public static final String FILTER_ORG_PRE = "org.";
    public static final String CACHE_ORG_ID_KEY = "orgIds";

    public void afterCreateNewData(EventObject e) {
        TaxResult result = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdsByTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId());
        if (!result.isSuccess()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u6709\u6743\u9650\u7684\u7ec4\u7ec7\u63a5\u53e3\u62a5\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxOrgCommonListPlugin_0", (String)"taxc-ictm", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(CACHE_ORG_ID_KEY, SerializationUtils.toJsonString((Object)result.getData()));
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumnList = args.getCommonFilterColumns();
        for (FilterColumn column : filterColumnList) {
            if (!column.getFieldName().startsWith(FILTER_ORG_PRE)) continue;
            CommonFilterColumn typeColumn = (CommonFilterColumn)column;
            typeColumn.setDefaultValue(this.getDefaultOrgId());
            break;
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        this.addOrgFilter(args.getFieldName(), args.getQFilters());
    }

    private void addOrgFilter(String fieldName, List<QFilter> filters) {
        if (fieldName.startsWith(FILTER_ORG_PRE)) {
            List orgIds = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(CACHE_ORG_ID_KEY), Long.class);
            filters.add(new QFilter("id", "in", (Object)orgIds));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        this.addOrgFilter(args.getFieldName(), args.getQfilters());
    }

    private String getDefaultOrgId() {
        long defaultOrgId = RequestContext.get().getOrgId();
        List orgIds = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(CACHE_ORG_ID_KEY), Long.class);
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            return "";
        }
        if (orgIds.contains(defaultOrgId)) {
            return String.valueOf(defaultOrgId);
        }
        return String.valueOf(orgIds.get(0));
    }
}

