/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.contract;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.ictm.common.util.PermissionUtils;
import kd.taxc.ictm.common.util.TreeUtils;
import kd.taxc.ictm.formplugin.ictmenum.IctmTaxpayerenum;

public class RelatedTransactionContractPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit purchasername = (BasedataEdit)this.getControl("purchasercode");
        purchasername.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit sellername = (BasedataEdit)this.getControl("sellercode");
        sellername.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit skcdf = (BasedataEdit)this.getControl("skcdf");
        skcdf.addBeforeF7SelectListener(this::beforeSkcdfSelect);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        formShowParameter.setCustomParam("orgViewSchemeNumber", (Object)"10_taxc");
        formShowParameter.getCustomParams().put("orgFuncId", "947076820862300160");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7", (String)"RelatedTransactionContractPlugin_0", (String)"taxc-ictm", (Object[])new Object[0]));
        List<Long> orgIds = this.getOrgListHasPermission();
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        List<Long> newOrgIds = this.getNewOrgIdsByhanler(orgIds);
        QFilter orgIdsFilter = new QFilter("id", "in", newOrgIds);
        formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
        formShowParameter.setMultiSelect(false);
    }

    private void beforeSkcdfSelect(BeforeF7SelectEvent event) {
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        ArrayList<Long> newOrgIds = new ArrayList<Long>(16);
        newOrgIds.add(((DynamicObject)this.getView().getModel().getValue("purchasercode")).getLong("id"));
        newOrgIds.add(((DynamicObject)this.getView().getModel().getValue("sellercode")).getLong("id"));
        QFilter orgIdsFilter = new QFilter("id", "in", newOrgIds);
        formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
    }

    private List<Long> getNewOrgIdsByhanler(List<Long> orgIds) {
        QFilter orgFileter = new QFilter("orgid", "in", orgIds);
        QFilter istaxpayerFileter = new QFilter("taxorg.istaxpayer", "=", (Object)true);
        QFilter unifiedsocialcodeFileter = new QFilter("taxorg.unifiedsocialcode", "is not null", null);
        DynamicObjectCollection objCollection = QueryServiceHelper.query((String)"tctb_tax_main", (String)"orgid,taxorg.unifiedsocialcode as unifiedsocialcode,accountingstandards.id as accountingstandardsid,taxoffice.id as taxofficeid,registeraddress,registeraddrdetail,taxorg.istaxpayer", (QFilter[])new QFilter[]{orgFileter, unifiedsocialcodeFileter, istaxpayerFileter});
        List<Long> newOrgIds = objCollection.stream().map(o -> o.getLong("orgid")).collect(Collectors.toList());
        return newOrgIds;
    }

    private List<Long> getOrgListHasPermission() {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs(this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission(hasPermOrgs, true);
        if (!CollectionUtils.isEmpty((Collection)col)) {
            for (DynamicObject obj : col) {
                orgIds.add(obj.getLong("id"));
            }
        }
        return orgIds;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("purchasercode".equals(name) || "sellercode".equals(name)) {
            this.displayCorresInformation((DynamicObject)this.getView().getModel().getValue(name), name);
        } else if ("transactioncontent".equals(name)) {
            int rowindex = this.getModel().getEntryRowCount("entryentity");
            for (int i = 0; i <= rowindex - 1; ++i) {
                this.getModel().setValue("trancontent", this.getModel().getValue("transactioncontent"), i);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        if (e.getEntryProp().getName().equals("entryentity") && (rowDataEntities = e.getRowDataEntities()) != null && rowDataEntities.length > 0) {
            int rowIndex = rowDataEntities[0].getRowIndex();
            this.getModel().setValue("trancontent", this.getModel().getValue("transactioncontent"), rowIndex);
        }
    }

    private void displayCorresInformation(DynamicObject dynamicObject, String name) {
        QFilter orgFileter = new QFilter("orgid", "=", (Object)Long.parseLong(dynamicObject.getString("id")));
        DynamicObject obj = QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"taxorg.unifiedsocialcode as unifiedsocialcode,accountingstandards.id as accountingstandardsid,taxoffice.id as taxofficeid,registeraddress,registeraddrdetail", (QFilter[])new QFilter[]{orgFileter});
        this.getView().getModel().setValue(IctmTaxpayerenum.getNameByCode(name), (Object)dynamicObject.getString("name"));
        this.getView().getModel().setValue(IctmTaxpayerenum.getZcshByCode(name), (Object)obj.getString("unifiedsocialcode"));
        this.getView().getModel().setValue(IctmTaxpayerenum.getSykjzcByCode(name), (Object)obj.getString("accountingstandardsid"));
        this.getView().getModel().setValue(IctmTaxpayerenum.getZgswjgByCode(name), (Object)obj.getString("taxofficeid"));
        DynamicObject fullNameDynamicObject = this.getAdmindivision(obj.getLong("registeraddress"));
        String provinceName = null;
        if (fullNameDynamicObject != null) {
            provinceName = fullNameDynamicObject.getString("fullname");
        }
        this.getView().getModel().setValue(IctmTaxpayerenum.getSsgjByCode(name), (Object)provinceName);
        this.getView().getModel().setValue(IctmTaxpayerenum.getZcdzByCode(name), (Object)obj.getString("registeraddrdetail"));
    }

    private DynamicObject getAdmindivision(Long id) {
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        return QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"id, parent, basedatafield, longnumber,country.name as fullname", (QFilter[])new QFilter[]{idFilter});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save || args.getSource() instanceof Submit) {
            Boolean isOpen;
            if (args.getSource() instanceof Submit) {
                Boolean isPass = this.validateDate((Date)this.getView().getModel().getValue("signingdate"), (Date)this.getView().getModel().getValue("startdate"));
                if (!isPass.booleanValue()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7b7e\u8ba2\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u8d77\u59cb\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RelatedTransactionContractPlugin_1", (String)"taxc-ictm", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Boolean isPass1 = this.validateDate((Date)this.getView().getModel().getValue("startdate"), (Date)this.getView().getModel().getValue("enddate"));
                if (!isPass1.booleanValue()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d77\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u622a\u6b62\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RelatedTransactionContractPlugin_2", (String)"taxc-ictm", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            if ((isOpen = (Boolean)this.getModel().getValue("asratio")).booleanValue()) {
                ArrayList<String> feqList = new ArrayList<String>(16);
                DynamicObjectCollection contractDetailsEntity = this.getView().getModel().getEntryEntity("entryentity");
                for (DynamicObject detailsEntity : contractDetailsEntity) {
                    DynamicObjectCollection entryDynamicObjectCollection = detailsEntity.getDynamicObjectCollection("entryentity1");
                    BigDecimal payproportionTolal = entryDynamicObjectCollection.stream().map(s -> s.getBigDecimal("payproportion")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (payproportionTolal.compareTo(new BigDecimal("100.00")) == 0) continue;
                    feqList.add(detailsEntity.getString("seq"));
                }
                if (feqList.size() > 0) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5408\u540c\u660e\u7ec6\u5e8f\u53f7\u4e3a\u3010%s\u3011\u5bf9\u5e94\u7684\u7ed3\u7b97\u8ba1\u5212\u4ed8\u6b3e\u6bd4\u7387\u5408\u8ba1\u9700\u4e3a100%\u3002", (String)"RelatedTransactionContractPlugin_3", (String)"taxc-ictm", (Object[])new Object[0]), String.join((CharSequence)",", feqList)));
                    args.setCancel(true);
                }
            }
        }
    }

    private boolean validateDate(Date start, Date end) {
        return null == start || null == end || !start.after(end);
    }
}

