/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.contract;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.ictm.common.util.DateUtils;
import kd.taxc.ictm.common.util.PermissionUtils;
import kd.taxc.ictm.common.util.TreeUtils;

public class RelatedTransactionContractRptPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(RelatedTransactionContractRptPlugin.class);
    private static final Map<String, String> contractMapping = new HashMap<String, String>();

    public void registerListener(EventObject e) {
        BasedataEdit purchasername = (BasedataEdit)this.getControl("purchaser");
        purchasername.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit sellername = (BasedataEdit)this.getControl("seller");
        sellername.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String id = hyperLinkClickEvent.getRowData().getString("id");
        String contype = hyperLinkClickEvent.getRowData().getString("contype");
        BillShowParameter param = new BillShowParameter();
        param.setFormId(contractMapping.get(contype));
        param.setPageId(id);
        param.setPkId((Object)Long.parseLong(id));
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        List list = event.getColumns();
        for (AbstractReportColumn abstractReportColumn : list) {
            ReportColumn reportColumn;
            String field;
            if (!(abstractReportColumn instanceof ReportColumn) || !"id".equals(field = (reportColumn = (ReportColumn)abstractReportColumn).getFieldKey())) continue;
            reportColumn.setHide(true);
        }
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        List infos = queryParam.getFilter().getFilterItems();
        FilterItemInfo timeStart = new FilterItemInfo();
        timeStart.setPropName("skssq_startdate");
        timeStart.setValue((Object)DateUtils.getFirstDateOfYear(new Date()));
        infos.add(timeStart);
        FilterItemInfo timeEnd = new FilterItemInfo();
        timeEnd.setPropName("skssq_enddate");
        timeEnd.setValue((Object)DateUtils.getLastDateOfMonth2(new Date()));
        infos.add(timeEnd);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        formShowParameter.setCustomParam("orgViewSchemeNumber", (Object)"10_taxc");
        formShowParameter.getCustomParams().put("orgFuncId", "947076820862300160");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7", (String)"RelatedTransactionContractRptPlugin_0", (String)"taxc-ictm", (Object[])new Object[0]));
        List<Long> orgIds = this.getOrgListHasPermission();
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        List<Long> newOrgIds = this.getNewOrgIdsByhanler(orgIds);
        QFilter orgIdsFilter = new QFilter("id", "in", newOrgIds);
        formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
        formShowParameter.setMultiSelect(false);
    }

    private List<Long> getNewOrgIdsByhanler(List<Long> orgIds) {
        QFilter orgFileter = new QFilter("orgid", "in", orgIds);
        QFilter istaxpayerFileter = new QFilter("taxorg.istaxpayer", "=", (Object)true);
        QFilter unifiedsocialcodeFileter = new QFilter("taxorg.unifiedsocialcode", "is not null", null);
        DynamicObjectCollection objCollection = QueryServiceHelper.query((String)"tctb_tax_main", (String)"orgid,taxorg.unifiedsocialcode as unifiedsocialcode,accountingstandards.id as accountingstandardsid,taxoffice.id as taxofficeid,registeraddress,registeraddrdetail,taxorg.istaxpayer", (QFilter[])new QFilter[]{orgFileter, unifiedsocialcodeFileter, istaxpayerFileter});
        List<Long> newOrgIds = objCollection.stream().map(o -> o.getLong("orgid")).collect(Collectors.toList());
        return newOrgIds;
    }

    private List<Long> getOrgListHasPermission() {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission(hasPermOrgs, true);
        if (!CollectionUtils.isEmpty((Collection)col)) {
            for (DynamicObject obj : col) {
                orgIds.add(obj.getLong("id"));
            }
        }
        return orgIds;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        List itemInfos = queryParam.getFilter().getFilterItems();
        List<Long> orgIds = this.getOrgListHasPermission();
        if (CollectionUtils.isEmpty(orgIds)) {
            logger.info("meiyouzuzhi");
            return;
        }
        List<Long> newOrgIds = this.getNewOrgIdsByhanler(orgIds);
        for (FilterItemInfo items : itemInfos) {
            if (!"seller".equals(items.getPropName()) || items.getValue() != null) continue;
            items.setValue(newOrgIds);
        }
    }

    static {
        contractMapping.put("1", "ictm_connect_party_transa");
        contractMapping.put("2", "ictm_connect_transa_sup");
        contractMapping.put("3", "ictm_connect_transa_stop");
    }
}

