/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.contract;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.ictm.common.util.DateUtils;

public class RelatedTransactionContractRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static Log logger = LogFactory.getLog(RelatedTransactionContractRptQueryPlugin.class);
    private static final String[] FIELDS = new String[]{"id", "billno", "contractname", "contracttype1", "contype", "transactioncontent", "signingdate", "purchasername", "sellername", "billstatus"};
    private static final DataType[] DATATYPES = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType};
    private static final List<String> CONTRACTTABLES = Arrays.asList("ictm_connect_party_transa", "ictm_connect_transa_sup", "ictm_connect_transa_stop");
    private static final Map<String, String> FILTER_MAP = new HashMap<String, String>();
    private static RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])DATATYPES);

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        return this.collectDateSet(this.getFilter(filterInfo));
    }

    private DataSet collectDateSet(QFilter[] filter) {
        logger.info("\u8fc7\u6ee4\u6761\u4ef6: " + filter.toString());
        DataSet dataSet = null;
        for (String tableValue : CONTRACTTABLES) {
            DataSet newDateSet = this.queryDataSet(filter, tableValue, FILTER_MAP.get(tableValue));
            if (null == dataSet) {
                dataSet = newDateSet;
                continue;
            }
            dataSet = dataSet.union(newDateSet);
        }
        return dataSet;
    }

    private DataSet queryDataSet(QFilter[] qFilter, String entity, String selectFields) {
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entity, (String)selectFields, (QFilter[])qFilter, null);
    }

    private QFilter[] getFilter(FilterInfo filterInfo) {
        List list = filterInfo.getFilterItems();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        for (FilterItemInfo filter : list) {
            QFilter qFilter;
            if (null == filter || null == filter.getValue() || null == (qFilter = this.getFilterByName(filter))) continue;
            qFilters.add(qFilter);
        }
        return qFilters.toArray(new QFilter[qFilters.size()]);
    }

    private QFilter getFilterByName(FilterItemInfo filterItemInfo) {
        QFilter qFilter = null;
        String name = filterItemInfo.getPropName();
        Object value = filterItemInfo.getValue();
        switch (name) {
            case "purchaser": {
                if (value instanceof DynamicObject) {
                    qFilter = new QFilter("purchasercode", "=", (Object)((DynamicObject)filterItemInfo.getValue()).getLong("id"));
                    break;
                }
                if (!(value instanceof List) || ((List)value).size() == 0) break;
                qFilter = new QFilter("purchasercode", "in", (Object)((List)value).toArray());
                break;
            }
            case "seller": {
                if (value instanceof DynamicObject) {
                    qFilter = new QFilter("sellercode", "=", (Object)((DynamicObject)filterItemInfo.getValue()).getLong("id"));
                    break;
                }
                if (!(value instanceof List) || ((List)value).size() == 0) break;
                qFilter = new QFilter("sellercode", "in", (Object)((List)value).toArray());
                break;
            }
            case "transactioncontents": {
                if (value instanceof DynamicObjectCollection) {
                    List idList = ((DynamicObjectCollection)value).stream().map(s -> s.getLong("id")).collect(Collectors.toList());
                    qFilter = new QFilter("transactioncontent", "in", idList);
                    break;
                }
                if (!(value instanceof List) || ((List)value).size() == 0) break;
                qFilter = new QFilter("transactioncontent", "in", (Object)((List)value).toArray());
                break;
            }
            case "contracttype": {
                qFilter = new QFilter("contracttype", "=", filterItemInfo.getValue());
                break;
            }
            case "skssq_startdate": {
                qFilter = new QFilter("signingdate", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)filterItemInfo.getValue()));
                break;
            }
            case "skssq_enddate": {
                qFilter = new QFilter("signingdate", "<=", (Object)DateUtils.getLastDateOfMonth2((Date)filterItemInfo.getValue()));
                break;
            }
            default: {
                return null;
            }
        }
        return qFilter;
    }

    static {
        FILTER_MAP.put("ictm_connect_party_transa", "id,billno,contractname,contracttype as contracttype1,contype,transactioncontent,signingdate,purchasercode as purchasername,sellercode as sellername,billstatus");
        FILTER_MAP.put("ictm_connect_transa_sup", "id,billno,contractname,contracttype as contracttype1,contype,transactioncontent,signingdate,purchasercode as purchasername,sellercode as sellername,billstatus");
        FILTER_MAP.put("ictm_connect_transa_stop", "id,billno,contractname,contracttype as contracttype1,contype,transactioncontent,signingdate,purchasercode as purchasername,sellercode as sellername,billstatus");
    }
}

