/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.declarationmodel;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportMultiPlugin;
import kd.taxc.ictm.business.taxorg.IctmTaxOrgCommonBusiness;
import kd.taxc.ictm.common.util.DateUtils;
import kd.taxc.ictm.common.util.DeclareOrDraftUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractIctmDeclareReportMultiPlugin
extends AbstractDeclareReportMultiPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(AbstractIctmDeclareReportMultiPlugin.class);
    protected static final String FIELD_ORG_SIGN = "org";
    protected static final String TAXAUTHORITY = "taxauthority";
    protected static final String FIELD_BILL_NO_SIGN = "billno";
    protected String firstNumberPrefix = "RPTF";
    protected String secondNumberPrefix = "WP";

    protected void beforeLoadFromHyperLinkClick(Map<String, Object> customParams) {
        if (customParams.get(TAXAUTHORITY) != null) {
            this.getModel().setValue(TAXAUTHORITY, customParams.get(TAXAUTHORITY));
        } else if (customParams.get("orgid") != null) {
            this.getModel().setValue(TAXAUTHORITY, (Object)DeclareOrDraftUtils.setTaxauthority(customParams.get("orgid").toString()));
        }
    }

    protected void loadFromOtherPage(Map<String, Object> customParams) {
        if (customParams.get(TAXAUTHORITY) != null) {
            this.getModel().setValue(TAXAUTHORITY, customParams.get(TAXAUTHORITY));
        } else if (customParams.get("orgid") != null) {
            this.getModel().setValue(TAXAUTHORITY, (Object)DeclareOrDraftUtils.setTaxauthority(customParams.get("orgid").toString()));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl(FIELD_ORG_SIGN);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter filter = null;
        if (FIELD_ORG_SIGN.equals(name)) {
            List<Long> orgIds = IctmTaxOrgCommonBusiness.getTaxcMainOrgIdByIsTaxpayerWithPerm();
            filter = new QFilter("id", "in", orgIds);
            formShowParameter.getTreeFilterParameter().getQFilters().add(filter);
        }
        formShowParameter.getListFilterParameter().setFilter(filter);
    }

    public String getTaxType() {
        return null;
    }

    public void initPeriod(IDataModel getModel, IPageCache getPageCache, String orgId, Map<String, Object> customParams) {
        getModel.setValue(FIELD_ORG_SIGN, (Object)Long.parseLong(getPageCache.get("orgid")));
        Date lastYearDate = DateUtils.addYear(new Date(), -1);
        getModel.setValue("skssqq", (Object)DateUtils.getFirstDateOfYear(lastYearDate));
        getModel.setValue("skssqz", (Object)DateUtils.getLastDateOfYear(lastYearDate));
        String number = this.createNumber();
        getModel.setValue(FIELD_BILL_NO_SIGN, (Object)number);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.getPageCache().put(FIELD_BILL_NO_SIGN, getModel.getValue(FIELD_BILL_NO_SIGN).toString());
        getPageCache.put("skssqq", format.format(getModel.getValue("skssqq")));
        getPageCache.put("skssqz", format.format(getModel.getValue("skssqz")));
        if (getPageCache.get("orgid") != null) {
            QFilter f = null;
            DynamicObject dyo = YbnsrService.queryMultiDeclareMain((String)MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), (long)Long.parseLong(orgId), (String)this.getTemplateType(), (String)format.format(getModel.getValue("skssqq")), (String)format.format(getModel.getValue("skssqz")), f);
            if (!ObjectUtils.isEmpty((Object)dyo) && !ObjectUtils.isEmpty((Object)dyo.getDynamicObject(TAXAUTHORITY))) {
                Long taxauthority = dyo.getDynamicObject(TAXAUTHORITY).getLong("id");
                this.getModel().setValue(TAXAUTHORITY, (Object)taxauthority);
            } else {
                this.getModel().setValue(TAXAUTHORITY, (Object)DeclareOrDraftUtils.setTaxauthority(orgId));
            }
        }
    }

    protected String createNumber() {
        StringJoiner joiner = new StringJoiner("-");
        joiner.add(this.firstNumberPrefix);
        if (StringUtils.isNotEmpty((CharSequence)this.secondNumberPrefix)) {
            joiner.add(this.secondNumberPrefix);
        }
        if (this.getModel().getValue(FIELD_ORG_SIGN) != null) {
            joiner.add(((DynamicObject)this.getModel().getValue(FIELD_ORG_SIGN)).getString("number"));
        }
        if (this.getModel().getValue("skssqq") != null) {
            joiner.add(String.valueOf(DateUtils.getYear((Date)this.getModel().getValue("skssqq"))));
        }
        return joiner.toString();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String appId = this.getView().getFormShowParameter().getFormConfig().getAppId();
        ChangeData[] changeData = e.getChangeSet();
        if (appId == null || changeData == null || changeData.length == 0) {
            return;
        }
        String name = e.getProperty().getName();
        if (FIELD_ORG_SIGN.equals(name)) {
            this.setPropertyChangedBillNo();
            DynamicObject org = (DynamicObject)this.getModel().getValue(FIELD_ORG_SIGN);
            if (!ObjectUtils.isEmpty((Object)org)) {
                String orgid = org.getString("id");
                this.getModel().setValue(TAXAUTHORITY, (Object)DeclareOrDraftUtils.setTaxauthority(orgid));
            }
        }
        if (FIELD_BILL_NO_SIGN.equals(name)) {
            this.getPageCache().put(FIELD_BILL_NO_SIGN, changeData[0].getNewValue().toString());
            return;
        }
        if ("skssqq".equals(name)) {
            Date startDate = (Date)changeData[0].getNewValue();
            if (startDate == null || startDate.compareTo(DateUtils.getFirstDateOfYear(startDate)) != 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u5fc5\u987b\u4e3a\u516c\u5386\u6574\u5e74\u3002", (String)"AbstractIctmDeclareReportMultiPlugin_0", (String)"taxc-ictm", (Object[])new Object[0]));
                this.getModel().setValue("skssqq", changeData[0].getOldValue());
                return;
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            this.getPageCache().put("skssqq", format.format(startDate));
            DynamicObject org = (DynamicObject)this.getModel().getValue(FIELD_ORG_SIGN);
            if (!ObjectUtils.isEmpty((Object)org)) {
                String orgid = org.getString("id");
                this.getModel().setValue(TAXAUTHORITY, (Object)DeclareOrDraftUtils.setTaxauthority(orgid));
            }
            this.getModel().setValue("skssqz", (Object)DateUtils.getLastDateOfYear(startDate));
            this.setPropertyChangedBillNo();
            return;
        }
        if ("skssqz".equals(name)) {
            Date endDate = (Date)changeData[0].getNewValue();
            if (endDate == null || endDate.compareTo(DateUtils.getLastDateOfYear(endDate)) != 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u5fc5\u987b\u4e3a\u516c\u5386\u6574\u5e74\u3002", (String)"AbstractIctmDeclareReportMultiPlugin_0", (String)"taxc-ictm", (Object[])new Object[0]));
                this.getModel().setValue("skssqz", changeData[0].getOldValue());
                return;
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue(FIELD_ORG_SIGN);
            if (!ObjectUtils.isEmpty((Object)org)) {
                String orgid = org.getString("id");
                this.getModel().setValue(TAXAUTHORITY, (Object)DeclareOrDraftUtils.setTaxauthority(orgid));
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            this.getPageCache().put("skssqz", format.format(endDate));
            this.getModel().setValue("skssqq", (Object)DateUtils.getFirstDateOfYear(endDate));
            this.setPropertyChangedBillNo();
        }
        super.propertyChanged(e);
    }

    protected String[] getTaxLimits() {
        return new String[]{"year"};
    }

    private void setPropertyChangedBillNo() {
        String number = this.createNumber();
        this.getModel().setValue(FIELD_BILL_NO_SIGN, (Object)number);
        this.getPageCache().put(FIELD_BILL_NO_SIGN, number);
    }

    protected Boolean isValidDates(Date startDate, Date endDate, Boolean needMsg) {
        return true;
    }

    protected String getModelNumber() {
        return MultiTableEnum.TSCOO1.getModel();
    }

    protected String getUniKey() {
        logger.info("getUniKey");
        String orgId = this.getPageCache().get("orgid");
        String skssq = DateUtils.format((Date)this.getModel().getValue("skssqq"));
        String skssz = DateUtils.format((Date)this.getModel().getValue("skssqz"));
        return String.format("%s_%s_%s_%s", orgId, skssq, skssz, this.getTemplateType());
    }

    protected Map<String, Object> paraCustomParams(Map<String, Object> customParams) {
        if (customParams.get(FIELD_BILL_NO_SIGN) != null) {
            this.getModel().setValue(FIELD_BILL_NO_SIGN, customParams.get(FIELD_BILL_NO_SIGN));
            this.getPageCache().put(FIELD_BILL_NO_SIGN, customParams.get(FIELD_BILL_NO_SIGN).toString());
        }
        if (customParams.get(TAXAUTHORITY) != null) {
            this.getModel().setValue(TAXAUTHORITY, customParams.get(TAXAUTHORITY));
        } else if (customParams.get("orgid") != null) {
            this.getModel().setValue(TAXAUTHORITY, (Object)DeclareOrDraftUtils.setTaxauthority(customParams.get("orgid").toString()));
        }
        return customParams;
    }

    protected Map<String, String> getBizParams() {
        HashMap<String, String> bizParam = new HashMap<String, String>(1);
        bizParam.put("draftpurpose", "nssb");
        return bizParam;
    }

    protected QFilter getDeclareMainQueryParams() {
        return null;
    }

    protected void viewDraft() {
        String orgId = this.getPageCache().get("orgid");
        QFilter orgFilter = new QFilter(FIELD_ORG_SIGN, "=", (Object)Long.valueOf(orgId));
        String startDate = this.getPageCache().get("skssqq");
        QFilter startDateFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate(startDate));
        String endDate = this.getPageCache().get("skssqz");
        QFilter endDteFilter = new QFilter("skssqz", "=", (Object)DateUtils.stringToDate(endDate));
        String templateType = this.getTemplateType();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)templateType);
        QFilter templateFilter = new QFilter("templatetype", "=", (Object)templateEnum.getDraftType());
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)this.getMainTable(), (String)"templatetype", (QFilter[])new QFilter[]{orgFilter, templateFilter, startDateFilter, endDteFilter});
        if (dynamicObject == null) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("viewdraft", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractIctmDeclareReportMultiPlugin_1", (String)"taxc-ictm", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"AbstractIctmDeclareReportMultiPlugin_2", (String)"taxc-ictm", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            DynamicObject org = (DynamicObject)this.getModel().getValue(FIELD_ORG_SIGN);
            String orgName = org != null ? org.getString("name") : "";
            String msg = String.format(ResManager.loadKDString((String)"%s\u5e74\u5ea6\u5c1a\u672a\u7f16\u5236\u5173\u8054\u7533\u62a5\u5e95\u7a3f\uff0c\u662f\u5426\u524d\u5f80\u7f16\u5236\uff1f", (String)"AbstractIctmDeclareReportMultiPlugin_3", (String)"taxc-ictm", (Object[])new Object[0]), orgName + DateUtils.getYear(DateUtils.stringToDate(startDate)));
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        } else {
            HashMap<String, String> customParams = new HashMap<String, String>(5);
            customParams.put("orgid", orgId);
            customParams.put("skssqq", startDate);
            customParams.put("skssqz", endDate);
            customParams.put("templatetype", templateEnum.getDraftType());
            PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)templateEnum.getDraftPage(), (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }
}

