/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.declare;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.ictm.business.declaredetailhis.DeclareDetailHisBusiness;
import kd.taxc.ictm.business.declarereport.DeclareMainTscBusiness;
import kd.taxc.ictm.business.declarereport.IctmDeclareReportFixCellDataBusiness;
import kd.taxc.ictm.business.membersettle.MemberSettleBusiness;
import kd.taxc.ictm.business.permission.PermissionBusiness;
import kd.taxc.ictm.business.taxorg.IctmTaxOrgCommonBusiness;
import kd.taxc.ictm.common.enums.DeclareReportPermissionEnum;
import kd.taxc.ictm.common.util.DateUtils;
import kd.taxc.ictm.formplugin.declarationmodel.AbstractIctmDeclareReportMultiPlugin;
import org.apache.commons.lang3.StringUtils;

public class IctmDeclareEditMultiPlugin
extends AbstractIctmDeclareReportMultiPlugin {
    private static Log logger = LogFactory.getLog(IctmDeclareEditMultiPlugin.class);
    private static String BTN_VIEW_DRAFT_KEY = "viewdraft";
    private static String BTN_VIEW_LEDGER_KEY = "viewledger";

    public void afterCreateNewData(EventObject e) {
        this.secondNumberPrefix = "";
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_VIEW_DRAFT_KEY, BTN_VIEW_LEDGER_KEY});
    }

    public void init() {
    }

    public String getTemplateType() {
        return "gljysb";
    }

    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
    }

    protected DeclareRequestModel setRequestModel(DeclareRequestModel requestModel) {
        if (StringUtils.isEmpty((CharSequence)this.getModel().getValue("billno").toString())) {
            this.getModel().setValue("billno", (Object)this.createNumber());
        }
        if (requestModel.getRefresh().booleanValue()) {
            Map<String, String> fixCellValueMap = IctmDeclareReportFixCellDataBusiness.getFixCellValueMap(requestModel.getOrgId(), (Date)this.getModel().getValue("skssqq"), (Date)this.getModel().getValue("skssqz"));
            requestModel.getBusinessMap().putAll(fixCellValueMap);
        }
        return requestModel;
    }

    @Override
    protected Map<String, String> getBizParams() {
        HashMap<String, String> bizParam = new HashMap<String, String>(1);
        bizParam.put("draftpurpose", "nssb");
        bizParam.put("datatype", "1");
        return bizParam;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Date skssqz;
        DynamicObject org;
        Boolean checkPermission;
        if (!(args.getSource() instanceof Donothing)) {
            return;
        }
        String operateKey = ((Donothing)args.getSource()).getOperateKey();
        String formId = this.getView().getFormShowParameter().getFormId();
        DeclareReportPermissionEnum declareReportPermissionEnum = DeclareReportPermissionEnum.getDeclareReportPermissionEnum(formId, operateKey);
        if (declareReportPermissionEnum != null && !(checkPermission = PermissionBusiness.checkPermission(RequestContext.get().getCurrUserId(), ((DynamicObject)this.getModel().getValue("org")).getLong("id"), declareReportPermissionEnum.getControlEntityNumber(), declareReportPermissionEnum.getPermItemId())).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IctmDeclareEditMultiPlugin_0", (String)"taxc-ictm", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (operateKey.equals(BTN_VIEW_LEDGER_KEY)) {
            org = (DynamicObject)this.getModel().getValue("org");
            skssqz = (Date)this.getModel().getValue("skssqz");
            if (!IctmTaxOrgCommonBusiness.isHoldingCompany(org.getLong("id"), skssqz).booleanValue()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e8e%2$s\u975e\u6700\u7ec8\u63a7\u80a1\u4f01\u4e1a\u3002", (String)"IctmDeclareEditMultiPlugin_1", (String)"taxc-ictm", (Object[])new Object[0]), org.getString("name"), DateUtils.format(skssqz)));
                args.setCancel(true);
                return;
            }
        }
        if (operateKey.equals("recalc")) {
            org = (DynamicObject)this.getModel().getValue("org");
            skssqz = (Date)this.getModel().getValue("skssqz");
            Date skssqq = (Date)this.getModel().getValue("skssqq");
            DynamicObject declareMainTable = DeclareMainTscBusiness.getDeclareMainTable(org.getLong("id"), skssqq, skssqz, "gljydg");
            Boolean isCanReCalc = declareMainTable != null || IctmTaxOrgCommonBusiness.isHoldingCompany(org.getLong("id"), skssqz) != false && MemberSettleBusiness.orgTaxPeriodExistsData(skssqq, skssqz) != false;
            if (!isCanReCalc.booleanValue()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5e74\u5ea6\u5c1a\u672a\u7f16\u5236\u5173\u8054\u7533\u62a5\u5e95\u7a3f\uff0c\u540c\u65f6\u672a\u7f16\u5236/\u4e0d\u9002\u7528\u6210\u5458\u5b9e\u4f53\u6240\u5f97\u3001\u7a0e\u6536\u548c\u4e1a\u52a1\u6d3b\u52a8\u53f0\u8d26\u3002", (String)"IctmDeclareEditMultiPlugin_2", (String)"taxc-ictm", (Object[])new Object[0]), org.getString("name") + DateUtils.getYear(skssqq)));
                args.setCancel(true);
                return;
            }
        }
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        Boolean dataIsExists = false;
        if (operateKey.equals("cancel")) {
            this.getPageCache().remove("recalc");
        } else if (operateKey.equals("save")) {
            dataIsExists = QueryServiceHelper.exists((String)this.getMainTable(), (QFilter[])new QFilter[]{new QFilter("billno", "=", this.getModel().getValue("billno"))});
        }
        super.afterDoOperation(afterDoOperationEventArgs);
        if (operateKey.equals("save")) {
            if (dataIsExists.booleanValue() && this.getPageCache().get("recalc") == null) {
                return;
            }
            QFilter filter = new QFilter("org", "=", (Object)Long.parseLong(this.getPageCache().get("orgid"))).and("skssqq", "=", this.getModel().getValue("skssqq")).and("skssqz", "=", this.getModel().getValue("skssqz")).and("templatetype", "=", (Object)"gljydg");
            DynamicObject object = BusinessDataServiceHelper.loadSingle((String)this.getMainTable(), (QFilter[])new QFilter[]{filter});
            if (object != null) {
                object.set("sbbid", (Object)this.getPageCache().get("cache_sbbid"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            }
            if (this.getPageCache().get("declareFillValueCache") != null) {
                DeclareDetailHisBusiness.saveDeclareDetailHisData(((DynamicObject)this.getModel().getValue("org")).getLong("id"), (Date)this.getModel().getValue("skssqq"), (Date)this.getModel().getValue("skssqz"), (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("declareFillValueCache"), Map.class));
            }
        }
        if (BTN_VIEW_LEDGER_KEY.equals(operateKey)) {
            this.openLedgerPage();
        }
    }

    private void openLedgerPage() {
        HashMap<String, Object> customParams = new HashMap<String, Object>(2);
        customParams.put("startdate", this.getModel().getValue("skssqq"));
        customParams.put("enddate", this.getModel().getValue("skssqz"));
        PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)"ictm_member_entity_settle", (IFormView)this.getView(), customParams, (IFormPlugin)this);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (callBackId.equals("recalc") && e.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("recalc", "1");
        }
    }

    @Override
    protected String createNumber() {
        this.secondNumberPrefix = "";
        return super.createNumber();
    }
}

