/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.declare;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportMultiQueryListPlugin;
import kd.taxc.ictm.common.util.DeclareOrDraftUtils;
import org.apache.commons.lang3.ObjectUtils;

public class IctmDeclareQueryListPlugin
extends AbstractDeclareReportMultiQueryListPlugin {
    protected static final String TAXAUTHORITY = "taxauthority";

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        this.getView().getFormShowParameter().setCustomParam("querytype", (Object)"gljysb");
        super.afterDoOperation(evt);
        if (evt.getOperateKey().equals("delete")) {
            DynamicObject[] objects;
            Set ids = evt.getOperationResult().getBillNos().keySet();
            for (DynamicObject object : objects = BusinessDataServiceHelper.load((String)"ictm_draft_list", (String)"sbbid", (QFilter[])new QFilter[]{new QFilter("sbbid", "in", ids.stream().map(p -> Long.parseLong(p.toString())).collect(Collectors.toList()))})) {
                object.set("sbbid", null);
            }
            SaveServiceHelper.save((DynamicObject[])objects);
        }
    }

    protected void setExtendCustomParams(Map<String, Object> customParams, DynamicObject object) {
        if (!ObjectUtils.isEmpty((Object)object)) {
            String org = object.getDynamicObject("org").getString("id");
            DynamicObject taxauthority = object.getDynamicObject(TAXAUTHORITY);
            Long taxauthorityid = ObjectUtils.isEmpty((Object)taxauthority) ? DeclareOrDraftUtils.setTaxauthority(org).longValue() : taxauthority.getLong("id");
            customParams.put(TAXAUTHORITY, taxauthorityid);
        }
    }

    public String getModelNumber() {
        return MultiTableEnum.TSCOO1.getModel();
    }

    protected List<String> getTemplateTypeList() {
        return Stream.of("gljysb").collect(Collectors.toList());
    }
}

