/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.draft;

import java.util.Date;
import java.util.Map;
import kd.taxc.bdtaxr.common.declare.initparam.InitParams;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.ictm.common.util.DateUtils;

public class IctmDraftInitParam
implements InitParams {
    private static final String PRE_YEAR_DIMENSION = "qyxtzqk_preyear#qyxtzqk_nd";
    private static final String CUR_YEAR_DIMENSION = "qyxtzqk_curyear#qyxtzqk_nd";
    private static final String YEAR_DAY_SIGN = "nnzyts";

    public Map<String, String> buildBizParam(DeclareRequestModel requestModel) {
        Map paramMap = super.buildBizParam(requestModel);
        Date startDate = DateUtils.stringToDate(requestModel.getSkssqq(), "yyyy-MM-dd");
        Integer year = DateUtils.getYear(startDate);
        paramMap.put(PRE_YEAR_DIMENSION, String.valueOf(year - 1));
        paramMap.put(CUR_YEAR_DIMENSION, String.valueOf(year));
        Date endDate = DateUtils.stringToDate(requestModel.getSkssqz(), "yyyy-MM-dd");
        paramMap.put(YEAR_DAY_SIGN, String.valueOf(DateUtils.getDayDiff(startDate, endDate) + 1));
        return paramMap;
    }
}

