/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.draft;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.Donothing;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportMultiQueryListPlugin;
import kd.taxc.ictm.common.util.DeclareOrDraftUtils;
import org.apache.commons.lang3.ObjectUtils;

public class IctmDraftListPlugin
extends AbstractDeclareReportMultiQueryListPlugin {
    protected static final String TAXAUTHORITY = "taxauthority";

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        this.getView().getFormShowParameter().setCustomParam("querytype", (Object)"gljydg");
        super.afterDoOperation(evt);
    }

    protected void setExtendCustomParams(Map<String, Object> customParams, DynamicObject object) {
        if (!ObjectUtils.isEmpty((Object)object)) {
            String org = object.getDynamicObject("org").getString("id");
            DynamicObject taxauthority = object.getDynamicObject(TAXAUTHORITY);
            Long taxauthorityid = ObjectUtils.isEmpty((Object)taxauthority) ? DeclareOrDraftUtils.setTaxauthority(org).longValue() : taxauthority.getLong("id");
            customParams.put(TAXAUTHORITY, taxauthorityid);
        }
    }

    public String getModelNumber() {
        return MultiTableEnum.TSCOO1.getModel();
    }

    protected List<String> getTemplateTypeList() {
        return Stream.of("gljydg").collect(Collectors.toList());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        if (args.getSource() instanceof Donothing && (operateKey = ((Donothing)args.getSource()).getOperateKey()).equals("createdeclare")) {
            if (args.getListSelectedData().size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u751f\u6210\u7533\u62a5\u8868\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"IctmDraftListPlugin_0", (String)"taxc-ictm", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Object primaryKeyValue = args.getListSelectedData().get(0).getPrimaryKeyValue();
            MultiTableEnum tableEnum = this.getMultiTable();
            DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)tableEnum.getDeclareMainTable());
            QFilter filter = new QFilter("skssqq", "=", data.get("skssqq")).and("skssqz", "=", data.get("skssqz")).and("templatetype", "=", (Object)"gljysb").and("org", "=", (Object)data.getLong("org.id"));
            DynamicObject object = QueryServiceHelper.queryOne((String)tableEnum.getDeclareMainTable(), (String)"billno", (QFilter[])new QFilter[]{filter});
            if (object != null) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6240\u5c5e\u7a0e\u671f\u5df2\u7f16\u5236\u7533\u62a5\u8868\uff1a%s\uff0c\u7981\u6b62\u91cd\u590d\u751f\u6210\u3002", (String)"IctmDraftListPlugin_1", (String)"taxc-ictm", (Object[])new Object[0]), object.getString("billno")));
                args.setCancel(true);
                return;
            }
            TemplateEnum templateEnum = TemplateEnum.getEnumByDraftType((String)"gljydg");
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            customParams.put("orgid", data.get("org.id"));
            customParams.put("skssqq", data.getString("skssqq"));
            customParams.put("skssqz", data.getString("skssqz"));
            customParams.put("templatetype", templateEnum.getDeclareType());
            PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)templateEnum.getDeclarePage(), (IFormView)this.getView(), customParams, (IFormPlugin)this);
            return;
        }
        super.beforeDoOperation(args);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        if (args.getFieldName().equals("sbbid_billno")) {
            Long id = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"ictm_draft_list").getLong("sbbid.id");
            MultiTableEnum tableEnum = this.getMultiTable();
            DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)id, (String)tableEnum.getDeclareMainTable());
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            customParams.put("entryid", data.getString("id"));
            customParams.put("billno", data.getString("billno"));
            customParams.put("orgid", data.getDynamicObject("org").getString("id"));
            customParams.put("orgname", data.getDynamicObject("org").getString("name"));
            Date skssqq = data.getDate("skssqq");
            Date skssqz = data.getDate("skssqz");
            String startDate = DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd");
            customParams.put("skssqq", startDate);
            customParams.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
            customParams.put("readonly", Boolean.TRUE);
            customParams.put("from", "history");
            customParams.put("modifytime", data.getDate("modifytime"));
            String dataType = data.getString("datatype");
            customParams.put("datatype", dataType);
            String type = data.getString("templatetype.number");
            String declarestatus = MultiTableEnum.TSCOO1 == tableEnum ? data.getString("declarestatus") : null;
            this.showDeclarePage(StringUtils.trimToEmpty((String)type), customParams, declarestatus, data);
            return;
        }
        super.billListHyperLinkClick(args);
    }

    private MultiTableEnum getMultiTable() {
        MultiTableEnum tableEnum = MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber());
        if (tableEnum == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4f53\u7cfb\u914d\u7f6e\u6570\u636e\u8868\u3002", (String)"IctmDraftListPlugin_2", (String)"taxc-ictm", (Object[])new Object[0]));
        }
        return tableEnum;
    }
}

