/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.fetchdata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.annotation.GlobalDynamicRowPluginFlag;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import org.apache.commons.lang3.StringUtils;

@GlobalDynamicRowPluginFlag
public class IctmDeclareGBBGDynamicRowListFetchPlugin
extends AbstractDynamicListBasePlugin {
    private static final Map<String, String> FIELD_MAP = new LinkedHashMap<String, String>();

    public List<DynamicRowModel> globalDynrowQuery(BussinessParamsVo bussinessParamsVo) {
        ArrayList<DynamicRowModel> result = new ArrayList<DynamicRowModel>(20);
        QFilter filter = new QFilter("number", "=", (Object)"GJDQ-01");
        DynamicObject bizdef = BusinessDataServiceHelper.loadSingle((String)"tpo_ictm_bizdef", (String)"entryentity,entryentity.id,entryentity.projectname,entryentity.projectfullname", (QFilter[])filter.toArray());
        if (bizdef == null) {
            return result;
        }
        Map<String, String> nameIdMap = bizdef.getDynamicObjectCollection("entryentity").stream().collect(Collectors.toMap(k -> k.getString("projectname"), v -> v.getString("id"), (k1, k2) -> k1));
        Long templateId = (Long)bussinessParamsVo.getExtendParams().get("templateId");
        String g114010Prefix = "gbbgsdsshywhdgbfbb_fetch_item";
        List<Map<String, String>> g114010Maps = this.getGroupMaps(bussinessParamsVo, g114010Prefix, nameIdMap);
        DynamicRowModel g114010RowModel = this.getDynamicRowModel(templateId, g114010Prefix, g114010Maps.size());
        g114010RowModel.setRowList(g114010Maps);
        String g114011Prefix = "gbbgsdsshywhdgbfbb_fetch_yw_item";
        List<Map<String, String>> g114011Maps = this.getGroupMaps(bussinessParamsVo, g114011Prefix, nameIdMap);
        DynamicRowModel g114011RowModel = this.getDynamicRowModel(templateId, g114011Prefix, g114011Maps.size());
        g114011RowModel.setRowList(g114011Maps);
        String g114020Prefix = "gbbgkgqyjtcystmd_fetch_item";
        List<Map<String, String>> g114020Maps = this.getNumberMaps(bussinessParamsVo, g114020Prefix, nameIdMap);
        DynamicRowModel g114020RowModel = this.getDynamicRowModel(templateId, g114020Prefix, g114020Maps.size());
        g114020RowModel.setRowList(g114020Maps);
        String g114021Prefix = "gbbgkgqyjtcystmd_fetch_yw_item";
        List<Map<String, String>> g114021Maps = this.getNumberMaps(bussinessParamsVo, g114021Prefix, nameIdMap);
        DynamicRowModel g114021RowModel = this.getDynamicRowModel(templateId, g114021Prefix, g114021Maps.size());
        g114021RowModel.setRowList(g114021Maps);
        result.add(g114010RowModel);
        result.add(g114011RowModel);
        result.add(g114020RowModel);
        result.add(g114021RowModel);
        return result;
    }

    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        return null;
    }

    private List<Map<String, String>> getGroupMaps(BussinessParamsVo bussinessParamsVo, String clounmName, Map<String, String> nameIdMap) {
        String prefix = clounmName + "#";
        ArrayList<Map<String, String>> rowList = new ArrayList<Map<String, String>>(8);
        Date startDate = bussinessParamsVo.getStartDate();
        Date endDate = bussinessParamsVo.getEndDate();
        QFilter qFilter = new QFilter("initstartdate", "=", (Object)startDate).and("initenddate", "=", (Object)endDate);
        DataSet settleRmb = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ictm_member_settle", (String)"taxjurisdiction,taxjurisdiction.name,registeredcapitalcny,nonrelateincomecny,relateincomecny,allincomecny,relatedinvestmentcny,sqlrhkscny,sjsdscny,jtdqsdscny,retainedearningscny,tangibleassetscny,employeesnum", (QFilter[])qFilter.toArray(), null);
        DataSet taxjurisdictionDataSet = settleRmb.copy().select("taxjurisdiction,taxjurisdiction.name").distinct();
        HashMap<Long, String> taxjurisdictionMap = new HashMap<Long, String>(8);
        for (Row row : taxjurisdictionDataSet) {
            taxjurisdictionMap.put(row.getLong("taxjurisdiction"), row.getString("taxjurisdiction.name"));
        }
        taxjurisdictionDataSet.close();
        DataSet dataSet = settleRmb.copy().groupBy(new String[]{"taxjurisdiction"}).sum("nonrelateincomecny").sum("relateincomecny").sum("allincomecny").sum("relatedinvestmentcny").sum("sqlrhkscny").sum("sjsdscny").sum("jtdqsdscny").sum("retainedearningscny").sum("tangibleassetscny").sum("registeredcapitalcny").sum("employeesnum").finish();
        if (!dataSet.isEmpty()) {
            while (dataSet.hasNext()) {
                String bizDefEntryId;
                HashMap<String, String> rowMap = new HashMap<String, String>(8);
                Row row = dataSet.next();
                Long countryid = row.getLong("taxjurisdiction");
                if (countryid == null || countryid == 0L || StringUtils.isEmpty((CharSequence)(bizDefEntryId = nameIdMap.get(taxjurisdictionMap.get(row.getLong("taxjurisdiction")))))) continue;
                rowMap.put(prefix + "gbbgsdsshywhdgbfbb_gjdq", bizDefEntryId);
                BigDecimal nonrelateincome = row.getBigDecimal("nonrelateincomecny");
                rowMap.put(prefix + "gbbgsdsshywhdgbfbb_fglf", String.valueOf(nonrelateincome));
                BigDecimal relateincome = row.getBigDecimal("relateincomecny");
                rowMap.put(prefix + "gbbgsdsshywhdgbfbb_glf", String.valueOf(relateincome));
                BigDecimal allincome = row.getBigDecimal("allincomecny");
                rowMap.put(prefix + "gbbgsdsshywhdgbfbb_zj", String.valueOf(allincome));
                BigDecimal sqlrhks = row.getBigDecimal("sqlrhkscny");
                rowMap.put(prefix + "gbbgsdsshywhdgbfbb_sqlrks", String.valueOf(sqlrhks));
                BigDecimal sjsds = row.getBigDecimal("sjsdscny");
                rowMap.put(prefix + "gbbgsdsshywhdgbfbb_yjnqysds", String.valueOf(sjsds));
                BigDecimal jtdqsds = row.getBigDecimal("jtdqsdscny");
                rowMap.put(prefix + "gbbgsdsshywhdgbfbb_bndjtdqysds", String.valueOf(jtdqsds));
                BigDecimal registeredcapital = row.getBigDecimal("registeredcapitalcny");
                rowMap.put(prefix + "gbbgsdsshywhdgbfbb_zczb", String.valueOf(registeredcapital));
                BigDecimal retainedearnings = row.getBigDecimal("retainedearningscny");
                rowMap.put(prefix + "gbbgsdsshywhdgbfbb_lcsy", String.valueOf(retainedearnings));
                Integer employeesnum = row.getInteger("employeesnum");
                rowMap.put(prefix + "gbbgsdsshywhdgbfbb_gyrs", String.valueOf(employeesnum));
                BigDecimal tangibleassets = row.getBigDecimal("tangibleassetscny");
                rowMap.put(prefix + "gbbgsdsshywhdgbfbb_yxzc", String.valueOf(tangibleassets));
                rowList.add(rowMap);
            }
        }
        settleRmb.close();
        dataSet.close();
        return rowList;
    }

    private List<Map<String, String>> getNumberMaps(BussinessParamsVo bussinessParamsVo, String clounmName, Map<String, String> nameIdMap) {
        String prefix = clounmName + "#";
        ArrayList<Map<String, String>> rowList = new ArrayList<Map<String, String>>(8);
        Date startDate = bussinessParamsVo.getStartDate();
        Date endDate = bussinessParamsVo.getEndDate();
        QFilter qFilter = new QFilter("initstartdate", "=", (Object)startDate).and("initenddate", "=", (Object)endDate);
        DataSet settleRmb = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ictm_member_settle", (String)"org,taxpayername,taxjurisdiction,taxjurisdiction.name,countryid,countryid.name", (QFilter[])qFilter.toArray(), null);
        DataSet orgDataSet = settleRmb.copy().select("org").distinct();
        HashSet<Long> orgIds = new HashSet<Long>();
        for (Row row : orgDataSet) {
            orgIds.add(row.getLong("org"));
        }
        orgDataSet.close();
        QFilter taxMainFliter = new QFilter("orgid", "in", orgIds).and("taxjurisdiction", "=", (Object)true);
        DynamicObjectCollection tctbTaxMain = QueryServiceHelper.query((String)"tctb_tax_main", (String)"orgid,taxjurisdiction,development,assets,purchase,manufacture,sales,amsservice,labor,internalfinance,financialservice,insure,instrument,nonenterprises,otherbusiness", (QFilter[])taxMainFliter.toArray());
        HashMap orgValueMap = new HashMap(8);
        for (DynamicObject taxMainDyo : tctbTaxMain) {
            long orgid = taxMainDyo.getLong("orgid");
            HashMap<String, String> value = new HashMap<String, String>(8);
            for (Map.Entry<String, String> entry : FIELD_MAP.entrySet()) {
                value.put(entry.getKey(), taxMainDyo.getBoolean(entry.getValue()) ? "1" : "0");
            }
            orgValueMap.put(orgid, value);
        }
        int index = 1;
        if (!settleRmb.isEmpty()) {
            while (settleRmb.hasNext()) {
                HashMap<String, String> rowMap = new HashMap<String, String>(8);
                Row row = settleRmb.next();
                Long orgId = row.getLong("org");
                Long taxjurisdiction = row.getLong("taxjurisdiction");
                Long countryid = row.getLong("countryid");
                if (taxjurisdiction == null || taxjurisdiction == 0L || countryid == null || countryid == 0L) continue;
                String bizDefEntryIdOfCountryId = nameIdMap.get(row.getString("countryid.name"));
                String bizDefEntryIdOfTaxjurisdiction = nameIdMap.get(row.getString("taxjurisdiction.name"));
                if (StringUtils.isEmpty((CharSequence)bizDefEntryIdOfCountryId) || StringUtils.isEmpty((CharSequence)bizDefEntryIdOfTaxjurisdiction)) continue;
                rowMap.put(prefix + "gbbgkgqyjtcystmd_index", String.valueOf(index));
                rowMap.put(prefix + "gbbgkgqyjtcystmd_gjdq", bizDefEntryIdOfTaxjurisdiction);
                rowMap.put(prefix + "gbbgkgqyjtcystmd_ggjdqdcystmc", row.getString("taxpayername"));
                rowMap.put(prefix + "gbbgkgqyjtcystmd_cystzccld", bizDefEntryIdOfCountryId);
                for (Map.Entry<String, String> entry : FIELD_MAP.entrySet()) {
                    String key = prefix + entry.getKey();
                    String value = ((Map)orgValueMap.getOrDefault(orgId, new HashMap(8))).getOrDefault(entry.getKey(), "0");
                    rowMap.put(key, value);
                }
                rowList.add(rowMap);
                ++index;
            }
        }
        settleRmb.close();
        return rowList;
    }

    private DynamicRowModel getDynamicRowModel(Long templateId, String dynRowNo, Integer rowListSize) {
        DynamicRowModel rowModel = new DynamicRowModel();
        rowModel.setTemplateId(templateId);
        rowModel.setDynRowNo(dynRowNo + "#1");
        rowModel.setRowList(new ArrayList(rowListSize));
        return rowModel;
    }

    static {
        FIELD_MAP.put("gbbgkgqyjtcystmd_yf", "development");
        FIELD_MAP.put("gbbgkgqyjtcystmd_cyhglwxzc", "assets");
        FIELD_MAP.put("gbbgkgqyjtcystmd_cg", "purchase");
        FIELD_MAP.put("gbbgkgqyjtcystmd_sczz", "manufacture");
        FIELD_MAP.put("gbbgkgqyjtcystmd_xsscyxhfx", "sales");
        FIELD_MAP.put("gbbgkgqyjtcystmd_xzglhzcfw", "amsservice");
        FIELD_MAP.put("gbbgkgqyjtcystmd_xfglftgnw", "labor");
        FIELD_MAP.put("gbbgkgqyjtcystmd_jtnbrz", "internalfinance");
        FIELD_MAP.put("gbbgkgqyjtcystmd_jrfw", "financialservice");
        FIELD_MAP.put("gbbgkgqyjtcystmd_bx", "insure");
        FIELD_MAP.put("gbbgkgqyjtcystmd_cygfhqtqygj", "instrument");
        FIELD_MAP.put("gbbgkgqyjtcystmd_fyyqy", "nonenterprises");
        FIELD_MAP.put("gbbgkgqyjtcystmd_qt", "otherbusiness");
    }
}

