/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.fetchdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.annotation.GlobalDynamicRowPluginFlag;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.ictm.business.declarereport.DeclareMainTscBusiness;
import kd.taxc.ictm.business.fetchdata.IctmDeclareGlobalDynRowListFetchBusiness;
import kd.taxc.ictm.business.relatedparty.RelatedPartyBusiness;
import kd.taxc.ictm.common.enums.DeclareReportDynRowEnum;

@GlobalDynamicRowPluginFlag
public class IctmDeclareReportGlobalDynamicRowListFetchPlugin
extends AbstractDynamicListBasePlugin {
    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        return null;
    }

    public List<DynamicRowModel> globalDynrowQuery(BussinessParamsVo bussinessParamsVo) {
        Integer n;
        Integer draftRowIndex;
        int i;
        Integer maxRowIndex;
        Optional<Integer> maxRowIndexOptional;
        DynamicObject draftObject = DeclareMainTscBusiness.getDeclareMainTable(Long.parseLong(bussinessParamsVo.getOrgId()), bussinessParamsVo.getStartDate(), bussinessParamsVo.getEndDate(), "gljydg");
        if (draftObject == null) {
            return new ArrayList<DynamicRowModel>(0);
        }
        DynamicObject[] details = DeclareMainTscBusiness.getDeclareDetailTable((Long)draftObject.getLong("id"), new String[0]);
        Map<String, String> cellKeyValueMap = Arrays.stream(details).collect(Collectors.toMap(k -> k.getString("cellnumber"), v -> v.getString("value")));
        String selectFields = "id,name,type,area,idtype,idnumber,legalperson,alonecal,individualrpt,recordingcurrency,registercurrency,registervalue,totalcurrency,totalvalue,paystartdate,payenddate,taxtype,taxdiscount,businessplace,industrycode,islistedcompany,exchange,stockcode,businessscope";
        Map<Long, DynamicObject> relatedPartyMap = Arrays.stream(RelatedPartyBusiness.getAllRelatedParties(selectFields)).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        ArrayList<Map<String, String>> relatedRelationshipDynRowList = new ArrayList<Map<String, String>>(100);
        ArrayList<Map<String, String>> overseasRelatedPartyDynRowList = new ArrayList<Map<String, String>>(100);
        ArrayList<Map<String, String>> incorporatingFundsDynRowList = new ArrayList<Map<String, String>>(100);
        ArrayList<Map<String, String>> financingFundsDynRowList = new ArrayList<Map<String, String>>(100);
        Integer relatedRelationshipDynRowIndex = 1;
        Integer overseasRelatedPartyDynRowIndex = 1;
        Integer incorporatingFundsDynRowIndex = 1;
        Integer financingFundsDynRowIndex = 1;
        ArrayList<Long> relatedRelationshipRelatedPartyIds = new ArrayList<Long>(100);
        ArrayList<Long> overseasRelatedPartyRelatedPartyIds = new ArrayList<Long>(100);
        for (String draftSummaryDynRowDimension : DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getDraftSummaryDynRowDimensions()) {
            maxRowIndexOptional = cellKeyValueMap.keySet().stream().filter(p -> p.startsWith(draftSummaryDynRowDimension) && p.endsWith("qtjymxb_jyf")).map(p -> Integer.parseInt(p.split("#")[1])).sorted((a, b) -> Integer.compare(b, a)).findFirst();
            maxRowIndex = maxRowIndexOptional.isPresent() ? maxRowIndexOptional.get() : Integer.valueOf(0);
            for (i = 0; i < maxRowIndex; ++i) {
                Integer n2;
                draftRowIndex = i + 1;
                String relatedPartIdStr = cellKeyValueMap.get(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(draftSummaryDynRowDimension, draftRowIndex.toString(), "qtjymxb_jyf"));
                if (StringUtils.isEmpty((String)relatedPartIdStr)) continue;
                Long relatedPartyId = Long.parseLong(cellKeyValueMap.get(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(draftSummaryDynRowDimension, draftRowIndex.toString(), "qtjymxb_jyf")));
                DynamicObject relatedParty = relatedPartyMap.get(relatedPartyId);
                if (relatedRelationshipRelatedPartyIds.stream().noneMatch(p -> p.longValue() == relatedPartyId.longValue())) {
                    relatedRelationshipRelatedPartyIds.add(relatedPartyId);
                    relatedRelationshipDynRowList.add(IctmDeclareGlobalDynRowListFetchBusiness.getRelatedRelationshipDynRowMap(relatedParty, relatedRelationshipDynRowIndex.toString(), relatedRelationshipDynRowIndex.toString(), bussinessParamsVo.getStartDate(), bussinessParamsVo.getEndDate()));
                    n = relatedRelationshipDynRowIndex;
                    n2 = relatedRelationshipDynRowIndex = Integer.valueOf(relatedRelationshipDynRowIndex + 1);
                }
                if (!DeclareReportDynRowEnum.OVERSEAS_RELATED_PARTY_DYN_ROW.getDraftSummaryDynRowDimensions().contains(draftSummaryDynRowDimension) || !overseasRelatedPartyRelatedPartyIds.stream().noneMatch(p -> p.longValue() == relatedPartyId.longValue()) || relatedParty.getLong("type.id") == 1899377451617086465L) continue;
                overseasRelatedPartyRelatedPartyIds.add(relatedPartyId);
                overseasRelatedPartyDynRowList.add(IctmDeclareGlobalDynRowListFetchBusiness.getOverseasRelatedPartyDynRowMap(relatedParty, overseasRelatedPartyDynRowIndex.toString(), overseasRelatedPartyDynRowIndex.toString(), bussinessParamsVo.getStartDate()));
                n = overseasRelatedPartyDynRowIndex;
                n2 = overseasRelatedPartyDynRowIndex = Integer.valueOf(overseasRelatedPartyDynRowIndex + 1);
            }
        }
        for (String draftFinancingDynRowDimension : DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getDraftFinancingDynRowDimensions()) {
            maxRowIndexOptional = cellKeyValueMap.keySet().stream().filter(p -> p.startsWith(draftFinancingDynRowDimension) && p.endsWith("glzjrt_jyf")).map(p -> Integer.parseInt(p.split("#")[1])).sorted((a, b) -> Integer.compare(b, a)).findFirst();
            maxRowIndex = maxRowIndexOptional.isPresent() ? maxRowIndexOptional.get() : Integer.valueOf(0);
            for (i = 0; i < maxRowIndex; ++i) {
                Integer n3;
                draftRowIndex = i + 1;
                Long relatedPartyId = Long.parseLong(cellKeyValueMap.get(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(draftFinancingDynRowDimension, draftRowIndex.toString(), "glzjrt_jyf")));
                DynamicObject relatedParty = relatedPartyMap.get(relatedPartyId);
                if (relatedRelationshipRelatedPartyIds.stream().noneMatch(p -> p.longValue() == relatedPartyId.longValue())) {
                    relatedRelationshipRelatedPartyIds.add(relatedPartyId);
                    relatedRelationshipDynRowList.add(IctmDeclareGlobalDynRowListFetchBusiness.getRelatedRelationshipDynRowMap(relatedParty, relatedRelationshipDynRowIndex.toString(), relatedRelationshipDynRowIndex.toString(), bussinessParamsVo.getStartDate(), bussinessParamsVo.getEndDate()));
                    n3 = relatedRelationshipDynRowIndex;
                    n = relatedRelationshipDynRowIndex = Integer.valueOf(relatedRelationshipDynRowIndex + 1);
                }
                if (DeclareReportDynRowEnum.INCORPORATING_FUNDS_DYN_ROW.getDraftFinancingDynRowDimensions().contains(draftFinancingDynRowDimension)) {
                    incorporatingFundsDynRowList.add(IctmDeclareGlobalDynRowListFetchBusiness.getIncorporatingAndReleasingFundDynRowMap(draftFinancingDynRowDimension, DeclareReportDynRowEnum.INCORPORATING_FUNDS_DYN_ROW.getDynRowDimension(), cellKeyValueMap, incorporatingFundsDynRowIndex.toString(), draftRowIndex.toString()));
                    n3 = incorporatingFundsDynRowIndex;
                    n = incorporatingFundsDynRowIndex = Integer.valueOf(incorporatingFundsDynRowIndex + 1);
                }
                if (!DeclareReportDynRowEnum.FINANCING_FUNDS_DYN_ROW.getDraftFinancingDynRowDimensions().contains(draftFinancingDynRowDimension)) continue;
                financingFundsDynRowList.add(IctmDeclareGlobalDynRowListFetchBusiness.getIncorporatingAndReleasingFundDynRowMap(draftFinancingDynRowDimension, DeclareReportDynRowEnum.FINANCING_FUNDS_DYN_ROW.getDynRowDimension(), cellKeyValueMap, financingFundsDynRowIndex.toString(), draftRowIndex.toString()));
                n3 = financingFundsDynRowIndex;
                n = financingFundsDynRowIndex = Integer.valueOf(financingFundsDynRowIndex + 1);
            }
        }
        Long templateId = (Long)bussinessParamsVo.getExtendParams().get("templateid");
        return Stream.of(this.getDynamicRowModel(templateId, DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getDynRowDimension(), relatedRelationshipDynRowList), this.getDynamicRowModel(templateId, DeclareReportDynRowEnum.OVERSEAS_RELATED_PARTY_DYN_ROW.getDynRowDimension(), overseasRelatedPartyDynRowList), this.getDynamicRowModel(templateId, DeclareReportDynRowEnum.INCORPORATING_FUNDS_DYN_ROW.getDynRowDimension(), incorporatingFundsDynRowList), this.getDynamicRowModel(templateId, DeclareReportDynRowEnum.FINANCING_FUNDS_DYN_ROW.getDynRowDimension(), financingFundsDynRowList)).collect(Collectors.toList());
    }

    private DynamicRowModel getDynamicRowModel(Long templateId, String dynRowNo, List<Map<String, String>> rowList) {
        DynamicRowModel rowModel = new DynamicRowModel();
        rowModel.setTemplateId(templateId);
        rowModel.setDynRowNo(dynRowNo + "#1");
        rowModel.setRowList(rowList);
        return rowModel;
    }
}

