/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.fetchdata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchServiceImpl;
import kd.taxc.bdtaxr.common.annotation.GlobalDynamicRowPluginFlag;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.ictm.business.fetchdata.IctmDraftGlobalDynRowListFetchBusiness;
import kd.taxc.ictm.business.relatedparty.RelatedPartyBusiness;
import kd.taxc.ictm.business.rulefetch.RuleEngineDetailDataHandler;
import kd.taxc.ictm.business.rulefetch.impl.DefaultRuleCalculateServiceImpl;
import kd.taxc.ictm.business.rulefetch.impl.DetailRuleEngineServiceImpl;
import kd.taxc.ictm.business.rulefetch.impl.IctmRuleAccessConfigServiceImpl;
import kd.taxc.ictm.common.dto.IctmRuleEnginParamDto;
import kd.taxc.ictm.common.dto.IctmRuleFetchCardDto;
import kd.taxc.ictm.common.dto.IctmRuleFetchCellSummaryDto;
import kd.taxc.ictm.common.dto.IctmRuleFetchDetailDto;
import kd.taxc.ictm.common.dto.OtherTransDetailDto;
import kd.taxc.ictm.common.dto.RelatedFinancingDto;
import kd.taxc.ictm.common.dto.RuleAccessDetailDto;
import kd.taxc.ictm.common.enums.DeclareRuleConfigEnum;
import kd.taxc.ictm.common.enums.DynRowDataTypeEnum;
import kd.taxc.ictm.common.enums.EntryNameEnum;
import org.apache.commons.collections4.CollectionUtils;

@GlobalDynamicRowPluginFlag
public class IctmDraftGlobalDynamicRowListFetchPlugin
extends AbstractDynamicListBasePlugin
implements RuleEngineDetailDataHandler {
    public static final String TEMPLATE_ID = "templateId";
    private Map<String, List<OtherTransDetailDto>> otherTransDetailData = new HashMap<String, List<OtherTransDetailDto>>(12);
    private Map<String, List<RelatedFinancingDto>> relatedFinancingData = new HashMap<String, List<RelatedFinancingDto>>(2);
    private String dynRowDimension;
    private int dataType;
    private DynamicObject[] relatedParties;

    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        return null;
    }

    public List<DynamicRowModel> globalDynrowQuery(BussinessParamsVo bussinessParamsVo) {
        ArrayList<DynamicRowModel> result = new ArrayList<DynamicRowModel>(20);
        DefaultRuleCalculateServiceImpl defaultRuleCalculateService = new DefaultRuleCalculateServiceImpl();
        DetailRuleEngineServiceImpl detailRuleEngineService = new DetailRuleEngineServiceImpl(this);
        IctmRuleAccessConfigServiceImpl defaultRuleAccessConfigService = new IctmRuleAccessConfigServiceImpl("ictm_declare_rule_config", "ictm_sharing_scheme");
        ArrayList<RuleFetchMainDto> allRuleFetchMain = new ArrayList<RuleFetchMainDto>(16);
        for (DeclareRuleConfigEnum value : DeclareRuleConfigEnum.values()) {
            this.dynRowDimension = value.getDynRowDimension();
            this.dataType = value.getDataType();
            for (IctmRuleEnginParamDto ruleEnginParam : value.getRuleEnginParams()) {
                RuleEngineParamDto ruleEnginParamDto = this.getRuleEnginParamDto(bussinessParamsVo, ruleEnginParam);
                List<RuleFetchMainDto> ruleFetchMainList = defaultRuleCalculateService.calculateRuleAccess(ruleEnginParamDto, Stream.of(detailRuleEngineService).collect(Collectors.toList()), defaultRuleAccessConfigService);
                allRuleFetchMain.addAll(ruleFetchMainList);
            }
        }
        RuleFetchMainDto ruleFetchMain = (RuleFetchMainDto)allRuleFetchMain.get(0);
        for (int i = 1; i < allRuleFetchMain.size(); ++i) {
            ruleFetchMain.getRuleFetchCellSummaryList().addAll(((RuleFetchMainDto)allRuleFetchMain.get(i)).getRuleFetchCellSummaryList());
        }
        HashMap<String, BigDecimal> reportItemAmountMap = new HashMap<String, BigDecimal>(ruleFetchMain.getRuleFetchCellSummaryList().size());
        ruleFetchMain.getRuleFetchCellSummaryList().forEach(p -> reportItemAmountMap.put(p.getReportItem(), p.getAmount()));
        Long templateId = (Long)bussinessParamsVo.getExtendParams().get(TEMPLATE_ID);
        HashMap<List<String>, String> reportItemRowColDimensionMap = new HashMap<List<String>, String>(reportItemAmountMap.size());
        for (DeclareRuleConfigEnum ruleConfigEnum : DeclareRuleConfigEnum.values()) {
            if (ruleConfigEnum.getDataType() == DynRowDataTypeEnum.OTHER_TRANS_DETAIL.getDataTypeCode().intValue()) {
                result.add(IctmDraftGlobalDynRowListFetchBusiness.getOtherTransDetailDynRowData(templateId, ruleConfigEnum.getDynRowDimension(), this.otherTransDetailData.get(ruleConfigEnum.getDynRowDimension()), reportItemAmountMap, reportItemRowColDimensionMap));
                continue;
            }
            if (ruleConfigEnum.getDataType() != DynRowDataTypeEnum.RELATED_FINANCING.getDataTypeCode().intValue()) continue;
            result.add(IctmDraftGlobalDynRowListFetchBusiness.getRelatedFinancingDynRowData(templateId, ruleConfigEnum.getDynRowDimension(), this.relatedFinancingData.get(ruleConfigEnum.getDynRowDimension()), reportItemAmountMap, reportItemRowColDimensionMap));
        }
        result.addAll(IctmDraftGlobalDynRowListFetchBusiness.getOtherTransDetailSummaryDynRowData(templateId, this.otherTransDetailData));
        ArrayList<IctmRuleFetchCellSummaryDto> ruleFetchCellSummaryList = new ArrayList<IctmRuleFetchCellSummaryDto>(ruleFetchMain.getRuleFetchCellSummaryList().size());
        for (Map.Entry reportItemRowColDimensionMapEntry : reportItemRowColDimensionMap.entrySet()) {
            List summaryList = ruleFetchMain.getRuleFetchCellSummaryList().stream().filter(p -> ((List)reportItemRowColDimensionMapEntry.getKey()).contains(p.getReportItem())).map(p -> (IctmRuleFetchCellSummaryDto)((Object)p)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(summaryList)) continue;
            IctmRuleFetchCellSummaryDto ruleFetchCellSummaryDto = (IctmRuleFetchCellSummaryDto)((Object)summaryList.get(0));
            for (int i = 1; i < summaryList.size(); ++i) {
                IctmRuleFetchCellSummaryDto summaryDto = (IctmRuleFetchCellSummaryDto)((Object)summaryList.get(i));
                ruleFetchCellSummaryDto.setAmount(ruleFetchCellSummaryDto.getAmount().add(summaryDto.getAmount()));
                ruleFetchCellSummaryDto.setOriginAmount(ruleFetchCellSummaryDto.getOriginAmount().add(summaryDto.getOriginAmount()));
                IctmRuleFetchCardDto cardDto = summaryDto.getIctmRuleFetchCardList().get(0);
                if (ruleFetchCellSummaryDto.getIctmRuleFetchCardList().stream().anyMatch(p -> p.getAccessConfigId().longValue() == cardDto.getAccessConfigId().longValue())) {
                    IctmRuleFetchCardDto ictmRuleFetchCardDto = ruleFetchCellSummaryDto.getIctmRuleFetchCardList().stream().filter(p -> p.getAccessConfigId().longValue() == cardDto.getAccessConfigId().longValue()).findFirst().get();
                    ictmRuleFetchCardDto.setAmount(ictmRuleFetchCardDto.getAmount().add(cardDto.getAmount()));
                    IctmRuleFetchDetailDto detailDto = cardDto.getIctmRuleFetchDetailList().get(0);
                    if (ictmRuleFetchCardDto.getIctmRuleFetchDetailList().stream().anyMatch(p -> p.getDetailId().longValue() == detailDto.getDetailId().longValue())) {
                        IctmRuleFetchDetailDto ictmRuleFetchDetailDto = ictmRuleFetchCardDto.getIctmRuleFetchDetailList().stream().filter(p -> p.getDetailId().longValue() == detailDto.getDetailId().longValue()).findFirst().get();
                        ictmRuleFetchDetailDto.setFetchAmount(ictmRuleFetchDetailDto.getFetchAmount().add(detailDto.getFetchAmount()));
                        ictmRuleFetchDetailDto.setOriginAmount(ictmRuleFetchDetailDto.getOriginAmount().add(detailDto.getOriginAmount()));
                        continue;
                    }
                    ictmRuleFetchCardDto.getIctmRuleFetchDetailList().add(detailDto);
                    ictmRuleFetchCardDto.getRuleFetchDetailList().add(detailDto);
                    continue;
                }
                ruleFetchCellSummaryDto.getIctmRuleFetchCardList().add(cardDto);
                ruleFetchCellSummaryDto.getRuleFetchCardList().add(cardDto);
            }
            ruleFetchCellSummaryDto.setReportItem((String)reportItemRowColDimensionMapEntry.getValue());
            ruleFetchCellSummaryList.add(ruleFetchCellSummaryDto);
        }
        ruleFetchMain.setRuleFetchCellSummaryList(ruleFetchCellSummaryList);
        new RuleFetchServiceImpl().addCellData(ruleFetchMain);
        return result;
    }

    protected RuleEngineParamDto getRuleEnginParamDto(BussinessParamsVo bussinessParamsVo, IctmRuleEnginParamDto ictmDynRuleEnginParamDto) {
        Long orgId = Long.parseLong(bussinessParamsVo.getOrgId());
        Date startDate = bussinessParamsVo.getStartDate();
        Date endDate = bussinessParamsVo.getEndDate();
        Map extendParams = bussinessParamsVo.getExtendParams();
        Long templateId = (Long)extendParams.get(TEMPLATE_ID);
        QFilter accessWhereFilter = new QFilter("rulepurpose.id", "=", (Object)ictmDynRuleEnginParamDto.getRulePurpose()).and("transactiontype.id", "=", (Object)ictmDynRuleEnginParamDto.getTransactionType()).and("transactiondirection", "=", (Object)ictmDynRuleEnginParamDto.getTransactionDirection());
        QFilter sharingPlanWhereFilter = new QFilter("ruleentity.rule.rulepurpose.id", "=", (Object)ictmDynRuleEnginParamDto.getRulePurpose()).and("ruleentity.rule.transactiontype.id", "=", (Object)ictmDynRuleEnginParamDto.getTransactionType()).and("ruleentity.rule.transactiondirection", "=", (Object)ictmDynRuleEnginParamDto.getTransactionDirection()).and("ruleentity.rule.enable", "=", (Object)"1");
        HashMap<String, String> extendRuleParams = new HashMap<String, String>(1);
        extendRuleParams.put("customEvent", extendParams.getOrDefault("customEvent", ""));
        return new RuleEngineParamDto(orgId, DateUtils.getFirstDateOfYear((Date)startDate), endDate, templateId, accessWhereFilter, sharingPlanWhereFilter, extendRuleParams);
    }

    @Override
    public void handleDetailData(List<RuleAccessDetailDto> ruleAccessDetails) {
        block10: {
            List<Object> relatedFinancingList;
            HashMap<String, Object> extendParams;
            block9: {
                List<Object> otherTransDetails;
                if (this.relatedParties == null) {
                    this.relatedParties = RelatedPartyBusiness.getAllRelatedParties();
                }
                extendParams = new HashMap<String, Object>(1);
                extendParams.put("relatedParties", Arrays.stream(this.relatedParties).collect(Collectors.toList()));
                if (this.dataType != DynRowDataTypeEnum.OTHER_TRANS_DETAIL.getDataTypeCode()) break block9;
                if (this.otherTransDetailData.containsKey(this.dynRowDimension)) {
                    otherTransDetails = this.otherTransDetailData.get(this.dynRowDimension);
                } else {
                    otherTransDetails = new ArrayList(16);
                    this.otherTransDetailData.put(this.dynRowDimension, otherTransDetails);
                }
                extendParams.put("existsData", otherTransDetails);
                for (RuleAccessDetailDto ruleAccessDetail : ruleAccessDetails) {
                    List convertResultData;
                    EntryNameEnum entryName = EntryNameEnum.getEnumByEntryName(ruleAccessDetail.getEntityName());
                    if (entryName == null || CollectionUtils.isEmpty(convertResultData = entryName.getDynRowEntityConvert().convertData(ruleAccessDetail, extendParams, this.getReportItemIdKey()))) continue;
                    for (Object convertResultDatum : convertResultData) {
                        otherTransDetails.add((OtherTransDetailDto)convertResultDatum);
                    }
                }
                break block10;
            }
            if (this.dataType != DynRowDataTypeEnum.RELATED_FINANCING.getDataTypeCode()) break block10;
            if (this.relatedFinancingData.containsKey(this.dynRowDimension)) {
                relatedFinancingList = this.relatedFinancingData.get(this.dynRowDimension);
            } else {
                relatedFinancingList = new ArrayList(16);
                this.relatedFinancingData.put(this.dynRowDimension, relatedFinancingList);
            }
            extendParams.put("existsData", relatedFinancingList);
            for (RuleAccessDetailDto ruleAccessDetail : ruleAccessDetails) {
                List convertResultData;
                EntryNameEnum entryName = EntryNameEnum.getEnumByEntryName(ruleAccessDetail.getEntityName());
                if (entryName == null || CollectionUtils.isEmpty(convertResultData = entryName.getDynRowEntityConvert().convertData(ruleAccessDetail, extendParams, this.getReportItemIdKey()))) continue;
                for (Object convertResultDatum : convertResultData) {
                    relatedFinancingList.add((RelatedFinancingDto)convertResultDatum);
                }
            }
        }
    }
}

