/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.fetchdata;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.ictm.business.declarereport.DraftDynCellDataConvertBusiness;
import kd.taxc.ictm.business.fetchdata.IctmDraftGlobalDynRowListFetchBusiness;
import kd.taxc.ictm.common.dto.RelatedFinancingDto;
import kd.taxc.ictm.common.enums.RelatedAndNonRelatedPartyCPPluginCellKeyEnum;
import kd.taxc.ictm.formplugin.fetchdata.AbstractIctmNonRelatedPartyFetchPlugin;

public class IctmRelatedAndNonRelatedTransFetchPlugin
extends AbstractIctmNonRelatedPartyFetchPlugin {
    public String query(Map<String, Object> param) {
        return null;
    }

    public String queryByFormulaVo(Map<String, Object> param, FormulaVo formulaVo) {
        String cellKey = formulaVo.getFormulaKey();
        RelatedAndNonRelatedPartyCPPluginCellKeyEnum cellKeyEnum = RelatedAndNonRelatedPartyCPPluginCellKeyEnum.getEnumByRowColDimension(cellKey);
        List<RelatedFinancingDto> relatedFinancingList = this.getRelatedFinancingList(cellKeyEnum);
        BigDecimal value = BigDecimal.ZERO;
        for (RelatedFinancingDto relatedFinancing : relatedFinancingList) {
            value = value.add(relatedFinancing.getTransAmount());
        }
        return value.toString();
    }

    private List<RelatedFinancingDto> getRelatedFinancingList(RelatedAndNonRelatedPartyCPPluginCellKeyEnum cellKeyEnum) {
        Map<String, String> showData = this.context.getParam().entrySet().stream().collect(Collectors.toMap(k -> (String)k.getKey(), v -> v.getValue().toString()));
        List<RelatedFinancingDto> relatedFinancingList = DraftDynCellDataConvertBusiness.getRelatedFinancingList(showData, cellKeyEnum.getDynRowDimension());
        Map<Long, List<RelatedFinancingDto>> relatedFinancingIdMap = relatedFinancingList.stream().collect(Collectors.groupingBy(p -> p.getId()));
        List questionIds = relatedFinancingIdMap.entrySet().stream().filter(p -> ((List)p.getValue()).size() > 1).map(p -> (Long)p.getKey()).collect(Collectors.toList());
        if (cellKeyEnum.getDomestic().booleanValue()) {
            return relatedFinancingList.stream().filter(p -> !questionIds.contains(p.getId()) && IctmDraftGlobalDynRowListFetchBusiness.domesticCountryIds.contains(p.getCountryId())).collect(Collectors.toList());
        }
        return relatedFinancingList.stream().filter(p -> !questionIds.contains(p.getId()) && !IctmDraftGlobalDynRowListFetchBusiness.domesticCountryIds.contains(p.getCountryId())).collect(Collectors.toList());
    }
}

