/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.party;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.base.BaseView;
import kd.bos.orm.query.QFilter;
import kd.taxc.ictm.business.relatedparty.RelatedPartyBusiness;
import kd.taxc.ictm.common.util.DateUtils;
import kd.taxc.ictm.common.util.EmptyCheckUtils;
import kd.taxc.ictm.formplugin.constant.RelatedPartyConstant;
import kd.taxc.ictm.formplugin.ictmenum.RelatedPartyEnum;

public class RelatedPartyEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String NUMBER = "number";
    private static final String BAR_SAVE = "bar_save";
    private static final String CHECK_FIELD_KEY = "legalperson,alonecal,individualrpt,recordingcurrency,registercurrency,registervalue,totalcurrency,totalvalue,paystartdate,payenddate,taxtype,businessplace,industrycode,businessscope";
    private static final String COMPANY_FIELD_KEY = "exchange,stockcode";
    private static final String BD_CUSTOMER_KEY = "customer";
    private static final String BD_SUPPLIER_KEY = "supplier";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit areaEdit = (BasedataEdit)this.getControl("area");
        areaEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> this.beforeF7Select(beforeF7SelectEvent));
        BasedataEdit idTypeEdit = (BasedataEdit)this.getControl("idtype");
        idTypeEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> this.beforeF7Select(beforeF7SelectEvent));
        BasedataEdit supplier = (BasedataEdit)this.getControl(BD_SUPPLIER_KEY);
        supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit customer = (BasedataEdit)this.getControl(BD_CUSTOMER_KEY);
        customer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject type;
        String key = beforeF7SelectEvent.getProperty().getName();
        if ("area".equals(key) && EmptyCheckUtils.isEmpty(type = (DynamicObject)this.getModel().getValue("type"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u7c7b\u578b\u201d\u3002", (String)"RelatedPartyEdit_0", (String)"taxc-ictm", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(Boolean.TRUE.booleanValue());
        }
        if ("idtype".equals(key)) {
            type = (DynamicObject)this.getModel().getValue("type");
            DynamicObject area = (DynamicObject)this.getModel().getValue("area");
            if (EmptyCheckUtils.isEmpty(type) || EmptyCheckUtils.isEmpty(area)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u7c7b\u578b\u201d\u548c\u201c\u6ce8\u518c\u5730\u201d\u3002", (String)"RelatedPartyEdit_1", (String)"taxc-ictm", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(Boolean.TRUE.booleanValue());
            }
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("parent", "=", (Object)type.getLong("id")));
        }
        if (BD_CUSTOMER_KEY.equals(key) || BD_SUPPLIER_KEY.equals(key)) {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setShowApproved(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            QFilter filter;
            DynamicObject[] relatedParties;
            QFilter filter2;
            DynamicObject[] relatedParties2;
            DynamicObject customer;
            DynamicObject type = (DynamicObject)this.getModel().getValue("type");
            DynamicObject area = (DynamicObject)this.getModel().getValue("area");
            if (EmptyCheckUtils.isNotEmpty(area) && !"2".equals(type.getString(NUMBER)) && !"156".equals(area.getString(NUMBER))) {
                List<String> keyList = Arrays.asList(CHECK_FIELD_KEY.split(","));
                Map<String, String> fieldNameMap = this.getFieldNameMap("ictm_related_party");
                List<String> fieldNameList = this.getEmptyFieldName(keyList, fieldNameMap);
                if (((Boolean)this.getModel().getValue("islistedcompany")).booleanValue()) {
                    List<String> comkeyList = Arrays.asList(COMPANY_FIELD_KEY.split(","));
                    fieldNameList.addAll(this.getEmptyFieldName(comkeyList, fieldNameMap));
                }
                if (fieldNameList.size() > 0) {
                    String msg = String.join((CharSequence)"\u3001", fieldNameList);
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199 %s\u3002", (String)"RelatedPartyEdit_2", (String)"taxc-ictm", (Object[])new Object[0]), msg));
                    args.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
            }
            if ((customer = (DynamicObject)this.getModel().getValue(BD_CUSTOMER_KEY)) != null && (relatedParties2 = RelatedPartyBusiness.getRelatedParties(new QFilter[]{filter2 = new QFilter("id", "!=", this.getModel().getValue("id")).and("customer.id", "=", (Object)customer.getLong("id"))})) != null && relatedParties2.length > 0) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u540c\u4e00\u5ba2\u6237\u5df2\u6620\u5c04\u53e6\u4e00\u5173\u8054\u65b9\uff1a%1$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RelatedPartyEdit_3", (String)"taxc-ictm", (Object[])new Object[0]), relatedParties2[0].getString(NUMBER)));
                args.setCancel(true);
                return;
            }
            DynamicObject supplier = (DynamicObject)this.getModel().getValue(BD_SUPPLIER_KEY);
            if (supplier != null && (relatedParties = RelatedPartyBusiness.getRelatedParties(new QFilter[]{filter = new QFilter("id", "!=", this.getModel().getValue("id")).and("supplier.id", "=", (Object)supplier.getLong("id"))})) != null && relatedParties.length > 0) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u540c\u4e00\u4f9b\u5e94\u5546\u5df2\u6620\u5c04\u53e6\u4e00\u5173\u8054\u65b9\uff1a%1$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RelatedPartyEdit_4", (String)"taxc-ictm", (Object[])new Object[0]), relatedParties[0].getString(NUMBER)));
                args.setCancel(true);
                return;
            }
            if (customer != null && supplier != null && customer.getLong("internal_company.id") != supplier.getLong("internal_company.id")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u5ba2\u6237\u4e0e\u4f9b\u5e94\u5546\u5bf9\u5e94\u7684\u5185\u90e8\u4e1a\u52a1\u5355\u5143\u4e0d\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RelatedPartyEdit_5", (String)"taxc-ictm", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (customer != null && customer.getDynamicObject("internal_company") != null && (relatedParties = RelatedPartyBusiness.getRelatedParties(new QFilter[]{filter = new QFilter("id", "!=", this.getModel().getValue("id")).and("supplier.internal_company.id", "=", (Object)customer.getLong("internal_company.id"))})) != null && relatedParties.length > 0) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u5ba2\u6237\u5bf9\u5e94\u7684\u5185\u90e8\u4e1a\u52a1\u5355\u5143\u4e0e\u53e6\u4e00\u5173\u8054\u65b9\uff1a%1$s\u6620\u5c04\u7684\u4f9b\u5e94\u5546\u5bf9\u5e94\u7684\u5185\u90e8\u4e1a\u52a1\u5355\u5143\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RelatedPartyEdit_6", (String)"taxc-ictm", (Object[])new Object[0]), relatedParties[0].getString(NUMBER)));
                args.setCancel(true);
                return;
            }
            if (supplier != null && supplier.getDynamicObject("internal_company") != null && (relatedParties = RelatedPartyBusiness.getRelatedParties(new QFilter[]{filter = new QFilter("id", "!=", this.getModel().getValue("id")).and("customer.internal_company.id", "=", (Object)supplier.getLong("internal_company.id"))})) != null && relatedParties.length > 0) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u4f9b\u5e94\u5546\u5bf9\u5e94\u7684\u5185\u90e8\u4e1a\u52a1\u5355\u5143\u4e0e\u53e6\u4e00\u5173\u8054\u65b9\uff1a%1$s\u6620\u5c04\u7684\u5ba2\u6237\u5bf9\u5e94\u7684\u5185\u90e8\u4e1a\u52a1\u5355\u5143\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RelatedPartyEdit_7", (String)"taxc-ictm", (Object[])new Object[0]), relatedParties[0].getString(NUMBER)));
                args.setCancel(true);
                return;
            }
        }
        super.beforeDoOperation(args);
    }

    public void afterBindData(EventObject e) {
        BaseView baseView = (BaseView)e.getSource();
        if (OperationStatus.EDIT.equals((Object)baseView.getFormShowParameter().getStatus())) {
            DynamicObject type = (DynamicObject)this.getModel().getValue("type");
            DynamicObject area = (DynamicObject)this.getModel().getValue("area");
            DynamicObject idtype = (DynamicObject)this.getModel().getValue("idtype");
            String areaTextName = this.getTextName("area", type, area, idtype);
            String idNumberTextName = this.getTextName("idnumber", type, area, idtype);
            this.updateMetadataName("area", areaTextName);
            this.updateMetadataName("idnumber", idNumberTextName);
        }
        this.setCustomerAndSupplierVisible();
    }

    private void setCustomerAndSupplierVisible() {
        DynamicObject type = (DynamicObject)this.getModel().getValue("type");
        if (type != null && Stream.of("1", "3").anyMatch(p -> p.equals(type.getString(NUMBER)))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BD_CUSTOMER_KEY, BD_SUPPLIER_KEY});
        } else {
            this.getModel().setValue(BD_CUSTOMER_KEY, null);
            this.getModel().setValue(BD_SUPPLIER_KEY, null);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BD_CUSTOMER_KEY, BD_SUPPLIER_KEY});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date enddate;
        String mmdd;
        Date startdate;
        DynamicObject type;
        ChangeData changeData = e.getChangeSet()[0];
        String key = e.getProperty().getName();
        if ("type".equals(key)) {
            type = (DynamicObject)changeData.getNewValue();
            String areaTextName = this.getTextName("area", type, null, null);
            this.updateMetadataName("area", areaTextName);
            this.getModel().setValue("area", null);
            this.getModel().setValue("idtype", null);
            this.setCustomerAndSupplierVisible();
        }
        if ("area".equals(key)) {
            type = (DynamicObject)this.getModel().getValue("type");
            DynamicObject area = (DynamicObject)changeData.getNewValue();
            String idNumberTextName = this.getTextName("idnumber", type, area, null);
            this.updateMetadataName("idnumber", idNumberTextName);
            Long idTypeValue = null;
            if (EmptyCheckUtils.isNotEmpty(type) && !"2".equals(type.getString(NUMBER)) && EmptyCheckUtils.isNotEmpty(area) && "156".equals(area.getString(NUMBER))) {
                idTypeValue = RelatedPartyConstant.TYPEID_IDTYPE_YYZZ_MAP.get(type.getLong("id"));
            }
            this.getModel().setValue("idtype", idTypeValue);
        }
        if ("idtype".equals(key)) {
            DynamicObject idtype = (DynamicObject)changeData.getNewValue();
            DynamicObject type2 = (DynamicObject)this.getModel().getValue("type");
            DynamicObject area = (DynamicObject)this.getModel().getValue("area");
            String idNumberTextName = this.getTextName("idnumber", type2, area, idtype);
            this.updateMetadataName("idnumber", idNumberTextName);
        }
        if ("paystartdate".equals(key) && (startdate = (Date)changeData.getNewValue()) != null && "0229".equalsIgnoreCase(mmdd = DateUtils.format(startdate, "MMdd"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u5728\u56fd\u7eb3\u7a0e\u5e74\u5ea6\u8d77\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a2\u670829\u65e5\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"RelatedPartyEdit_8", (String)"taxc-ictm", (Object[])new Object[0]));
            this.getModel().setValue("paystartdate", null);
            this.getModel().setValue("payenddate", null);
        }
        if ("payenddate".equals(key) && (enddate = (Date)changeData.getNewValue()) != null && "0229".equalsIgnoreCase(mmdd = DateUtils.format(enddate, "MMdd"))) {
            enddate = DateUtils.addDay(enddate, -1);
            this.getModel().setValue("payenddate", (Object)enddate);
        }
    }

    private String getTextName(String fieldKey, DynamicObject type, DynamicObject area, DynamicObject idtype) {
        switch (fieldKey) {
            case "area": {
                if (EmptyCheckUtils.isNotEmpty(type) && "2".equals(type.getString(NUMBER))) {
                    return RelatedPartyEnum.getNameByCode("156");
                }
                return RelatedPartyEnum.getNameByCode("area");
            }
            case "idnumber": {
                if (idtype != null && "201".equals(idtype.getString(NUMBER))) {
                    return RelatedPartyEnum.getNameByCode("201");
                }
                if (EmptyCheckUtils.isNotEmpty(type) && !"2".equals(type.getString(NUMBER))) {
                    if (area != null && "156".equals(area.getString(NUMBER))) {
                        return RelatedPartyEnum.getNameByCode("unifiedsocialcode");
                    }
                    if (area != null && !"156".equals(area.getString(NUMBER))) {
                        return RelatedPartyEnum.getNameByCode("taxpayernumber");
                    }
                }
                return RelatedPartyEnum.getNameByCode("00");
            }
        }
        return "";
    }

    private void updateMetadataName(String key, String value) {
        HashMap<String, String> arg1 = new HashMap<String, String>();
        arg1.put("zh_CN", value);
        HashMap<String, HashMap<String, String>> map = new HashMap<String, HashMap<String, String>>();
        map.put("caption", arg1);
        this.getView().updateControlMetadata(key, map);
    }

    private List<String> getEmptyFieldName(List<String> keyList, Map<String, String> fieldNameMap) {
        ArrayList<String> fieldNameList = new ArrayList<String>(keyList.size());
        for (String key : keyList) {
            Object obj = this.getModel().getValue(key);
            if (!EmptyCheckUtils.isEmpty(obj) && (!(obj instanceof BigDecimal) || BigDecimal.ZERO.compareTo(new BigDecimal(String.valueOf(obj))) != 0)) continue;
            fieldNameList.add(fieldNameMap.get(key));
        }
        return fieldNameList;
    }

    private Map<String, String> getFieldNameMap(String entityName) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        Map entityMap = entityType.getAllEntities();
        DataEntityPropertyCollection pros = ((EntityType)entityMap.get(entityName)).getProperties();
        Map<String, String> fieldMap = pros.stream().filter(p -> p.getDisplayName() != null).collect(Collectors.toMap(o -> o.getName(), o -> o.getDisplayName().getLocaleValue()));
        return fieldMap;
    }
}

