/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.party;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.ictm.business.admindivision.AdminDivisionBusiness;
import kd.taxc.ictm.business.bizdefinition.BizDefBusiness;
import kd.taxc.ictm.business.currency.CurrencyBusiness;
import kd.taxc.ictm.business.relatedparty.RelatedPartyBusiness;
import kd.taxc.ictm.business.taxorg.IctmTaxOrgCommonBusiness;
import org.apache.commons.lang3.ObjectUtils;

public class RelatedPartyList
extends AbstractListPlugin {
    public void filterColumnSetFilter(SetFilterEvent args) {
        this.addQfilter(args.getFieldName(), args.getQFilters());
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        this.addQfilter(args.getFieldName(), args.getQfilters());
    }

    private void addQfilter(String fieldName, List<QFilter> filters) {
        if (fieldName.startsWith("type")) {
            filters.add(new QFilter("bizdef.number", "=", (Object)"GLFXX-01"));
            filters.add(new QFilter("bizdef.number", "=", (Object)"GLFXX-01").and("parent", "=", (Object)0L));
        } else if (fieldName.startsWith("area")) {
            filters.add(new QFilter("bizdef.number", "=", (Object)"GJDQ-01"));
            List<Long> areaids = this.getAreaList();
            if (areaids != null && areaids.size() > 0) {
                filters.add(new QFilter("id", "in", areaids));
            }
        } else if (fieldName.startsWith("idtype")) {
            filters.add(new QFilter("bizdef.number", "=", (Object)"GLFXX-01").and("parent.number", "in", Stream.of("1", "2", "3").collect(Collectors.toList())));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if ("rapidAdd".equalsIgnoreCase(operateKey)) {
            List<Long> existorgidList;
            HashMap<String, String> customParams = new HashMap<String, String>(8);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ictm_organization_list");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            List<String> relatedPartyNumberList = RelatedPartyBusiness.queryRelatedPartyNumberList();
            if (ObjectUtils.isNotEmpty(relatedPartyNumberList) && ObjectUtils.isNotEmpty(existorgidList = IctmTaxOrgCommonBusiness.getTaxOrgNumberIdList(relatedPartyNumberList))) {
                customParams.put("existorgidList", SerializationUtils.toJsonString(existorgidList));
            }
            formShowParameter.setCustomParams(customParams);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "rapidAdd");
            formShowParameter.setCloseCallBack(callBack);
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if ("rapidAdd".equals(event.getActionId()) && event.getReturnData() != null) {
            String orgids = SerializationUtils.toJsonString((Object)event.getReturnData());
            String orgStr = orgids.replace("]", "").replace("[", "");
            List<String> orgList = Arrays.asList(orgStr.split(","));
            List<Long> neworgList = orgList.stream().map(Long::parseLong).collect(Collectors.toList());
            List<DynamicObject> dynamicObjectList = IctmTaxOrgCommonBusiness.filterIsRegistedAddress(neworgList);
            List<Long> orgIds = dynamicObjectList.stream().map(o -> o.getLong("orgid.id")).collect(Collectors.toList());
            Map<String, Map<String, String>> unifiedsocialcodeMap = IctmTaxOrgCommonBusiness.queryTaxcOrgUnifiedsocialcodeByOrgIds(orgIds, null);
            ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(12);
            for (DynamicObject org : dynamicObjectList) {
                DynamicObject dynamicObject = this.createDynamicObject(org, unifiedsocialcodeMap);
                resultList.add(dynamicObject);
            }
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ictm_related_party", (DynamicObject[])resultList.toArray(new DynamicObject[resultList.size()]), (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                this.getView().showOperationResult(result);
            }
            billList.refresh();
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilterList = e.getQFilters();
        if (qFilterList != null && !"ictm_other_transdetail".equals(this.getView().getParentView().getEntityId())) {
            qFilterList.add(new QFilter("number", "!=", (Object)"FGLF"));
        }
    }

    private List<Long> getAreaList() {
        QFilter filter = new QFilter("area", "!=", (Object)0L);
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"ictm_related_party", (String)"area", (QFilter[])new QFilter[]{filter});
        if (colls != null && colls.size() > 0) {
            List<Long> ids = colls.stream().map(v -> v.getLong("area")).distinct().collect(Collectors.toList());
            return ids;
        }
        return null;
    }

    public DynamicObject createDynamicObject(DynamicObject dynamicObject, Map<String, Map<String, String>> unifiedsocialcodeMap) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"ictm_related_party");
        Map<String, String> orgMap = unifiedsocialcodeMap.get(dynamicObject.getString("orgid.id") + "_" + dynamicObject.getString("taxationsys.id"));
        if (ObjectUtils.isEmpty(orgMap)) {
            return null;
        }
        obj.set("number", (Object)dynamicObject.getString("orgid.number"));
        obj.set("name", (Object)orgMap.get("entry_taxpayer"));
        obj.set("type", (Object)this.getType(dynamicObject.getString("entitytype")));
        obj.set("area", (Object)this.getBusinessplace(dynamicObject.getLong("registeraddress")));
        if ("1".equals(dynamicObject.getString("taxationsys.id"))) {
            obj.set("idtype", (Object)this.getIdtype(dynamicObject.getString("entitytype")));
        }
        obj.set("idnumber", (Object)orgMap.get("entry_unifiedsocialcode"));
        obj.set("customer", (Object)dynamicObject.getLong("acctcustomer.id"));
        obj.set("supplier", (Object)dynamicObject.getLong("acctsupplier.id"));
        obj.set("datasrc", (Object)"ksxz");
        obj.set("enable", (Object)"1");
        obj.set("status", (Object)"C");
        obj.set("creator", (Object)RequestContext.get().getCurrUserId());
        if (!"1".equals(dynamicObject.getString("taxationsys.id"))) {
            obj.set("legalperson", (Object)dynamicObject.getString("legalpeople"));
            obj.set("alonecal", (Object)Boolean.TRUE);
            obj.set("individualrpt", (Object)Boolean.TRUE);
            obj.set("recordingcurrency", (Object)this.getRecordingcurrency(dynamicObject.getLong("taxorg.id")));
            obj.set("registercurrency", (Object)this.getRegistercurrency(dynamicObject.getDynamicObject("registeredcurrency")));
            obj.set("registervalue", (Object)dynamicObject.getBigDecimal("registeredcapital"));
            obj.set("totalcurrency", (Object)this.getRegistercurrency(dynamicObject.getDynamicObject("registeredcurrency")));
            obj.set("totalvalue", (Object)dynamicObject.getBigDecimal("registeredcapital"));
            obj.set("paystartdate", (Object)DateUtils.getFirstDateOfYear((Date)new Date()));
            obj.set("payenddate", (Object)DateUtils.getLastDateOfYear((Date)new Date()));
            obj.set("taxtype", (Object)"Corporate income tax");
            obj.set("businessplace", (Object)this.getBusinessplace(dynamicObject.getLong("actualaddress")));
            obj.set("businessscope", (Object)dynamicObject.getString("businessscop"));
        }
        return obj;
    }

    public Long getRecordingcurrency(Long orgId) {
        Long accountOrgBaseCurrencyId = IctmTaxOrgCommonBusiness.getAccountOrgBaseCurrencyByTaxOrg(orgId, DateUtils.getFirstDateOfYear((Date)new Date()), DateUtils.getLastDateOfYear((Date)new Date()));
        if (ObjectUtils.isNotEmpty((Object)accountOrgBaseCurrencyId)) {
            DynamicObject currencyById = CurrencyBusiness.getCurrencyById(accountOrgBaseCurrencyId);
            DynamicObject standardnumber = BizDefBusiness.getBizDefEntryObject("BZ-01", currencyById.getString("number"), "standardnumber");
            return standardnumber.getLong("id");
        }
        return 0L;
    }

    public DynamicObject getRegistercurrency(DynamicObject obj) {
        if (ObjectUtils.isEmpty((Object)obj)) {
            return null;
        }
        DynamicObject standardnumber = BizDefBusiness.getBizDefEntryObject("BZ-01", obj.getString("number"), "standardnumber");
        if (ObjectUtils.isNotEmpty((Object)standardnumber)) {
            return standardnumber;
        }
        return null;
    }

    public DynamicObject getBusinessplace(Long adminDivisionId) {
        if (ObjectUtils.isEmpty((Object)adminDivisionId)) {
            return null;
        }
        DynamicObject registerAreaAdminDivisionObject = AdminDivisionBusiness.getAdminDivisionById(adminDivisionId);
        DynamicObject countryObject = BizDefBusiness.getBizDefEntryObjectWithProperty("GJDQ-01", registerAreaAdminDivisionObject.getString("country.fullname"), "projectfullname");
        if (ObjectUtils.isNotEmpty((Object)countryObject)) {
            return countryObject;
        }
        return null;
    }

    public DynamicObject getType(String entitytype) {
        DynamicObject standardnumber;
        if (ObjectUtils.isEmpty((Object)entitytype)) {
            return null;
        }
        String value = "";
        if ("legal".equals(entitytype)) {
            value = "1";
        }
        if ("institution".equals(entitytype)) {
            value = "3";
        }
        if (ObjectUtils.isNotEmpty((Object)(standardnumber = BizDefBusiness.getBizDefEntryObjectWithProperty("GLFXX-01", value, "number")))) {
            return standardnumber;
        }
        return null;
    }

    public DynamicObject getIdtype(String entitytype) {
        DynamicObject[] standardnumber;
        if (ObjectUtils.isEmpty((Object)entitytype)) {
            return null;
        }
        String value = "";
        if ("legal".equals(entitytype)) {
            value = "1";
        }
        if ("institution".equals(entitytype)) {
            value = "3";
        }
        if (ObjectUtils.isNotEmpty((Object)(standardnumber = BizDefBusiness.getBizDefEntryCollectObjectWithProperty("GLFXX-01", value, "parent.number")))) {
            for (DynamicObject dynamicObject : standardnumber) {
                if ("legal".equals(entitytype) && "102".equals(dynamicObject.getString("number"))) {
                    return dynamicObject;
                }
                if (!"institution".equals(entitytype) || !"102".equals(dynamicObject.getString("number"))) continue;
                return dynamicObject;
            }
        }
        return null;
    }
}

