/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.party;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.Control;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.taxc.ictm.business.taxorg.IctmTaxOrgCommonBusiness;
import org.apache.commons.lang3.StringUtils;

public class TaxOrgSettleListPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String BILLLISTAP = "billlistap";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addSetFilterListener(this::setBillListFilter);
    }

    public void afterCreateNewData(EventObject e) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addSetFilterListener(this::setBillListFilter);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_OK.equals(key)) {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection collection = billList.getSelectedRows();
            if (collection != null && collection.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u7ec4\u7ec7\u3002", (String)"TaxOrgSettleListPlugin_0", (String)"taxc-ictm", (Object[])new Object[0]));
                return;
            }
            if (collection != null) {
                this.getView().returnDataToParent((Object)collection.getPrimaryKeyValues());
                this.getView().close();
            }
        }
    }

    public void setBillListFilter(SetFilterEvent setFilterEvent) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        List<Long> taxjurisdictionList = IctmTaxOrgCommonBusiness.queryOrgIdListByIsRegistedAddress();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String existorgid = (String)customParams.get("existorgidList");
        if (StringUtils.isNotEmpty((CharSequence)existorgid)) {
            List existorgidList = SerializationUtils.fromJsonStringToList((String)existorgid, Long.class);
            taxjurisdictionList.removeAll(existorgidList);
        }
        QFilter orgIdsFilter = new QFilter("id", "in", taxjurisdictionList);
        billList.getFilterParameter().getQFilters().add(orgIdsFilter);
        setFilterEvent.addCustomQFilter(orgIdsFilter);
    }
}

