/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.priceadjust;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.listop.ImportData;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.ictm.common.util.PermissionUtils;
import kd.taxc.ictm.common.util.TreeUtils;
import kd.taxc.ictm.formplugin.ictmenum.IctmTaxpayerenum;
import kd.taxc.ictm.formplugin.settle.LaborServiceSettleListPlugin;

public class RelatedPriceAdjustPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(RelatedPriceAdjustPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit purchasername = (BasedataEdit)this.getControl("purchasercode");
        purchasername.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit sellername = (BasedataEdit)this.getControl("sellercode");
        sellername.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        this.priceTypeAdvconap();
    }

    public void afterBindData(EventObject e) {
        this.priceTypeAdvconap();
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("importdata".equals(itemKey)) {
            this.getView().invokeOperation("save");
            this.importData();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        formShowParameter.setCustomParam("orgViewSchemeNumber", (Object)"10_taxc");
        formShowParameter.getCustomParams().put("orgFuncId", "947076820862300160");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7", (String)"RelatedPriceAdjustPlugin_0", (String)"taxc-ictm", (Object[])new Object[0]));
        List<Long> orgIds = this.getOrgListHasPermission();
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        List<Long> newOrgIds = this.getNewOrgIdsByhanler(orgIds);
        QFilter orgIdsFilter = new QFilter("id", "in", newOrgIds);
        formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
        formShowParameter.setMultiSelect(false);
    }

    private List<Long> getNewOrgIdsByhanler(List<Long> orgIds) {
        QFilter orgFileter = new QFilter("orgid", "in", orgIds);
        QFilter istaxpayerFileter = new QFilter("taxorg.istaxpayer", "=", (Object)true);
        QFilter unifiedsocialcodeFileter = new QFilter("taxorg.unifiedsocialcode", "is not null", null);
        DynamicObjectCollection objCollection = QueryServiceHelper.query((String)"tctb_tax_main", (String)"orgid,taxorg.unifiedsocialcode as unifiedsocialcode,accountingstandards.id as accountingstandardsid,taxoffice.id as taxofficeid,registeraddress,registeraddrdetail,taxorg.istaxpayer", (QFilter[])new QFilter[]{orgFileter, unifiedsocialcodeFileter, istaxpayerFileter});
        List<Long> newOrgIds = objCollection.stream().map(o -> o.getLong("orgid")).collect(Collectors.toList());
        return newOrgIds;
    }

    private List<Long> getOrgListHasPermission() {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs(this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission(hasPermOrgs, true);
        if (!CollectionUtils.isEmpty((Collection)col)) {
            for (DynamicObject obj : col) {
                orgIds.add(obj.getLong("id"));
            }
        }
        return orgIds;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("purchasercode".equals(name) || "sellercode".equals(name)) {
            this.displayCorresInformation((DynamicObject)this.getView().getModel().getValue(name), name);
        } else if ("pricetztype".equals(name)) {
            this.priceTypeAdvconap();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
    }

    private void displayCorresInformation(DynamicObject dynamicObject, String name) {
        QFilter orgFileter = new QFilter("orgid", "=", (Object)Long.parseLong(dynamicObject.getString("id")));
        DynamicObject obj = QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"taxorg.unifiedsocialcode as unifiedsocialcode,accountingstandards.id as accountingstandardsid,taxoffice.id as taxofficeid,registeraddress,registeraddrdetail", (QFilter[])new QFilter[]{orgFileter});
        this.getView().getModel().setValue(IctmTaxpayerenum.getNameByCode(name), (Object)dynamicObject.getString("name"));
        this.getView().getModel().setValue(IctmTaxpayerenum.getZcshByCode(name), (Object)obj.getString("unifiedsocialcode"));
        this.getView().getModel().setValue(IctmTaxpayerenum.getSykjzcByCode(name), (Object)obj.getString("accountingstandardsid"));
        this.getView().getModel().setValue(IctmTaxpayerenum.getZgswjgByCode(name), (Object)obj.getString("taxofficeid"));
        DynamicObject fullNameDynamicObject = this.getAdmindivision(obj.getLong("registeraddress"));
        String provinceName = null;
        if (fullNameDynamicObject != null) {
            provinceName = fullNameDynamicObject.getString("fullname");
        }
        this.getView().getModel().setValue(IctmTaxpayerenum.getSsgjByCode(name), (Object)provinceName);
        this.getView().getModel().setValue(IctmTaxpayerenum.getZcdzByCode(name), (Object)obj.getString("registeraddrdetail"));
    }

    private DynamicObject getAdmindivision(Long id) {
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        return QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"id, parent, basedatafield, longnumber,country.name as fullname", (QFilter[])new QFilter[]{idFilter});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof ImportData) {
            this.getView().invokeOperation("save");
        }
    }

    private void importData() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_importstart");
        showParameter.setCustomParam("BillFormId", (Object)"ictm_connect_price");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        ArrayList plugins = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Enabled", Boolean.TRUE);
        map.put("ClassName", LaborServiceSettleListPlugin.class.getName());
        plugins.add(map);
        showParameter.setCustomParam("plugins", plugins);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeimport"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if ("closeimport".equals(evt.getActionId())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("refresh".equals(afterDoOperationEventArgs.getOperateKey())) {
            // empty if block
        }
    }

    private void priceTypeAdvconap() {
        String pricetzType = (String)this.getModel().getValue("pricetztype");
        if (StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)pricetzType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"attachmentpanel"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"attachmentpanel"});
        }
    }
}

