/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.pricejsmethod;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.ictm.common.util.EntityMetadataUtils;

public class PriceCalculateMethodEdit
extends AbstractBillPlugIn {
    private static final String FIELD_FORMULA = "formula";
    private static final String FIELD_FORMULAJSON = "formulajson";
    private static final String FIELD_CALLBILL = "callbill";
    private static final String FIELD_CREATEORG = "createorg";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{FIELD_FORMULA});
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue(FIELD_CREATEORG, (Object)RequestContext.get().getOrgId());
    }

    public void click(EventObject evt) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("ictm_formula_set");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "formulaSet");
        formshowParameter.setCloseCallBack(closeCallBack);
        DynamicObject bill = (DynamicObject)this.getModel().getValue(FIELD_CALLBILL);
        if (null != bill) {
            TreeNode treeNode = EntityMetadataUtils.buildFieldTreeNode(bill.getString("number"), bill.getString("name"), new DecimalProp());
            formshowParameter.setCustomParam("treenodes", (Object)SerializationUtils.toJsonString((Object)treeNode));
        }
        formshowParameter.setCustomParam(FIELD_FORMULA, this.getModel().getValue(FIELD_FORMULAJSON));
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String formulaJson = (String)closedCallBackEvent.getReturnData();
        CRFormula formulaObj = this.deserialize(formulaJson);
        if (null != formulaJson && formulaObj != null && "formulaSet".equals(closedCallBackEvent.getActionId())) {
            this.getModel().setValue(FIELD_FORMULAJSON, (Object)formulaJson);
            this.getModel().setValue(FIELD_FORMULA, (Object)formulaObj.getExprTran());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtils.equalsIgnoreCase((CharSequence)e.getProperty().getName(), (CharSequence)FIELD_CALLBILL)) {
            this.getModel().setValue(FIELD_FORMULA, null);
            this.getModel().setValue(FIELD_FORMULAJSON, null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            QFilter idQ = new QFilter("id", "!=", dynamicObject.getPkValue());
            QFilter callbillQ = new QFilter(FIELD_CALLBILL, "=", dynamicObject.getDynamicObject(FIELD_CALLBILL).getPkValue());
            QFilter formulaQ = new QFilter(FIELD_FORMULA, "=", dynamicObject.get(FIELD_FORMULA));
            if (QueryServiceHelper.exists((String)"ictm_price_jsmethod", (QFilter[])new QFilter[]{idQ, callbillQ, formulaQ})) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u4e00\u8c03\u7528\u5355\u636e\u8ba1\u7b97\u516c\u5f0f\u4e0d\u80fd\u91cd\u590d\u3002", (String)"PriceCalculateMethodEdit_0", (String)"taxc-ictm", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private CRFormula deserialize(String json) {
        CRFormula formulaObj = null;
        formulaObj = StringUtils.isBlank((CharSequence)json) ? new CRFormula() : (CRFormula)SerializationUtils.fromJsonString((String)json, CRFormula.class);
        return formulaObj;
    }
}

