/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.OrgFuncEnum;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.ictm.formplugin.settle.SettleFacility;

public class MemberEntitySettleDetailPlugin
extends AbstractBillPlugIn {
    public void afterLoadData(EventObject e) {
        Long id = (Long)this.getModel().getDataEntity().get("id");
        DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ictm_member_settle");
        if (dyo != null) {
            if ("gzqs".equalsIgnoreCase(dyo.getString("datagenermethod"))) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"nonrelateincome", "relateincome", "allincome", "relatedinvestment", "sqlrhks", "sjsds", "jtdqsds", "retainedearnings", "tangibleassets", "employeesnum"});
            }
            this.getView().setVisible(Boolean.valueOf(this.getOrgListHasPermissionAll().contains(dyo.getLong("org.id"))), new String[]{"remark", "startdate", "enddate"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equalsIgnoreCase(operateKey)) {
            Date startDate = this.getModel().getDataEntity().getDate("startdate");
            Date endDate = this.getModel().getDataEntity().getDate("enddate");
            Date startDateOfParent = this.getView().getParentView().getParentView().getModel().getDataEntity().getDate("startdate");
            Date endDateOfParent = this.getView().getParentView().getParentView().getModel().getDataEntity().getDate("enddate");
            if (startDate == null || endDate == null || startDateOfParent == null || endDateOfParent == null) {
                return;
            }
            if (startDateOfParent.compareTo(endDate) > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u6db5\u76d6\u671f\u95f4\u6b62\u4f4d\u4e8e\u96c6\u56e2\u4f1a\u8ba1\u5e74\u5ea6\u5f00\u59cb\u65f6\u95f4\u524d\u3002", (String)"MemberEntitySettleDetailPlugin_0", (String)"taxc-ictm", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (startDate.compareTo(endDateOfParent) > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u6db5\u76d6\u671f\u95f4\u8d77\u4f4d\u4e8e\u96c6\u56e2\u4f1a\u8ba1\u5e74\u5ea6\u7ed3\u675f\u65f6\u95f4\u540e\u3002", (String)"MemberEntitySettleDetailPlugin_1", (String)"taxc-ictm", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (startDate.compareTo(endDate) > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u6db5\u76d6\u671f\u95f4\u6b62\u4f4d\u4e8e\u6570\u636e\u6db5\u76d6\u671f\u95f4\u8d77\u524d\u3002", (String)"MemberEntitySettleDetailPlugin_2", (String)"taxc-ictm", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if ("relateincome".equalsIgnoreCase(name) || "allincome".equalsIgnoreCase(name)) {
            if (changeData[0].getNewValue() == null) {
                return;
            }
            BigDecimal relateincome = this.getModel().getDataEntity().getBigDecimal("relateincome");
            if (relateincome == null) {
                return;
            }
            BigDecimal allincome = this.getModel().getDataEntity().getBigDecimal("allincome");
            if (allincome == null) {
                return;
            }
            this.getModel().getDataEntity().set("nonrelateincome", (Object)allincome.subtract(relateincome));
            this.getView().updateView("nonrelateincome");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        if (evt.getOperationResult().getSuccessPkIds().isEmpty()) {
            return;
        }
        String operateKey = evt.getOperateKey();
        if ("save".equalsIgnoreCase(operateKey)) {
            long orgId = this.getModel().getDataEntity().getLong("org.id");
            ArrayList<Long> orgIds = new ArrayList<Long>(8);
            orgIds.add(orgId);
            long id = this.getModel().getDataEntity().getLong("id");
            DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ictm_member_settle");
            Map exchangeMap = SystemParamUtil.getAppParameterBatch((String)"ictm", (String)"exchange", orgIds);
            SettleFacility.setCnyField(exchangeMap, orgId, dyo);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyo});
        }
    }

    private List<Long> getOrgListHasPermissionAll() {
        TaxResult listTaxResult = TaxcCombineDataServiceHelper.queryOrgIdByViewWithPerm((Long)RequestContext.get().getCurrUserId(), (String)OrgFuncEnum.TAX.getNumber(), (boolean)true);
        if (listTaxResult.isSuccess() && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData()))) {
            return (List)listTaxResult.getData();
        }
        return new ArrayList<Long>(8);
    }
}

