/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.settle;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchServiceImpl;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.utils.metadata.MetadataUtil;
import kd.taxc.ictm.business.taxmain.IctmTaxMainCommonBusiness;
import kd.taxc.ictm.business.taxorg.IctmTaxOrgCommonBusiness;
import kd.taxc.ictm.common.constant.IctmEntityConstant;
import kd.taxc.ictm.common.enums.MemberEntityItemNameEnum;
import kd.taxc.ictm.formplugin.settle.SettleFacility;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MemberEntitySettleListPlugin
extends AbstractListPlugin {
    private static final String ADDNEW = "addnew";
    private static final String BILLLISTAP = "billlistap";
    private static final String DELETE = "delete";
    private static final String RMB = "rmb";
    private static final String SGLR = "sglr";

    public void initialize() {
        BillList billlist = (BillList)this.getControl(BILLLISTAP);
        billlist.addPackageDataListener(this::packageData);
        Toolbar toolbarMain = (Toolbar)this.getControl("toolbarap");
        toolbarMain.addItemClickListener((ItemClickListener)this);
    }

    public void setFilter(SetFilterEvent e) {
        Date startDate = (Date)this.getArg("startdate");
        Date endDate = (Date)this.getArg("enddate");
        QFilter filter = SettleFacility.getDateFilter(startDate, endDate);
        Long holdingCompanyOrgId = IctmTaxOrgCommonBusiness.getHoldingCompanyOrgId(endDate);
        List<Long> ids = SettleFacility.getOrgListHasPermissionAll();
        if (CollectionUtils.isEmpty(ids) || !ids.contains(holdingCompanyOrgId)) {
            filter.and("org", "in", ids);
        }
        e.addCustomQFilter(filter);
    }

    public void afterBindData(EventObject e) {
        String currency = (String)this.getView().getParentView().getModel().getValue("currency");
        this.getView().setVisible(Boolean.valueOf("bwb".equalsIgnoreCase(currency)), IctmEntityConstant.SETTLE_NUM_FILEDS.toArray(new String[0]));
        this.getView().setVisible(Boolean.valueOf(!"bwb".equalsIgnoreCase(currency)), (String[])IctmEntityConstant.SETTLE_NUM_FILEDS.stream().map(m -> m.concat("cny")).toArray(String[]::new));
        this.getView().setVisible(Boolean.valueOf(!RMB.equalsIgnoreCase(currency)), new String[]{"currency.name", "currency", "currency_name"});
        Date endDate = (Date)this.getView().getParentView().getModel().getValue("enddate");
        Long holdingCompanyOrgId = IctmTaxOrgCommonBusiness.getHoldingCompanyOrgId(endDate);
        List<Long> ids = SettleFacility.getOrgListHasPermissionAll();
        this.getView().setVisible(Boolean.valueOf(ids.contains(holdingCompanyOrgId)), new String[]{DELETE, ADDNEW, "tbldel"});
        Date startDate = (Date)this.getArg("startdate");
        QFilter timeFilter = SettleFacility.getDateFilter(startDate, endDate);
        boolean exists = QueryServiceHelper.exists((String)"ictm_member_settle", (QFilter[])timeFilter.toArray());
        this.getView().setVisible(Boolean.valueOf(exists), new String[]{"resetdata", "retrievedata", "changemethod"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection collection = billList.getSelectedRows();
        String currency = (String)this.getView().getParentView().getModel().getValue("currency");
        if (StringUtils.equalsIgnoreCase((CharSequence)evt.getItemKey(), (CharSequence)"changemethod")) {
            List collect = collection.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                return;
            }
            QFilter filter = new QFilter("id", "in", collect);
            DynamicObjectCollection dyoList = QueryServiceHelper.query((String)"ictm_member_settle", (String)"id,org,datagenermethod", (QFilter[])filter.toArray());
            List datagenermethod = dyoList.stream().map(m -> m.getString("datagenermethod")).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(datagenermethod) && datagenermethod.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u591a\u9009\u65f6\u4ec5\u6570\u636e\u751f\u6210\u65b9\u5f0f\u76f8\u540c\u60c5\u51b5\u4e0b\u53ef\u6279\u91cf\u53d8\u66f4\uff0c\u5f53\u524d\u6570\u636e\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"MemberEntitySettleListPlugin_0", (String)"taxc-ictm", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (RMB.equalsIgnoreCase(currency)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u672c\u4f4d\u5e01\u6761\u4ef6\u4e0b\u64cd\u4f5c\u3002", (String)"MemberEntitySettleListPlugin_1", (String)"taxc-ictm", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            this.checkExchangeMap(evt, dyoList);
        } else if ("tbldel".equalsIgnoreCase(evt.getItemKey())) {
            List collect = collection.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                return;
            }
            if (RMB.equalsIgnoreCase(currency)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u672c\u4f4d\u5e01\u6761\u4ef6\u4e0b\u64cd\u4f5c\u3002", (String)"MemberEntitySettleListPlugin_1", (String)"taxc-ictm", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if ("resetdata".equalsIgnoreCase(evt.getItemKey())) {
            this.checkResetdataCilck(evt);
        } else if ("retrievedata".equalsIgnoreCase(evt.getItemKey())) {
            this.checkRetrievedata(evt);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey = evt.getOperateKey();
        Date startDate = (Date)this.getArg("startdate");
        Date endDate = (Date)this.getArg("enddate");
        if (ADDNEW.equalsIgnoreCase(operateKey)) {
            DynamicObjectCollection allDataByPriod = QueryServiceHelper.query((String)"ictm_member_settle", (String)"id,org,datagenermethod", (QFilter[])SettleFacility.getDateFilter(startDate, endDate).toArray());
            List orgIds = allDataByPriod.stream().map(m -> m.getLong("org")).distinct().collect(Collectors.toList());
            HashMap<String, String> customParams = new HashMap<String, String>(8);
            if (CollectionUtils.isNotEmpty(orgIds)) {
                customParams.put("existorgidList", SerializationUtils.toJsonString(orgIds));
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ictm_organization_window");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParams(customParams);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, ADDNEW);
            formShowParameter.setCloseCallBack(callBack);
            this.getView().showForm(formShowParameter);
        } else if ("changemethod".equalsIgnoreCase(operateKey)) {
            this.changeMethod();
        } else if (DELETE.equalsIgnoreCase(operateKey) && evt.getOperationResult().isSuccess()) {
            this.recalInterValue(startDate, endDate);
        }
    }

    private void recalInterValue(Date startDate, Date endDate) {
        DynamicObjectCollection dyoList = QueryServiceHelper.query((String)"ictm_member_settle", (String)"id,org,datagenermethod,startdate,enddate", (QFilter[])SettleFacility.getDateFilter(startDate, endDate).toArray());
        List<Long> orgIds = dyoList.stream().map(m -> m.getLong("org")).distinct().collect(Collectors.toList());
        List<Long> allOrgIds = SettleFacility.getAllOrgIds(startDate, endDate, orgIds);
        List<DynamicObject> allTaxMains = IctmTaxMainCommonBusiness.getAllTaxMainByOrgId(allOrgIds);
        Map<Long, Long> acctcustomerMap = SettleFacility.getAcctcustomerMap(allTaxMains);
        Map<Long, Long> acctsupplierMap = SettleFacility.getAcctsupplierMap(allTaxMains);
        Map exchangeMap = SystemParamUtil.getAppParameterBatch((String)"ictm", (String)"exchange", orgIds);
        for (DynamicObject dynamicObject : dyoList) {
            DynamicObject bwbDyoFromDb = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getLong("id"), (String)"ictm_member_settle");
            SettleFacility.fetchRuleValue(bwbDyoFromDb, acctcustomerMap, acctsupplierMap, true, true);
            BigDecimal nonrelateincome = bwbDyoFromDb.getBigDecimal("allincome").subtract(bwbDyoFromDb.getBigDecimal("relateincome"));
            bwbDyoFromDb.set("nonrelateincome", (Object)nonrelateincome);
            SettleFacility.setCnyField(exchangeMap, bwbDyoFromDb.getLong("org.id"), bwbDyoFromDb);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bwbDyoFromDb});
        }
    }

    private void changeMethod() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection collection = billList.getSelectedRows();
        List ids = collection.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObject[] bwbDyoList = BusinessDataServiceHelper.load((String)"ictm_member_settle", (String)MetadataUtil.getAllFieldString((String)"ictm_member_settle"), (QFilter[])filter.toArray());
        String dataGenerMethod = bwbDyoList[0].getString("datagenermethod");
        if ("gzqs".equalsIgnoreCase(dataGenerMethod)) {
            for (DynamicObject bwbDyo : bwbDyoList) {
                for (MemberEntityItemNameEnum nameEnum : MemberEntityItemNameEnum.values()) {
                    bwbDyo.set(nameEnum.getField(), (Object)BigDecimal.ZERO);
                }
                for (String filed : IctmEntityConstant.SETTLE_NUM_FILEDS) {
                    if ("registeredcapital".equalsIgnoreCase(filed)) continue;
                    bwbDyo.set(filed + "cny", (Object)BigDecimal.ZERO);
                }
                bwbDyo.set("nonrelateincome", (Object)BigDecimal.ZERO);
                bwbDyo.set("datagenermethod", (Object)SGLR);
            }
            SaveServiceHelper.save((DynamicObject[])bwbDyoList);
        } else {
            for (DynamicObject dyo : bwbDyoList) {
                List<Long> orgIds = Collections.singletonList(dyo.getLong("org.id"));
                Date startDate = dyo.getDate("startdate");
                Date endDate = dyo.getDate("enddate");
                SettleFacility.calAndSaveData(orgIds, startDate, endDate, false);
            }
        }
        billList.refresh();
    }

    public void packageData(PackageDataEvent evt) {
        String currency = (String)this.getView().getParentView().getModel().getValue("currency");
        if (RMB.equalsIgnoreCase(currency)) {
            evt.getNoLinkKey().add(((ColumnDesc)evt.getSource()).getKey());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Date startdate = (Date)this.getView().getParentView().getModel().getValue("startdate");
        Date enddate = (Date)this.getView().getParentView().getModel().getValue("enddate");
        if (startdate == null || enddate == null) {
            args.setCancel(true);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        String currency = (String)this.getView().getParentView().getModel().getValue("currency");
        if (RMB.equalsIgnoreCase(currency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u672c\u4f4d\u5e01\u6761\u4ef6\u4e0b\u64cd\u4f5c\u3002", (String)"MemberEntitySettleListPlugin_1", (String)"taxc-ictm", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (!"org_number".equalsIgnoreCase(fieldName)) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
            Long pkId = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
            DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"ictm_member_settle");
            if (!"gzqs".equalsIgnoreCase(dyo.getString("datagenermethod"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u624b\u5de5\u5f55\u5165\u6570\u636e\u4e0b\u94bb\u5f39\u6846\u3002", (String)"MemberEntitySettleListPlugin_2", (String)"taxc-ictm", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            IFormView view = this.getView();
            HashMap customParams = Maps.newHashMapWithExpectedSize((int)32);
            customParams.put("org", dyo.getString("org.id"));
            List<Long> orgIds = SettleFacility.getOrgListHasPermissionAll();
            if (!orgIds.contains(dyo.getLong("org.id"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8be5\u7ec4\u7ec7\u6570\u636e\u4e0b\u94bb\u5f39\u6846\u6743\u9650\u3002", (String)"MemberEntitySettleListPlugin_3", (String)"taxc-ictm", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            customParams.put("sourceId", String.valueOf(pkId));
            customParams.put("skssqq", DateUtils.format((Date)dyo.getDate("startdate"), (String)"yyyy-MM-dd"));
            customParams.put("skssqz", DateUtils.format((Date)dyo.getDate("enddate"), (String)"yyyy-MM-dd"));
            customParams.put("operation", "EDIT");
            MemberEntityItemNameEnum byField = MemberEntityItemNameEnum.getByField(fieldName);
            customParams.put("templateId", byField.getItemId());
            customParams.put("isCal", false);
            customParams.put("datastatus", "1");
            customParams.put("cellid", "ictm_member_settle#" + fieldName);
            customParams.put("fromForm", "bdtaxr_rule_fetch_dialog");
            FormShowParameter param = new FormShowParameter();
            param.setFormId("bdtaxr_rule_fetch_dialog");
            param.setCustomParams((Map)customParams);
            if (customParams.get("customCaption") != null) {
                param.setCaption((String)customParams.get("customCaption"));
            }
            param.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "cell_click_popup");
            param.setCloseCallBack(closeCallBack);
            view.showForm(param);
            args.setCancel(true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        Object returnObj = event.getReturnData();
        if (ADDNEW.equals(event.getActionId()) && event.getReturnData() != null) {
            String orgids = SerializationUtils.toJsonString((Object)event.getReturnData());
            String orgStr = orgids.replace("]", "").replace("[", "");
            List<String> orgList = Arrays.asList(orgStr.split(","));
            List<Long> neworgList = orgList.stream().map(Long::parseLong).collect(Collectors.toList());
            Date startDate = (Date)this.getArg("startdate");
            Date endDate = (Date)this.getArg("enddate");
            Map exchangeMap = SystemParamUtil.getAppParameterBatch((String)"ictm", (String)"exchange", neworgList);
            Collection values = exchangeMap.values();
            if (values.contains(null)) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u524d\u5f80\u57fa\u7840\u670d\u52a1\u4e91-\u516c\u5171\u8bbe\u7f6e-\u53c2\u6570\u914d\u7f6e-\u7cfb\u7edf\u53c2\u6570-\u5e94\u7528-\u7a0e\u52a1\u4e91-\u5173\u8054\u4ea4\u6613\u7ba1\u7406\u7ef4\u62a4\u5e74\u5e73\u5747\u6c47\u7387\u8868\u3002", (String)"MemberEntitySettleListPlugin_4", (String)"taxc-ictm", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                return;
            }
            SettleFacility.calAndSaveData(neworgList, startDate, endDate, false);
            this.recalInterValue(startDate, endDate);
            billList.refresh();
        } else if (returnObj != null && "cell_click_popup".equals(event.getActionId())) {
            Map returnData = (Map)returnObj;
            String cellId = (String)returnData.get("cellid");
            String value = (String)returnData.get("adjustsumamout");
            long sourceId = Long.parseLong(String.valueOf(returnData.get("sourceId")));
            DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"ictm_member_settle");
            dyo.set(cellId.replace("ictm_member_settle#", ""), (Object)new BigDecimal(value));
            BigDecimal nonrelateincome = dyo.getBigDecimal("allincome").subtract(dyo.getBigDecimal("relateincome"));
            dyo.set("nonrelateincome", (Object)nonrelateincome);
            Map exchangeMap = SystemParamUtil.getAppParameterBatch((String)"ictm", (String)"exchange", Collections.singletonList(dyo.getLong("org.id")));
            SettleFacility.setCnyField(exchangeMap, dyo.getLong("org.id"), dyo);
            Map ruleFetchData = (Map)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"updateCellEntityMap", Map.class);
            RuleFetchServiceImpl ruleFetchService = new RuleFetchServiceImpl();
            ruleFetchService.saveRuleFetchAdjustData(ruleFetchData, null);
            this.getPageCache().remove("updateCellEntityMap");
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dyo});
            billList.refresh();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        MessageBoxResult result = e.getResult();
        if (MessageBoxResult.Cancel == result) {
            return;
        }
        String callBackId = e.getCallBackId();
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        DynamicObjectCollection dyoList = this.getDefaultList();
        List<Long> orgIds = dyoList.stream().map(m -> m.getLong("org")).distinct().collect(Collectors.toList());
        orgIds.retainAll(SettleFacility.getOrgListHasPermissionAll());
        if ("resetdata".equals(callBackId) || "retrievedata".equals(callBackId)) {
            for (DynamicObject dyo : dyoList) {
                orgIds = Collections.singletonList(dyo.getLong("org"));
                Date startDate = dyo.getDate("startdate");
                Date endDate = dyo.getDate("enddate");
                SettleFacility.calAndSaveData(orgIds, startDate, endDate, "retrievedata".equals(callBackId));
            }
        }
        billList.refresh();
    }

    private DynamicObjectCollection getDefaultList() {
        QFilter qFilter;
        Date startDate = (Date)this.getView().getParentView().getModel().getValue("startdate");
        Date endDate = (Date)this.getView().getParentView().getModel().getValue("enddate");
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection collection = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)collection)) {
            qFilter = SettleFacility.getDateFilter(startDate, endDate);
        } else {
            List collect = collection.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            qFilter = new QFilter("id", "in", collect);
        }
        return QueryServiceHelper.query((String)"ictm_member_settle", (String)"id,org,datagenermethod,startdate,enddate", (QFilter[])qFilter.toArray());
    }

    private Object getArg(String key) {
        if (!("currency".equals(key) || "startdate".equals(key) || "enddate".equals(key))) {
            return null;
        }
        return this.getView().getParentView().getModel().getValue(key);
    }

    private void checkRetrievedata(BeforeItemClickEvent evt) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection collection = billList.getSelectedRows();
        String value = (String)this.getView().getParentView().getModel().getValue("currency");
        if (RMB.equalsIgnoreCase(value)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u672c\u4f4d\u5e01\u6761\u4ef6\u4e0b\u64cd\u4f5c\u3002", (String)"MemberEntitySettleListPlugin_1", (String)"taxc-ictm", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObjectCollection dyoList = this.getDefaultList();
        List collect = dyoList.stream().map(m -> m.getString("datagenermethod")).distinct().collect(Collectors.toList());
        if (collect.contains(SGLR)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u751f\u6210\u65b9\u5f0f=\u89c4\u5219\u53d6\u6570\u7684\u6570\u636e\u53ef\u91cd\u53d6\u3002", (String)"MemberEntitySettleListPlugin_5", (String)"taxc-ictm", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (this.checkExchangeMap(evt, dyoList)) {
            return;
        }
        String msg = CollectionUtils.isEmpty((Collection)collection) ? ResManager.loadKDString((String)"\u7ee7\u7eed\u64cd\u4f5c\u5c06\u6e05\u7a7a\u5e76\u91cd\u65b0\u751f\u6210\u6240\u6709\u5f53\u524d\u7528\u6237\u6709\u6743\u9650\u7684\u6210\u5458\u5b9e\u4f53\u672a\u7ecf\u624b\u5de5\u8c03\u6574\u7684\u9879\u76ee\u89c4\u5219\u53d6\u6570\u7ed3\u679c\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u6267\u884c\uff1f", (String)"MemberEntitySettleListPlugin_6", (String)"taxc-ictm", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7ee7\u7eed\u64cd\u4f5c\u5c06\u6e05\u7a7a\u5e76\u91cd\u65b0\u751f\u6210\u5f53\u524d\u6240\u9009\u6210\u5458\u5b9e\u4f53\u672a\u7ecf\u624b\u5de5\u8c03\u6574\u7684\u89c4\u5219\u53d6\u6570\u7ed3\u679c\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u6267\u884c\uff1f", (String)"MemberEntitySettleListPlugin_7", (String)"taxc-ictm", (Object[])new Object[0]);
        evt.setCancel(true);
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("retrievedata", (IFormPlugin)this);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    private boolean checkExchangeMap(BeforeItemClickEvent evt, DynamicObjectCollection dyoList) {
        List orgIds;
        Map exchangeMap;
        Collection values;
        if (CollectionUtils.isNotEmpty((Collection)dyoList) && (values = (exchangeMap = SystemParamUtil.getAppParameterBatch((String)"ictm", (String)"exchange", orgIds = dyoList.stream().map(m -> m.getLong("org")).distinct().collect(Collectors.toList()))).values()).contains(null)) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u524d\u5f80\u57fa\u7840\u670d\u52a1\u4e91-\u516c\u5171\u8bbe\u7f6e-\u53c2\u6570\u914d\u7f6e-\u7cfb\u7edf\u53c2\u6570-\u5e94\u7528-\u7a0e\u52a1\u4e91-\u5173\u8054\u4ea4\u6613\u7ba1\u7406\u7ef4\u62a4\u5e74\u5e73\u5747\u6c47\u7387\u8868\u3002", (String)"MemberEntitySettleListPlugin_4", (String)"taxc-ictm", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            evt.setCancel(true);
            return true;
        }
        return false;
    }

    private void checkResetdataCilck(BeforeItemClickEvent evt) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection collection = billList.getSelectedRows();
        String value = (String)this.getView().getParentView().getModel().getValue("currency");
        if (RMB.equalsIgnoreCase(value)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u672c\u4f4d\u5e01\u6761\u4ef6\u4e0b\u64cd\u4f5c\u3002", (String)"MemberEntitySettleListPlugin_1", (String)"taxc-ictm", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObjectCollection dyoList = this.getDefaultList();
        List collect = dyoList.stream().map(m -> m.getString("datagenermethod")).distinct().collect(Collectors.toList());
        if (collect.contains(SGLR)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u751f\u6210\u65b9\u5f0f=\u89c4\u5219\u53d6\u6570\u7684\u6570\u636e\u53ef\u91cd\u7f6e\u3002", (String)"MemberEntitySettleListPlugin_8", (String)"taxc-ictm", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (this.checkExchangeMap(evt, dyoList)) {
            return;
        }
        String msg = CollectionUtils.isEmpty((Collection)collection) ? ResManager.loadKDString((String)"\u7ee7\u7eed\u64cd\u4f5c\u5c06\u6e05\u7a7a\u5e76\u91cd\u65b0\u751f\u6210\u6240\u6709\u5f53\u524d\u7528\u6237\u6709\u6743\u9650\u7684\u6210\u5458\u5b9e\u4f53\u9879\u76ee\u89c4\u5219\u53d6\u6570\u7ed3\u679c\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u6267\u884c\uff1f", (String)"MemberEntitySettleListPlugin_9", (String)"taxc-ictm", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7ee7\u7eed\u64cd\u4f5c\u5c06\u6e05\u7a7a\u5e76\u91cd\u65b0\u751f\u6210\u5f53\u524d\u6240\u9009\u6210\u5458\u5b9e\u4f53\u9879\u76ee\u89c4\u5219\u53d6\u6570\u7ed3\u679c\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u6267\u884c\uff1f", (String)"MemberEntitySettleListPlugin_10", (String)"taxc-ictm", (Object[])new Object[0]);
        evt.setCancel(true);
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("resetdata", (IFormPlugin)this);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBackListener);
    }
}

