/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.settle;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class MemberEntitySettlePlugin
extends AbstractFormPlugin {
    private static final String KEY_TOOLBAR = "toolbarap";
    private static final String LIST_CONTENT = "listcontent";
    private static final String CLOSE = "close";

    public void initialize() {
        this.addItemClickListeners(new String[]{KEY_TOOLBAR});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("startdate") && customParams.containsKey("enddate")) {
            this.getView().getModel().setValue("startdate", customParams.get("startdate"));
            this.getView().getModel().setValue("enddate", customParams.get("enddate"));
        } else {
            Date endDate = DateUtils.getLastDateOfYear((Date)DateUtils.addYear((Date)new Date(), (int)-1));
            this.getView().getModel().setValue("startdate", (Object)DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)new Date(), (int)-1)));
            this.getView().getModel().setValue("enddate", (Object)endDate);
        }
        this.openChildPage();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        if (newValue == null && null != changeSet[0].getOldValue()) {
            this.getModel().getDataEntity().set(name, changeSet[0].getOldValue());
            this.getView().updateView(name);
            return;
        }
        if ("startdate".equals(name)) {
            Boolean yearDate;
            if (newValue == null) {
                return;
            }
            int startMonth = DateUtils.getMonthOfDate((Date)((Date)newValue));
            int startDay = DateUtils.getDayOfDate((Date)((Date)newValue));
            if (startMonth == 1 && startDay == 1) {
                this.getModel().getDataEntity().set("enddate", (Object)DateUtils.getLastDateOfYear((Date)((Date)newValue)));
                this.getView().updateView("enddate");
            }
            if (!(yearDate = this.isYearDate((Date)newValue, this.getModel().getDataEntity().getDate("enddate"))).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f1a\u8ba1\u5e74\u5ea6\u5fc5\u987b\u4e3a\u516c\u5386\u6574\u5e74\u3002", (String)"MemberEntitySettlePlugin_0", (String)"taxc-ictm", (Object[])new Object[0]));
                return;
            }
        } else if ("enddate".equals(name)) {
            Boolean yearDate;
            if (newValue == null) {
                return;
            }
            int endMonth = DateUtils.getMonthOfDate((Date)((Date)newValue));
            int endDay = DateUtils.getDayOfDate((Date)((Date)newValue));
            if (endMonth == 12 && endDay == 31) {
                this.getModel().getDataEntity().set("startdate", (Object)DateUtils.getFirstDateOfYear((Date)((Date)newValue)));
                this.getView().updateView("startdate");
            }
            if (!(yearDate = this.isYearDate(this.getModel().getDataEntity().getDate("startdate"), (Date)newValue)).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f1a\u8ba1\u5e74\u5ea6\u5fc5\u987b\u4e3a\u516c\u5386\u6574\u5e74\u3002", (String)"MemberEntitySettlePlugin_0", (String)"taxc-ictm", (Object[])new Object[0]));
                return;
            }
        }
        this.openChildPage();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)CLOSE)) {
            this.getView().close();
        }
    }

    private Boolean isYearDate(Date startDate, Date endDate) {
        int startYear = DateUtils.getYearOfDate((Date)startDate);
        int startMonth = DateUtils.getMonthOfDate((Date)startDate);
        int startDay = DateUtils.getDayOfDate((Date)startDate);
        int endYear = DateUtils.getYearOfDate((Date)endDate);
        int endMonth = DateUtils.getMonthOfDate((Date)endDate);
        int endDay = DateUtils.getDayOfDate((Date)endDate);
        return startYear == endYear && startMonth == 1 && startDay == 1 && endMonth == 12 && endDay == 31;
    }

    private void openChildPage() {
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        Date startDate = (Date)this.getView().getModel().getValue("startdate");
        Date endDate = (Date)this.getView().getModel().getValue("enddate");
        String currency = (String)this.getView().getModel().getValue("currency");
        if (StringUtils.isEmpty((CharSequence)currency)) {
            currency = "bwb";
        }
        customParams.put("startdate", DateUtils.format((Date)startDate));
        customParams.put("enddate", DateUtils.format((Date)endDate));
        customParams.put("currency", currency);
        String childPageId = this.showBillList(LIST_CONTENT, "ictm_member_settle", this.getView(), customParams);
        this.getPageCache().put(LIST_CONTENT, childPageId);
    }

    public String showBillList(String targetKey, String pageName, IFormView view, Map<String, Object> customParams) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(pageName);
        listShowParameter.setFormId("bos_list");
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE));
        if (customParams == null) {
            listShowParameter.setCustomParams(new HashMap());
        } else {
            listShowParameter.setCustomParams(customParams);
        }
        listShowParameter.getOpenStyle().setTargetKey(targetKey);
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        view.showForm((FormShowParameter)listShowParameter);
        return listShowParameter.getPageId();
    }
}

