/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.listop.ImportData;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.ictm.common.util.BigDecimalUtil;
import kd.taxc.ictm.common.util.PermissionUtils;
import kd.taxc.ictm.common.util.TreeUtils;
import kd.taxc.ictm.formplugin.business.PriceFormulaCalcHelper;
import kd.taxc.ictm.formplugin.ictmenum.DataTableenum;
import kd.taxc.ictm.formplugin.ictmenum.IctmTaxpayerenum;
import kd.taxc.ictm.formplugin.settle.LaborServiceSettleListPlugin;

public class RelatedTransactionSettlePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(RelatedTransactionSettlePlugin.class);
    private static final String ENTRYENTITY = "entryentity";
    private static final String SELECT_SETTLE_DATA = "ictm_select_settle_data";
    private static final String BALANCE_TABLE_NAME = "tdm_balance_new";
    private static String QUERY_FIELDS = "id,org.id,accountbookstype,billno,subaccount19,debitlocalcurrency,creditlocalcurrency,openinglocalcurrency,closinglocalcurrency,datasource,sourcesys";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit purchasername = (BasedataEdit)this.getControl("purchasercode");
        purchasername.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit sellername = (BasedataEdit)this.getControl("sellercode");
        sellername.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"toolbarap", "toolbarap1", "toolbarap2", "toolbarap11"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap2"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap3", "advconap4", "advconap5"});
    }

    public void afterBindData(EventObject e) {
        this.visibleOrhide();
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("importdata".equals(itemKey) || "importdata1".equals(itemKey) || "importdata11".equals(itemKey)) {
            this.getView().invokeOperation("save");
            this.importData();
        } else if ("selectsettledata".equals(itemKey)) {
            this.selectSettleData(true);
        }
    }

    public void selectSettleData(boolean isAddOrg) {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)SELECT_SETTLE_DATA, (boolean)true, (int)2);
        parameter.setFormId(SELECT_SETTLE_DATA);
        parameter.setParentPageId(this.getView().getPageId());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss sc = new StyleCss();
        sc.setHeight("660px");
        sc.setWidth("1200px");
        parameter.getOpenStyle().setInlineStyleCss(sc);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectsettle"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        formShowParameter.setCustomParam("orgViewSchemeNumber", (Object)"10_taxc");
        formShowParameter.getCustomParams().put("orgFuncId", "947076820862300160");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7", (String)"RelatedTransactionSettlePlugin_0", (String)"taxc-ictm", (Object[])new Object[0]));
        List<Long> orgIds = this.getOrgListHasPermission();
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        List<Long> newOrgIds = this.getNewOrgIdsByhanler(orgIds);
        QFilter orgIdsFilter = new QFilter("id", "in", newOrgIds);
        formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
        formShowParameter.setMultiSelect(false);
    }

    private List<Long> getNewOrgIdsByhanler(List<Long> orgIds) {
        QFilter orgFileter = new QFilter("orgid", "in", orgIds);
        QFilter istaxpayerFileter = new QFilter("taxorg.istaxpayer", "=", (Object)true);
        QFilter unifiedsocialcodeFileter = new QFilter("taxorg.unifiedsocialcode", "is not null", null);
        DynamicObjectCollection objCollection = QueryServiceHelper.query((String)"tctb_tax_main", (String)"orgid,taxorg.unifiedsocialcode as unifiedsocialcode,accountingstandards.id as accountingstandardsid,taxoffice.id as taxofficeid,registeraddress,registeraddrdetail,taxorg.istaxpayer", (QFilter[])new QFilter[]{orgFileter, unifiedsocialcodeFileter, istaxpayerFileter});
        List<Long> newOrgIds = objCollection.stream().map(o -> o.getLong("orgid")).collect(Collectors.toList());
        return newOrgIds;
    }

    private List<Long> getOrgListHasPermission() {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs(this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission(hasPermOrgs, true);
        if (!CollectionUtils.isEmpty((Collection)col)) {
            for (DynamicObject obj : col) {
                orgIds.add(obj.getLong("id"));
            }
        }
        return orgIds;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("purchasercode".equals(name) || "sellercode".equals(name)) {
            this.displayCorresInformation((DynamicObject)this.getView().getModel().getValue(name), name);
        } else if ("pricerule".equals(name)) {
            this.visibleOrhide();
        } else if ("hldate".equals(name)) {
            this.sethl();
        }
    }

    private void sethl() {
        DynamicObject bwb = (DynamicObject)this.getView().getModel().getValue("bwb");
        DynamicObject jsbb = (DynamicObject)this.getView().getModel().getValue("jsbb");
        DynamicObject hlb = (DynamicObject)this.getView().getModel().getValue("hlb");
        Date hldate = (Date)this.getView().getModel().getValue("hldate");
        QFilter orgcurFileter = new QFilter("orgcur", "=", (Object)bwb.getLong("id"));
        QFilter curFileter = new QFilter("cur", "=", (Object)jsbb.getLong("id"));
        QFilter exctableFileter = new QFilter("exctable", "=", (Object)hlb.getLong("id"));
        QFilter effectdateFileter = new QFilter("effectdate", "<=", (Object)hldate);
        DynamicObjectCollection objCollection = QueryServiceHelper.query((String)"bd_exrate_tree", (String)"excval,effectdate", (QFilter[])new QFilter[]{orgcurFileter, curFileter, exctableFileter, effectdateFileter});
        if (objCollection.size() > 0) {
            objCollection.sort(Comparator.comparing(d -> d.getDate("effectdate")).reversed());
            this.getView().getModel().setValue("hl", (Object)((DynamicObject)objCollection.get(0)).getBigDecimal("excval"));
        }
    }

    private void visibleOrhide() {
        DynamicObject priceruleDynamicObject = (DynamicObject)this.getView().getModel().getValue("pricerule");
        if (priceruleDynamicObject == null) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{DataTableenum.SUBJECT.getVisbileid()});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap3", "advconap4", "advconap5"});
        } else {
            BigDecimal ratio = priceruleDynamicObject.getBigDecimal("ratio");
            this.getView().getModel().setValue("ratio", (Object)ratio);
            String datatable = ((DynamicObject)((DynamicObject)priceruleDynamicObject.getDynamicObjectCollection(ENTRYENTITY).get(0)).get("table")).getString("entityname");
            this.getPageCache().put("djtype", datatable);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{DataTableenum.getVisbileidByCode(datatable)});
            String[] hideidStrings = DataTableenum.getHideidByCode(datatable);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{hideidStrings[0], hideidStrings[1], hideidStrings[2]});
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
    }

    private void displayCorresInformation(DynamicObject dynamicObject, String name) {
        QFilter orgFileter = new QFilter("orgid", "=", (Object)Long.parseLong(dynamicObject.getString("id")));
        DynamicObject obj = QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"taxorg.unifiedsocialcode as unifiedsocialcode,accountingstandards.id as accountingstandardsid,taxoffice.id as taxofficeid,registeraddress,registeraddrdetail", (QFilter[])new QFilter[]{orgFileter});
        this.getView().getModel().setValue(IctmTaxpayerenum.getNameByCode(name), (Object)dynamicObject.getString("name"));
        this.getView().getModel().setValue(IctmTaxpayerenum.getZcshByCode(name), (Object)obj.getString("unifiedsocialcode"));
        this.getView().getModel().setValue(IctmTaxpayerenum.getSykjzcByCode(name), (Object)obj.getString("accountingstandardsid"));
        this.getView().getModel().setValue(IctmTaxpayerenum.getZgswjgByCode(name), (Object)obj.getString("taxofficeid"));
        DynamicObject fullNameDynamicObject = this.getAdmindivision(obj.getLong("registeraddress"));
        String provinceName = null;
        if (fullNameDynamicObject != null) {
            provinceName = fullNameDynamicObject.getString("fullname");
        }
        this.getView().getModel().setValue(IctmTaxpayerenum.getSsgjByCode(name), (Object)provinceName);
        this.getView().getModel().setValue(IctmTaxpayerenum.getZcdzByCode(name), (Object)obj.getString("registeraddrdetail"));
    }

    private DynamicObject getAdmindivision(Long id) {
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        return QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"id, parent, basedatafield, longnumber,country.name as fullname", (QFilter[])new QFilter[]{idFilter});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save || args.getSource() instanceof Submit) {
            if (args.getSource() instanceof Submit) {
                // empty if block
            }
        } else if (args.getSource() instanceof ImportData) {
            this.getView().invokeOperation("save");
        }
    }

    private void importData() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_importstart");
        showParameter.setCustomParam("BillFormId", (Object)"ictm_connect_trans_settle");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        ArrayList plugins = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Enabled", Boolean.TRUE);
        map.put("ClassName", LaborServiceSettleListPlugin.class.getName());
        plugins.add(map);
        showParameter.setCustomParam("plugins", plugins);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeimport"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if ("closeimport".equals(evt.getActionId())) {
            this.getView().invokeOperation("refresh");
        } else if ("selectsettle".equals(evt.getActionId())) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)evt.getReturnData();
            if (returnData != null) {
                List fids = returnData.stream().map(s -> (Long)s.getPrimaryKeyValue()).distinct().collect(Collectors.toList());
                QFilter qFilter = new QFilter("id", "in", fids);
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
                qFilters.add(qFilter);
                QFilter[] filters = new QFilter[qFilters.size()];
                qFilters.toArray(filters);
                DataSet mainDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)BALANCE_TABLE_NAME, (String)QUERY_FIELDS, (QFilter[])filters, (String)"billno");
                this.getModel().deleteEntryData("entryentity2");
                for (Row row : mainDataSet.copy()) {
                    BigDecimal closingCurrency;
                    BigDecimal openingCurrency;
                    String billNo = row.getString("billno");
                    String orgName = row.getString("org.id");
                    String accountbookstype = row.getString("accountbookstype");
                    String balanceName = row.getString("subaccount19");
                    String dataSource = row.getString("datasource");
                    String sourceSys = row.getString("sourcesys");
                    BigDecimal openingLocalCurrency = row.getBigDecimal("openinglocalcurrency");
                    if (BigDecimal.ZERO.compareTo(openingLocalCurrency) <= 0) {
                        openingCurrency = openingLocalCurrency.setScale(2, 4);
                        openingLocalCurrency = BigDecimal.valueOf(0.0);
                    } else {
                        openingLocalCurrency = openingLocalCurrency.setScale(2, 4).abs();
                        openingCurrency = BigDecimal.valueOf(0.0);
                    }
                    BigDecimal closingLocalCurrency = row.getBigDecimal("closinglocalcurrency");
                    if (BigDecimal.ZERO.compareTo(closingLocalCurrency) <= 0) {
                        closingCurrency = closingLocalCurrency.setScale(2, 4);
                        closingLocalCurrency = BigDecimal.valueOf(0.0);
                    } else {
                        closingLocalCurrency = closingLocalCurrency.setScale(2, 4).abs();
                        closingCurrency = BigDecimal.valueOf(0.0);
                    }
                    BigDecimal debitCurrentCurrency = row.getBigDecimal("debitlocalcurrency").setScale(2, 4);
                    BigDecimal creditCurrentCurrency = row.getBigDecimal("creditlocalcurrency").setScale(2, 4);
                    int index = this.getModel().createNewEntryRow("entryentity2");
                    this.getModel().setValue("org", (Object)orgName, index);
                    this.getModel().setValue("accounttype", (Object)accountbookstype, index);
                    this.getModel().setValue("subbillno", (Object)billNo, index);
                    this.getModel().setValue("subname", (Object)balanceName, index);
                    this.getModel().setValue("qcdebitamount", (Object)openingCurrency, index);
                    this.getModel().setValue("qccreditamount", (Object)openingLocalCurrency, index);
                    this.getModel().setValue("bqdebitamount", (Object)debitCurrentCurrency, index);
                    this.getModel().setValue("bqcreditamount", (Object)creditCurrentCurrency, index);
                    this.getModel().setValue("qmdebitamount", (Object)closingCurrency, index);
                    this.getModel().setValue("qmcreditamount", (Object)closingLocalCurrency, index);
                    this.getModel().setValue("datasource", (Object)dataSource, index);
                    this.getModel().setValue("sourcesys", (Object)sourceSys, index);
                }
            }
            this.setSettleDetails();
        }
    }

    private void setSettleDetails() {
        String hou;
        String qian;
        this.getModel().deleteEntryData(ENTRYENTITY);
        int row = this.getModel().createNewEntryRow(ENTRYENTITY);
        String djtype = this.getPageCache().get("djtype");
        if (djtype == null) {
            djtype = BALANCE_TABLE_NAME;
        }
        DynamicObjectCollection detailsEntity = this.getView().getModel().getEntryEntity(DataTableenum.getEntityByCode(djtype));
        String jsbase = DataTableenum.getTpjsbasisByCode(djtype);
        Boolean isLabor = false;
        String[] jsbases = jsbase.split(",");
        if (jsbases.length > 1) {
            qian = jsbases[0];
            hou = jsbases[1];
        } else {
            isLabor = true;
            qian = jsbases[0];
            hou = jsbases[0];
        }
        BigDecimal tptzqjssbb = BigDecimal.ZERO;
        BigDecimal qianBigDecimal = BigDecimal.ZERO;
        BigDecimal houBigDecimal = BigDecimal.ZERO;
        if (isLabor.booleanValue()) {
            tptzqjssbb = detailsEntity.stream().map(s -> s.getBigDecimal(qian)).reduce(BigDecimal.ZERO, BigDecimal::add);
        } else {
            qianBigDecimal = detailsEntity.stream().map(s -> s.getBigDecimal(qian)).reduce(BigDecimal.ZERO, BigDecimal::add);
            houBigDecimal = detailsEntity.stream().map(s -> s.getBigDecimal(hou)).reduce(BigDecimal.ZERO, BigDecimal::add);
            tptzqjssbb = BigDecimalUtil.subtractObject(qianBigDecimal, houBigDecimal, 2);
        }
        this.getModel().setValue("tptzqjssbb", (Object)tptzqjssbb, row);
        this.getModel().setValue("settlebb", this.getModel().getValue("jsbb"), row);
        this.getModel().setValue("rate", this.getModel().getValue("hl"), row);
        this.getModel().setValue("totalysje", (Object)BigDecimal.ZERO, row);
        this.getModel().setValue("totalyfje", (Object)BigDecimal.ZERO, row);
        BigDecimal jssbb = PriceFormulaCalcHelper.calcRelatedFormulaValue(this.getView().getModel().getDataEntity());
        this.getModel().setValue("jssbb", (Object)jssbb, row);
        this.getModel().setValue("tptzsbb", (Object)BigDecimalUtil.subtractObject(jssbb, this.getModel().getValue("tptzqjssbb", row)), row);
        this.getModel().setValue("settleamount", (Object)BigDecimalUtil.divideObject(BigDecimalUtil.multiplyObject(jssbb, this.getModel().getValue("hl"), 2), new BigDecimal(100), 2), row);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("refresh".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.setSettleDetails();
        }
    }

    private boolean validateDate(Date start, Date end) {
        return null == start || null == end || !start.after(end);
    }
}

